/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.ResourcePermission;
import com.amazonaws.services.quicksight.model.transform.LinkSharingConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LinkSharingConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ResourcePermission> permissions;

    public List<ResourcePermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Collection<ResourcePermission> permissions) {
        if (permissions == null) {
            this.permissions = null;
            return;
        }
        this.permissions = new ArrayList<ResourcePermission>(permissions);
    }

    public LinkSharingConfiguration withPermissions(ResourcePermission ... permissions) {
        if (this.permissions == null) {
            this.setPermissions(new ArrayList<ResourcePermission>(permissions.length));
        }
        for (ResourcePermission ele : permissions) {
            this.permissions.add(ele);
        }
        return this;
    }

    public LinkSharingConfiguration withPermissions(Collection<ResourcePermission> permissions) {
        this.setPermissions(permissions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPermissions() != null) {
            sb.append("Permissions: ").append(this.getPermissions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinkSharingConfiguration)) {
            return false;
        }
        LinkSharingConfiguration other = (LinkSharingConfiguration)obj;
        if (other.getPermissions() == null ^ this.getPermissions() == null) {
            return false;
        }
        return other.getPermissions() == null || other.getPermissions().equals(this.getPermissions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPermissions() == null ? 0 : this.getPermissions().hashCode());
        return hashCode;
    }

    public LinkSharingConfiguration clone() {
        try {
            return (LinkSharingConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LinkSharingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

