/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.InputColumn;
import com.amazonaws.services.quicksight.model.UploadSettings;
import com.amazonaws.services.quicksight.model.transform.S3SourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class S3Source
implements Serializable,
Cloneable,
StructuredPojo {
    private String dataSourceArn;
    private UploadSettings uploadSettings;
    private List<InputColumn> inputColumns;

    public void setDataSourceArn(String dataSourceArn) {
        this.dataSourceArn = dataSourceArn;
    }

    public String getDataSourceArn() {
        return this.dataSourceArn;
    }

    public S3Source withDataSourceArn(String dataSourceArn) {
        this.setDataSourceArn(dataSourceArn);
        return this;
    }

    public void setUploadSettings(UploadSettings uploadSettings) {
        this.uploadSettings = uploadSettings;
    }

    public UploadSettings getUploadSettings() {
        return this.uploadSettings;
    }

    public S3Source withUploadSettings(UploadSettings uploadSettings) {
        this.setUploadSettings(uploadSettings);
        return this;
    }

    public List<InputColumn> getInputColumns() {
        return this.inputColumns;
    }

    public void setInputColumns(Collection<InputColumn> inputColumns) {
        if (inputColumns == null) {
            this.inputColumns = null;
            return;
        }
        this.inputColumns = new ArrayList<InputColumn>(inputColumns);
    }

    public S3Source withInputColumns(InputColumn ... inputColumns) {
        if (this.inputColumns == null) {
            this.setInputColumns(new ArrayList<InputColumn>(inputColumns.length));
        }
        for (InputColumn ele : inputColumns) {
            this.inputColumns.add(ele);
        }
        return this;
    }

    public S3Source withInputColumns(Collection<InputColumn> inputColumns) {
        this.setInputColumns(inputColumns);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataSourceArn() != null) {
            sb.append("DataSourceArn: ").append(this.getDataSourceArn()).append(",");
        }
        if (this.getUploadSettings() != null) {
            sb.append("UploadSettings: ").append(this.getUploadSettings()).append(",");
        }
        if (this.getInputColumns() != null) {
            sb.append("InputColumns: ").append(this.getInputColumns());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Source)) {
            return false;
        }
        S3Source other = (S3Source)obj;
        if (other.getDataSourceArn() == null ^ this.getDataSourceArn() == null) {
            return false;
        }
        if (other.getDataSourceArn() != null && !other.getDataSourceArn().equals(this.getDataSourceArn())) {
            return false;
        }
        if (other.getUploadSettings() == null ^ this.getUploadSettings() == null) {
            return false;
        }
        if (other.getUploadSettings() != null && !other.getUploadSettings().equals(this.getUploadSettings())) {
            return false;
        }
        if (other.getInputColumns() == null ^ this.getInputColumns() == null) {
            return false;
        }
        return other.getInputColumns() == null || other.getInputColumns().equals(this.getInputColumns());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataSourceArn() == null ? 0 : this.getDataSourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getUploadSettings() == null ? 0 : this.getUploadSettings().hashCode());
        hashCode = 31 * hashCode + (this.getInputColumns() == null ? 0 : this.getInputColumns().hashCode());
        return hashCode;
    }

    public S3Source clone() {
        try {
            return (S3Source)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3SourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

