/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.DashboardVersion;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class DashboardVersionMarshaller {
    private static final MarshallingInfo<Date> CREATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> ERRORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Errors").build();
    private static final MarshallingInfo<Long> VERSIONNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionNumber").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").build();
    private static final MarshallingInfo<String> SOURCEENTITYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceEntityArn").build();
    private static final MarshallingInfo<List> DATASETARNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSetArns").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> THEMEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ThemeArn").build();
    private static final MarshallingInfo<List> SHEETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sheets").build();
    private static final DashboardVersionMarshaller instance = new DashboardVersionMarshaller();

    public static DashboardVersionMarshaller getInstance() {
        return instance;
    }

    public void marshall(DashboardVersion dashboardVersion, ProtocolMarshaller protocolMarshaller) {
        if (dashboardVersion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dashboardVersion.getCreatedTime(), CREATEDTIME_BINDING);
            protocolMarshaller.marshall(dashboardVersion.getErrors(), ERRORS_BINDING);
            protocolMarshaller.marshall((Object)dashboardVersion.getVersionNumber(), VERSIONNUMBER_BINDING);
            protocolMarshaller.marshall((Object)dashboardVersion.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)dashboardVersion.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)dashboardVersion.getSourceEntityArn(), SOURCEENTITYARN_BINDING);
            protocolMarshaller.marshall(dashboardVersion.getDataSetArns(), DATASETARNS_BINDING);
            protocolMarshaller.marshall((Object)dashboardVersion.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)dashboardVersion.getThemeArn(), THEMEARN_BINDING);
            protocolMarshaller.marshall(dashboardVersion.getSheets(), SHEETS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

