/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.quicksight.model.DashboardPublishOptions;
import com.amazonaws.services.quicksight.model.DashboardSourceEntity;
import com.amazonaws.services.quicksight.model.Parameters;
import com.amazonaws.services.quicksight.model.ResourcePermission;
import com.amazonaws.services.quicksight.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateDashboardRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String awsAccountId;
    private String dashboardId;
    private String name;
    private Parameters parameters;
    private List<ResourcePermission> permissions;
    private DashboardSourceEntity sourceEntity;
    private List<Tag> tags;
    private String versionDescription;
    private DashboardPublishOptions dashboardPublishOptions;
    private String themeArn;

    public void setAwsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
    }

    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    public CreateDashboardRequest withAwsAccountId(String awsAccountId) {
        this.setAwsAccountId(awsAccountId);
        return this;
    }

    public void setDashboardId(String dashboardId) {
        this.dashboardId = dashboardId;
    }

    public String getDashboardId() {
        return this.dashboardId;
    }

    public CreateDashboardRequest withDashboardId(String dashboardId) {
        this.setDashboardId(dashboardId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateDashboardRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public CreateDashboardRequest withParameters(Parameters parameters) {
        this.setParameters(parameters);
        return this;
    }

    public List<ResourcePermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Collection<ResourcePermission> permissions) {
        if (permissions == null) {
            this.permissions = null;
            return;
        }
        this.permissions = new ArrayList<ResourcePermission>(permissions);
    }

    public CreateDashboardRequest withPermissions(ResourcePermission ... permissions) {
        if (this.permissions == null) {
            this.setPermissions(new ArrayList<ResourcePermission>(permissions.length));
        }
        for (ResourcePermission ele : permissions) {
            this.permissions.add(ele);
        }
        return this;
    }

    public CreateDashboardRequest withPermissions(Collection<ResourcePermission> permissions) {
        this.setPermissions(permissions);
        return this;
    }

    public void setSourceEntity(DashboardSourceEntity sourceEntity) {
        this.sourceEntity = sourceEntity;
    }

    public DashboardSourceEntity getSourceEntity() {
        return this.sourceEntity;
    }

    public CreateDashboardRequest withSourceEntity(DashboardSourceEntity sourceEntity) {
        this.setSourceEntity(sourceEntity);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateDashboardRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateDashboardRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setVersionDescription(String versionDescription) {
        this.versionDescription = versionDescription;
    }

    public String getVersionDescription() {
        return this.versionDescription;
    }

    public CreateDashboardRequest withVersionDescription(String versionDescription) {
        this.setVersionDescription(versionDescription);
        return this;
    }

    public void setDashboardPublishOptions(DashboardPublishOptions dashboardPublishOptions) {
        this.dashboardPublishOptions = dashboardPublishOptions;
    }

    public DashboardPublishOptions getDashboardPublishOptions() {
        return this.dashboardPublishOptions;
    }

    public CreateDashboardRequest withDashboardPublishOptions(DashboardPublishOptions dashboardPublishOptions) {
        this.setDashboardPublishOptions(dashboardPublishOptions);
        return this;
    }

    public void setThemeArn(String themeArn) {
        this.themeArn = themeArn;
    }

    public String getThemeArn() {
        return this.themeArn;
    }

    public CreateDashboardRequest withThemeArn(String themeArn) {
        this.setThemeArn(themeArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAwsAccountId() != null) {
            sb.append("AwsAccountId: ").append(this.getAwsAccountId()).append(",");
        }
        if (this.getDashboardId() != null) {
            sb.append("DashboardId: ").append(this.getDashboardId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getPermissions() != null) {
            sb.append("Permissions: ").append(this.getPermissions()).append(",");
        }
        if (this.getSourceEntity() != null) {
            sb.append("SourceEntity: ").append(this.getSourceEntity()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVersionDescription() != null) {
            sb.append("VersionDescription: ").append(this.getVersionDescription()).append(",");
        }
        if (this.getDashboardPublishOptions() != null) {
            sb.append("DashboardPublishOptions: ").append(this.getDashboardPublishOptions()).append(",");
        }
        if (this.getThemeArn() != null) {
            sb.append("ThemeArn: ").append(this.getThemeArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDashboardRequest)) {
            return false;
        }
        CreateDashboardRequest other = (CreateDashboardRequest)obj;
        if (other.getAwsAccountId() == null ^ this.getAwsAccountId() == null) {
            return false;
        }
        if (other.getAwsAccountId() != null && !other.getAwsAccountId().equals(this.getAwsAccountId())) {
            return false;
        }
        if (other.getDashboardId() == null ^ this.getDashboardId() == null) {
            return false;
        }
        if (other.getDashboardId() != null && !other.getDashboardId().equals(this.getDashboardId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getPermissions() == null ^ this.getPermissions() == null) {
            return false;
        }
        if (other.getPermissions() != null && !other.getPermissions().equals(this.getPermissions())) {
            return false;
        }
        if (other.getSourceEntity() == null ^ this.getSourceEntity() == null) {
            return false;
        }
        if (other.getSourceEntity() != null && !other.getSourceEntity().equals(this.getSourceEntity())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVersionDescription() == null ^ this.getVersionDescription() == null) {
            return false;
        }
        if (other.getVersionDescription() != null && !other.getVersionDescription().equals(this.getVersionDescription())) {
            return false;
        }
        if (other.getDashboardPublishOptions() == null ^ this.getDashboardPublishOptions() == null) {
            return false;
        }
        if (other.getDashboardPublishOptions() != null && !other.getDashboardPublishOptions().equals(this.getDashboardPublishOptions())) {
            return false;
        }
        if (other.getThemeArn() == null ^ this.getThemeArn() == null) {
            return false;
        }
        return other.getThemeArn() == null || other.getThemeArn().equals(this.getThemeArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAwsAccountId() == null ? 0 : this.getAwsAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getDashboardId() == null ? 0 : this.getDashboardId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getPermissions() == null ? 0 : this.getPermissions().hashCode());
        hashCode = 31 * hashCode + (this.getSourceEntity() == null ? 0 : this.getSourceEntity().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVersionDescription() == null ? 0 : this.getVersionDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDashboardPublishOptions() == null ? 0 : this.getDashboardPublishOptions().hashCode());
        hashCode = 31 * hashCode + (this.getThemeArn() == null ? 0 : this.getThemeArn().hashCode());
        return hashCode;
    }

    public CreateDashboardRequest clone() {
        return (CreateDashboardRequest)super.clone();
    }
}

