/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.quicksight.model.ResourcePermission;
import com.amazonaws.services.quicksight.model.Tag;
import com.amazonaws.services.quicksight.model.ThemeConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateThemeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String awsAccountId;
    private String themeId;
    private String name;
    private String baseThemeId;
    private String versionDescription;
    private ThemeConfiguration configuration;
    private List<ResourcePermission> permissions;
    private List<Tag> tags;

    public void setAwsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
    }

    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    public CreateThemeRequest withAwsAccountId(String awsAccountId) {
        this.setAwsAccountId(awsAccountId);
        return this;
    }

    public void setThemeId(String themeId) {
        this.themeId = themeId;
    }

    public String getThemeId() {
        return this.themeId;
    }

    public CreateThemeRequest withThemeId(String themeId) {
        this.setThemeId(themeId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateThemeRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setBaseThemeId(String baseThemeId) {
        this.baseThemeId = baseThemeId;
    }

    public String getBaseThemeId() {
        return this.baseThemeId;
    }

    public CreateThemeRequest withBaseThemeId(String baseThemeId) {
        this.setBaseThemeId(baseThemeId);
        return this;
    }

    public void setVersionDescription(String versionDescription) {
        this.versionDescription = versionDescription;
    }

    public String getVersionDescription() {
        return this.versionDescription;
    }

    public CreateThemeRequest withVersionDescription(String versionDescription) {
        this.setVersionDescription(versionDescription);
        return this;
    }

    public void setConfiguration(ThemeConfiguration configuration) {
        this.configuration = configuration;
    }

    public ThemeConfiguration getConfiguration() {
        return this.configuration;
    }

    public CreateThemeRequest withConfiguration(ThemeConfiguration configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public List<ResourcePermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Collection<ResourcePermission> permissions) {
        if (permissions == null) {
            this.permissions = null;
            return;
        }
        this.permissions = new ArrayList<ResourcePermission>(permissions);
    }

    public CreateThemeRequest withPermissions(ResourcePermission ... permissions) {
        if (this.permissions == null) {
            this.setPermissions(new ArrayList<ResourcePermission>(permissions.length));
        }
        for (ResourcePermission ele : permissions) {
            this.permissions.add(ele);
        }
        return this;
    }

    public CreateThemeRequest withPermissions(Collection<ResourcePermission> permissions) {
        this.setPermissions(permissions);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateThemeRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateThemeRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAwsAccountId() != null) {
            sb.append("AwsAccountId: ").append(this.getAwsAccountId()).append(",");
        }
        if (this.getThemeId() != null) {
            sb.append("ThemeId: ").append(this.getThemeId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getBaseThemeId() != null) {
            sb.append("BaseThemeId: ").append(this.getBaseThemeId()).append(",");
        }
        if (this.getVersionDescription() != null) {
            sb.append("VersionDescription: ").append(this.getVersionDescription()).append(",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getPermissions() != null) {
            sb.append("Permissions: ").append(this.getPermissions()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThemeRequest)) {
            return false;
        }
        CreateThemeRequest other = (CreateThemeRequest)obj;
        if (other.getAwsAccountId() == null ^ this.getAwsAccountId() == null) {
            return false;
        }
        if (other.getAwsAccountId() != null && !other.getAwsAccountId().equals(this.getAwsAccountId())) {
            return false;
        }
        if (other.getThemeId() == null ^ this.getThemeId() == null) {
            return false;
        }
        if (other.getThemeId() != null && !other.getThemeId().equals(this.getThemeId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getBaseThemeId() == null ^ this.getBaseThemeId() == null) {
            return false;
        }
        if (other.getBaseThemeId() != null && !other.getBaseThemeId().equals(this.getBaseThemeId())) {
            return false;
        }
        if (other.getVersionDescription() == null ^ this.getVersionDescription() == null) {
            return false;
        }
        if (other.getVersionDescription() != null && !other.getVersionDescription().equals(this.getVersionDescription())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getPermissions() == null ^ this.getPermissions() == null) {
            return false;
        }
        if (other.getPermissions() != null && !other.getPermissions().equals(this.getPermissions())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAwsAccountId() == null ? 0 : this.getAwsAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getThemeId() == null ? 0 : this.getThemeId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getBaseThemeId() == null ? 0 : this.getBaseThemeId().hashCode());
        hashCode = 31 * hashCode + (this.getVersionDescription() == null ? 0 : this.getVersionDescription().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getPermissions() == null ? 0 : this.getPermissions().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateThemeRequest clone() {
        return (CreateThemeRequest)super.clone();
    }
}

