/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.AnalysisError;
import com.amazonaws.services.quicksight.model.ResourceStatus;
import com.amazonaws.services.quicksight.model.transform.AnalysisMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Analysis
implements Serializable,
Cloneable,
StructuredPojo {
    private String analysisId;
    private String arn;
    private String name;
    private String status;
    private List<AnalysisError> errors;
    private List<String> dataSetArns;
    private String themeArn;
    private Date createdTime;
    private Date lastUpdatedTime;

    public void setAnalysisId(String analysisId) {
        this.analysisId = analysisId;
    }

    public String getAnalysisId() {
        return this.analysisId;
    }

    public Analysis withAnalysisId(String analysisId) {
        this.setAnalysisId(analysisId);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Analysis withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Analysis withName(String name) {
        this.setName(name);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Analysis withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Analysis withStatus(ResourceStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<AnalysisError> getErrors() {
        return this.errors;
    }

    public void setErrors(Collection<AnalysisError> errors) {
        if (errors == null) {
            this.errors = null;
            return;
        }
        this.errors = new ArrayList<AnalysisError>(errors);
    }

    public Analysis withErrors(AnalysisError ... errors) {
        if (this.errors == null) {
            this.setErrors(new ArrayList<AnalysisError>(errors.length));
        }
        for (AnalysisError ele : errors) {
            this.errors.add(ele);
        }
        return this;
    }

    public Analysis withErrors(Collection<AnalysisError> errors) {
        this.setErrors(errors);
        return this;
    }

    public List<String> getDataSetArns() {
        return this.dataSetArns;
    }

    public void setDataSetArns(Collection<String> dataSetArns) {
        if (dataSetArns == null) {
            this.dataSetArns = null;
            return;
        }
        this.dataSetArns = new ArrayList<String>(dataSetArns);
    }

    public Analysis withDataSetArns(String ... dataSetArns) {
        if (this.dataSetArns == null) {
            this.setDataSetArns(new ArrayList<String>(dataSetArns.length));
        }
        for (String ele : dataSetArns) {
            this.dataSetArns.add(ele);
        }
        return this;
    }

    public Analysis withDataSetArns(Collection<String> dataSetArns) {
        this.setDataSetArns(dataSetArns);
        return this;
    }

    public void setThemeArn(String themeArn) {
        this.themeArn = themeArn;
    }

    public String getThemeArn() {
        return this.themeArn;
    }

    public Analysis withThemeArn(String themeArn) {
        this.setThemeArn(themeArn);
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Analysis withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Analysis withLastUpdatedTime(Date lastUpdatedTime) {
        this.setLastUpdatedTime(lastUpdatedTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAnalysisId() != null) {
            sb.append("AnalysisId: ").append(this.getAnalysisId()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getErrors() != null) {
            sb.append("Errors: ").append(this.getErrors()).append(",");
        }
        if (this.getDataSetArns() != null) {
            sb.append("DataSetArns: ").append(this.getDataSetArns()).append(",");
        }
        if (this.getThemeArn() != null) {
            sb.append("ThemeArn: ").append(this.getThemeArn()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getLastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(this.getLastUpdatedTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Analysis)) {
            return false;
        }
        Analysis other = (Analysis)obj;
        if (other.getAnalysisId() == null ^ this.getAnalysisId() == null) {
            return false;
        }
        if (other.getAnalysisId() != null && !other.getAnalysisId().equals(this.getAnalysisId())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getErrors() == null ^ this.getErrors() == null) {
            return false;
        }
        if (other.getErrors() != null && !other.getErrors().equals(this.getErrors())) {
            return false;
        }
        if (other.getDataSetArns() == null ^ this.getDataSetArns() == null) {
            return false;
        }
        if (other.getDataSetArns() != null && !other.getDataSetArns().equals(this.getDataSetArns())) {
            return false;
        }
        if (other.getThemeArn() == null ^ this.getThemeArn() == null) {
            return false;
        }
        if (other.getThemeArn() != null && !other.getThemeArn().equals(this.getThemeArn())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getLastUpdatedTime() == null ^ this.getLastUpdatedTime() == null) {
            return false;
        }
        return other.getLastUpdatedTime() == null || other.getLastUpdatedTime().equals(this.getLastUpdatedTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAnalysisId() == null ? 0 : this.getAnalysisId().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getErrors() == null ? 0 : this.getErrors().hashCode());
        hashCode = 31 * hashCode + (this.getDataSetArns() == null ? 0 : this.getDataSetArns().hashCode());
        hashCode = 31 * hashCode + (this.getThemeArn() == null ? 0 : this.getThemeArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedTime() == null ? 0 : this.getLastUpdatedTime().hashCode());
        return hashCode;
    }

    public Analysis clone() {
        try {
            return (Analysis)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AnalysisMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

