/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.PrestoParameters;

@SdkInternalApi
public class PrestoParametersMarshaller {
    private static final MarshallingInfo<String> HOST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Host").build();
    private static final MarshallingInfo<Integer> PORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Port").build();
    private static final MarshallingInfo<String> CATALOG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Catalog").build();
    private static final PrestoParametersMarshaller instance = new PrestoParametersMarshaller();

    public static PrestoParametersMarshaller getInstance() {
        return instance;
    }

    public void marshall(PrestoParameters prestoParameters, ProtocolMarshaller protocolMarshaller) {
        if (prestoParameters == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)prestoParameters.getHost(), HOST_BINDING);
            protocolMarshaller.marshall((Object)prestoParameters.getPort(), PORT_BINDING);
            protocolMarshaller.marshall((Object)prestoParameters.getCatalog(), CATALOG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

