/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.Parameters;
import java.util.List;

@SdkInternalApi
public class ParametersMarshaller {
    private static final MarshallingInfo<List> STRINGPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StringParameters").build();
    private static final MarshallingInfo<List> INTEGERPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IntegerParameters").build();
    private static final MarshallingInfo<List> DECIMALPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DecimalParameters").build();
    private static final MarshallingInfo<List> DATETIMEPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DateTimeParameters").build();
    private static final ParametersMarshaller instance = new ParametersMarshaller();

    public static ParametersMarshaller getInstance() {
        return instance;
    }

    public void marshall(Parameters parameters, ProtocolMarshaller protocolMarshaller) {
        if (parameters == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(parameters.getStringParameters(), STRINGPARAMETERS_BINDING);
            protocolMarshaller.marshall(parameters.getIntegerParameters(), INTEGERPARAMETERS_BINDING);
            protocolMarshaller.marshall(parameters.getDecimalParameters(), DECIMALPARAMETERS_BINDING);
            protocolMarshaller.marshall(parameters.getDateTimeParameters(), DATETIMEPARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

