/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.quicksight.AmazonQuickSight;
import com.amazonaws.services.quicksight.AmazonQuickSightClientBuilder;
import com.amazonaws.services.quicksight.model.AccessDeniedException;
import com.amazonaws.services.quicksight.model.AmazonQuickSightException;
import com.amazonaws.services.quicksight.model.CreateGroupMembershipRequest;
import com.amazonaws.services.quicksight.model.CreateGroupMembershipResult;
import com.amazonaws.services.quicksight.model.CreateGroupRequest;
import com.amazonaws.services.quicksight.model.CreateGroupResult;
import com.amazonaws.services.quicksight.model.DeleteGroupMembershipRequest;
import com.amazonaws.services.quicksight.model.DeleteGroupMembershipResult;
import com.amazonaws.services.quicksight.model.DeleteGroupRequest;
import com.amazonaws.services.quicksight.model.DeleteGroupResult;
import com.amazonaws.services.quicksight.model.DeleteUserByPrincipalIdRequest;
import com.amazonaws.services.quicksight.model.DeleteUserByPrincipalIdResult;
import com.amazonaws.services.quicksight.model.DeleteUserRequest;
import com.amazonaws.services.quicksight.model.DeleteUserResult;
import com.amazonaws.services.quicksight.model.DescribeGroupRequest;
import com.amazonaws.services.quicksight.model.DescribeGroupResult;
import com.amazonaws.services.quicksight.model.DescribeUserRequest;
import com.amazonaws.services.quicksight.model.DescribeUserResult;
import com.amazonaws.services.quicksight.model.DomainNotWhitelistedException;
import com.amazonaws.services.quicksight.model.GetDashboardEmbedUrlRequest;
import com.amazonaws.services.quicksight.model.GetDashboardEmbedUrlResult;
import com.amazonaws.services.quicksight.model.IdentityTypeNotSupportedException;
import com.amazonaws.services.quicksight.model.InternalFailureException;
import com.amazonaws.services.quicksight.model.InvalidNextTokenException;
import com.amazonaws.services.quicksight.model.InvalidParameterValueException;
import com.amazonaws.services.quicksight.model.LimitExceededException;
import com.amazonaws.services.quicksight.model.ListGroupMembershipsRequest;
import com.amazonaws.services.quicksight.model.ListGroupMembershipsResult;
import com.amazonaws.services.quicksight.model.ListGroupsRequest;
import com.amazonaws.services.quicksight.model.ListGroupsResult;
import com.amazonaws.services.quicksight.model.ListUserGroupsRequest;
import com.amazonaws.services.quicksight.model.ListUserGroupsResult;
import com.amazonaws.services.quicksight.model.ListUsersRequest;
import com.amazonaws.services.quicksight.model.ListUsersResult;
import com.amazonaws.services.quicksight.model.PreconditionNotMetException;
import com.amazonaws.services.quicksight.model.QuickSightUserNotFoundException;
import com.amazonaws.services.quicksight.model.RegisterUserRequest;
import com.amazonaws.services.quicksight.model.RegisterUserResult;
import com.amazonaws.services.quicksight.model.ResourceExistsException;
import com.amazonaws.services.quicksight.model.ResourceNotFoundException;
import com.amazonaws.services.quicksight.model.ResourceUnavailableException;
import com.amazonaws.services.quicksight.model.SessionLifetimeInMinutesInvalidException;
import com.amazonaws.services.quicksight.model.ThrottlingException;
import com.amazonaws.services.quicksight.model.UnsupportedUserEditionException;
import com.amazonaws.services.quicksight.model.UpdateGroupRequest;
import com.amazonaws.services.quicksight.model.UpdateGroupResult;
import com.amazonaws.services.quicksight.model.UpdateUserRequest;
import com.amazonaws.services.quicksight.model.UpdateUserResult;
import com.amazonaws.services.quicksight.model.transform.CreateGroupMembershipRequestProtocolMarshaller;
import com.amazonaws.services.quicksight.model.transform.CreateGroupMembershipResultJsonUnmarshaller;
import com.amazonaws.services.quicksight.model.transform.CreateGroupRequestProtocolMarshaller;
import com.amazonaws.services.quicksight.model.transform.CreateGroupResultJsonUnmarshaller;
import com.amazonaws.services.quicksight.model.transform.DeleteGroupMembershipRequestProtocolMarshaller;
import com.amazonaws.services.quicksight.model.transform.DeleteGroupMembershipResultJsonUnmarshaller;
import com.amazonaws.services.quicksight.model.transform.DeleteGroupRequestProtocolMarshaller;
import com.amazonaws.services.quicksight.model.transform.DeleteGroupResultJsonUnmarshaller;
import com.amazonaws.services.quicksight.model.transform.DeleteUserByPrincipalIdRequestProtocolMarshaller;
import com.amazonaws.services.quicksight.model.transform.DeleteUserByPrincipalIdResultJsonUnmarshaller;
import com.amazonaws.services.quicksight.model.transform.DeleteUserRequestProtocolMarshaller;
import com.amazonaws.services.quicksight.model.transform.DeleteUserResultJsonUnmarshaller;
import com.amazonaws.services.quicksight.model.transform.DescribeGroupRequestProtocolMarshaller;
import com.amazonaws.services.quicksight.model.transform.DescribeGroupResultJsonUnmarshaller;
import com.amazonaws.services.quicksight.model.transform.DescribeUserRequestProtocolMarshaller;
import com.amazonaws.services.quicksight.model.transform.DescribeUserResultJsonUnmarshaller;
import com.amazonaws.services.quicksight.model.transform.GetDashboardEmbedUrlRequestProtocolMarshaller;
import com.amazonaws.services.quicksight.model.transform.GetDashboardEmbedUrlResultJsonUnmarshaller;
import com.amazonaws.services.quicksight.model.transform.ListGroupMembershipsRequestProtocolMarshaller;
import com.amazonaws.services.quicksight.model.transform.ListGroupMembershipsResultJsonUnmarshaller;
import com.amazonaws.services.quicksight.model.transform.ListGroupsRequestProtocolMarshaller;
import com.amazonaws.services.quicksight.model.transform.ListGroupsResultJsonUnmarshaller;
import com.amazonaws.services.quicksight.model.transform.ListUserGroupsRequestProtocolMarshaller;
import com.amazonaws.services.quicksight.model.transform.ListUserGroupsResultJsonUnmarshaller;
import com.amazonaws.services.quicksight.model.transform.ListUsersRequestProtocolMarshaller;
import com.amazonaws.services.quicksight.model.transform.ListUsersResultJsonUnmarshaller;
import com.amazonaws.services.quicksight.model.transform.RegisterUserRequestProtocolMarshaller;
import com.amazonaws.services.quicksight.model.transform.RegisterUserResultJsonUnmarshaller;
import com.amazonaws.services.quicksight.model.transform.UpdateGroupRequestProtocolMarshaller;
import com.amazonaws.services.quicksight.model.transform.UpdateGroupResultJsonUnmarshaller;
import com.amazonaws.services.quicksight.model.transform.UpdateUserRequestProtocolMarshaller;
import com.amazonaws.services.quicksight.model.transform.UpdateUserResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonQuickSightClient
extends AmazonWebServiceClient
implements AmazonQuickSight {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonQuickSight.class);
    private static final String DEFAULT_SIGNING_NAME = "quicksight";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withModeledClass(AccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DomainNotWhitelistedException").withModeledClass(DomainNotWhitelistedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("QuickSightUserNotFoundException").withModeledClass(QuickSightUserNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalFailureException").withModeledClass(InternalFailureException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterValueException").withModeledClass(InvalidParameterValueException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IdentityTypeNotSupportedException").withModeledClass(IdentityTypeNotSupportedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceUnavailableException").withModeledClass(ResourceUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withModeledClass(ThrottlingException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceExistsException").withModeledClass(ResourceExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SessionLifetimeInMinutesInvalidException").withModeledClass(SessionLifetimeInMinutesInvalidException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedUserEditionException").withModeledClass(UnsupportedUserEditionException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PreconditionNotMetException").withModeledClass(PreconditionNotMetException.class)).withBaseServiceExceptionClass(AmazonQuickSightException.class));

    public static AmazonQuickSightClientBuilder builder() {
        return AmazonQuickSightClientBuilder.standard();
    }

    AmazonQuickSightClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonQuickSightClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("quicksight.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/quicksight/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/quicksight/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateGroupResult createGroup(CreateGroupRequest request) {
        request = (CreateGroupRequest)this.beforeClientExecution(request);
        return this.executeCreateGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateGroupResult executeCreateGroup(CreateGroupRequest createGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateGroupRequestProtocolMarshaller(protocolFactory).marshall((CreateGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)createGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QuickSight");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateGroupResult createGroupResult = (CreateGroupResult)response.getAwsResponse();
            return createGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateGroupMembershipResult createGroupMembership(CreateGroupMembershipRequest request) {
        request = (CreateGroupMembershipRequest)this.beforeClientExecution(request);
        return this.executeCreateGroupMembership(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateGroupMembershipResult executeCreateGroupMembership(CreateGroupMembershipRequest createGroupMembershipRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createGroupMembershipRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateGroupMembershipRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateGroupMembershipRequestProtocolMarshaller(protocolFactory).marshall((CreateGroupMembershipRequest)super.beforeMarshalling((AmazonWebServiceRequest)createGroupMembershipRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QuickSight");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateGroupMembership");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateGroupMembershipResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateGroupMembershipResult createGroupMembershipResult = (CreateGroupMembershipResult)response.getAwsResponse();
            return createGroupMembershipResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteGroupResult deleteGroup(DeleteGroupRequest request) {
        request = (DeleteGroupRequest)this.beforeClientExecution(request);
        return this.executeDeleteGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteGroupResult executeDeleteGroup(DeleteGroupRequest deleteGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteGroupRequestProtocolMarshaller(protocolFactory).marshall((DeleteGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QuickSight");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteGroupResult deleteGroupResult = (DeleteGroupResult)response.getAwsResponse();
            return deleteGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteGroupMembershipResult deleteGroupMembership(DeleteGroupMembershipRequest request) {
        request = (DeleteGroupMembershipRequest)this.beforeClientExecution(request);
        return this.executeDeleteGroupMembership(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteGroupMembershipResult executeDeleteGroupMembership(DeleteGroupMembershipRequest deleteGroupMembershipRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteGroupMembershipRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteGroupMembershipRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteGroupMembershipRequestProtocolMarshaller(protocolFactory).marshall((DeleteGroupMembershipRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteGroupMembershipRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QuickSight");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteGroupMembership");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteGroupMembershipResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteGroupMembershipResult deleteGroupMembershipResult = (DeleteGroupMembershipResult)response.getAwsResponse();
            return deleteGroupMembershipResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteUserResult deleteUser(DeleteUserRequest request) {
        request = (DeleteUserRequest)this.beforeClientExecution(request);
        return this.executeDeleteUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteUserResult executeDeleteUser(DeleteUserRequest deleteUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteUserRequestProtocolMarshaller(protocolFactory).marshall((DeleteUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QuickSight");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteUser");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteUserResult deleteUserResult = (DeleteUserResult)response.getAwsResponse();
            return deleteUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteUserByPrincipalIdResult deleteUserByPrincipalId(DeleteUserByPrincipalIdRequest request) {
        request = (DeleteUserByPrincipalIdRequest)this.beforeClientExecution(request);
        return this.executeDeleteUserByPrincipalId(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteUserByPrincipalIdResult executeDeleteUserByPrincipalId(DeleteUserByPrincipalIdRequest deleteUserByPrincipalIdRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteUserByPrincipalIdRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteUserByPrincipalIdRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteUserByPrincipalIdRequestProtocolMarshaller(protocolFactory).marshall((DeleteUserByPrincipalIdRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteUserByPrincipalIdRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QuickSight");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteUserByPrincipalId");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteUserByPrincipalIdResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteUserByPrincipalIdResult deleteUserByPrincipalIdResult = (DeleteUserByPrincipalIdResult)response.getAwsResponse();
            return deleteUserByPrincipalIdResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeGroupResult describeGroup(DescribeGroupRequest request) {
        request = (DescribeGroupRequest)this.beforeClientExecution(request);
        return this.executeDescribeGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeGroupResult executeDescribeGroup(DescribeGroupRequest describeGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeGroupRequestProtocolMarshaller(protocolFactory).marshall((DescribeGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QuickSight");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeGroupResult describeGroupResult = (DescribeGroupResult)response.getAwsResponse();
            return describeGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeUserResult describeUser(DescribeUserRequest request) {
        request = (DescribeUserRequest)this.beforeClientExecution(request);
        return this.executeDescribeUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeUserResult executeDescribeUser(DescribeUserRequest describeUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeUserRequestProtocolMarshaller(protocolFactory).marshall((DescribeUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QuickSight");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeUser");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeUserResult describeUserResult = (DescribeUserResult)response.getAwsResponse();
            return describeUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDashboardEmbedUrlResult getDashboardEmbedUrl(GetDashboardEmbedUrlRequest request) {
        request = (GetDashboardEmbedUrlRequest)this.beforeClientExecution(request);
        return this.executeGetDashboardEmbedUrl(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDashboardEmbedUrlResult executeGetDashboardEmbedUrl(GetDashboardEmbedUrlRequest getDashboardEmbedUrlRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDashboardEmbedUrlRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDashboardEmbedUrlRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDashboardEmbedUrlRequestProtocolMarshaller(protocolFactory).marshall((GetDashboardEmbedUrlRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDashboardEmbedUrlRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QuickSight");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDashboardEmbedUrl");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDashboardEmbedUrlResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDashboardEmbedUrlResult getDashboardEmbedUrlResult = (GetDashboardEmbedUrlResult)response.getAwsResponse();
            return getDashboardEmbedUrlResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListGroupMembershipsResult listGroupMemberships(ListGroupMembershipsRequest request) {
        request = (ListGroupMembershipsRequest)this.beforeClientExecution(request);
        return this.executeListGroupMemberships(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListGroupMembershipsResult executeListGroupMemberships(ListGroupMembershipsRequest listGroupMembershipsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listGroupMembershipsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListGroupMembershipsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListGroupMembershipsRequestProtocolMarshaller(protocolFactory).marshall((ListGroupMembershipsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listGroupMembershipsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QuickSight");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListGroupMemberships");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListGroupMembershipsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListGroupMembershipsResult listGroupMembershipsResult = (ListGroupMembershipsResult)response.getAwsResponse();
            return listGroupMembershipsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListGroupsResult listGroups(ListGroupsRequest request) {
        request = (ListGroupsRequest)this.beforeClientExecution(request);
        return this.executeListGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListGroupsResult executeListGroups(ListGroupsRequest listGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListGroupsRequestProtocolMarshaller(protocolFactory).marshall((ListGroupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QuickSight");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListGroups");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListGroupsResult listGroupsResult = (ListGroupsResult)response.getAwsResponse();
            return listGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListUserGroupsResult listUserGroups(ListUserGroupsRequest request) {
        request = (ListUserGroupsRequest)this.beforeClientExecution(request);
        return this.executeListUserGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListUserGroupsResult executeListUserGroups(ListUserGroupsRequest listUserGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listUserGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListUserGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListUserGroupsRequestProtocolMarshaller(protocolFactory).marshall((ListUserGroupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listUserGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QuickSight");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListUserGroups");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListUserGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListUserGroupsResult listUserGroupsResult = (ListUserGroupsResult)response.getAwsResponse();
            return listUserGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListUsersResult listUsers(ListUsersRequest request) {
        request = (ListUsersRequest)this.beforeClientExecution(request);
        return this.executeListUsers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListUsersResult executeListUsers(ListUsersRequest listUsersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listUsersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListUsersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListUsersRequestProtocolMarshaller(protocolFactory).marshall((ListUsersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listUsersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QuickSight");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListUsers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListUsersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListUsersResult listUsersResult = (ListUsersResult)response.getAwsResponse();
            return listUsersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RegisterUserResult registerUser(RegisterUserRequest request) {
        request = (RegisterUserRequest)this.beforeClientExecution(request);
        return this.executeRegisterUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RegisterUserResult executeRegisterUser(RegisterUserRequest registerUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterUserRequestProtocolMarshaller(protocolFactory).marshall((RegisterUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)registerUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QuickSight");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RegisterUser");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RegisterUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RegisterUserResult registerUserResult = (RegisterUserResult)response.getAwsResponse();
            return registerUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateGroupResult updateGroup(UpdateGroupRequest request) {
        request = (UpdateGroupRequest)this.beforeClientExecution(request);
        return this.executeUpdateGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateGroupResult executeUpdateGroup(UpdateGroupRequest updateGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateGroupRequestProtocolMarshaller(protocolFactory).marshall((UpdateGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QuickSight");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateGroupResult updateGroupResult = (UpdateGroupResult)response.getAwsResponse();
            return updateGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateUserResult updateUser(UpdateUserRequest request) {
        request = (UpdateUserRequest)this.beforeClientExecution(request);
        return this.executeUpdateUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateUserResult executeUpdateUser(UpdateUserRequest updateUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateUserRequestProtocolMarshaller(protocolFactory).marshall((UpdateUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QuickSight");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateUser");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateUserResult updateUserResult = (UpdateUserResult)response.getAwsResponse();
            return updateUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

