/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qldb;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.qldb.AmazonQLDB;
import com.amazonaws.services.qldb.AmazonQLDBClientBuilder;
import com.amazonaws.services.qldb.model.AmazonQLDBException;
import com.amazonaws.services.qldb.model.CancelJournalKinesisStreamRequest;
import com.amazonaws.services.qldb.model.CancelJournalKinesisStreamResult;
import com.amazonaws.services.qldb.model.CreateLedgerRequest;
import com.amazonaws.services.qldb.model.CreateLedgerResult;
import com.amazonaws.services.qldb.model.DeleteLedgerRequest;
import com.amazonaws.services.qldb.model.DeleteLedgerResult;
import com.amazonaws.services.qldb.model.DescribeJournalKinesisStreamRequest;
import com.amazonaws.services.qldb.model.DescribeJournalKinesisStreamResult;
import com.amazonaws.services.qldb.model.DescribeJournalS3ExportRequest;
import com.amazonaws.services.qldb.model.DescribeJournalS3ExportResult;
import com.amazonaws.services.qldb.model.DescribeLedgerRequest;
import com.amazonaws.services.qldb.model.DescribeLedgerResult;
import com.amazonaws.services.qldb.model.ExportJournalToS3Request;
import com.amazonaws.services.qldb.model.ExportJournalToS3Result;
import com.amazonaws.services.qldb.model.GetBlockRequest;
import com.amazonaws.services.qldb.model.GetBlockResult;
import com.amazonaws.services.qldb.model.GetDigestRequest;
import com.amazonaws.services.qldb.model.GetDigestResult;
import com.amazonaws.services.qldb.model.GetRevisionRequest;
import com.amazonaws.services.qldb.model.GetRevisionResult;
import com.amazonaws.services.qldb.model.ListJournalKinesisStreamsForLedgerRequest;
import com.amazonaws.services.qldb.model.ListJournalKinesisStreamsForLedgerResult;
import com.amazonaws.services.qldb.model.ListJournalS3ExportsForLedgerRequest;
import com.amazonaws.services.qldb.model.ListJournalS3ExportsForLedgerResult;
import com.amazonaws.services.qldb.model.ListJournalS3ExportsRequest;
import com.amazonaws.services.qldb.model.ListJournalS3ExportsResult;
import com.amazonaws.services.qldb.model.ListLedgersRequest;
import com.amazonaws.services.qldb.model.ListLedgersResult;
import com.amazonaws.services.qldb.model.ListTagsForResourceRequest;
import com.amazonaws.services.qldb.model.ListTagsForResourceResult;
import com.amazonaws.services.qldb.model.StreamJournalToKinesisRequest;
import com.amazonaws.services.qldb.model.StreamJournalToKinesisResult;
import com.amazonaws.services.qldb.model.TagResourceRequest;
import com.amazonaws.services.qldb.model.TagResourceResult;
import com.amazonaws.services.qldb.model.UntagResourceRequest;
import com.amazonaws.services.qldb.model.UntagResourceResult;
import com.amazonaws.services.qldb.model.UpdateLedgerPermissionsModeRequest;
import com.amazonaws.services.qldb.model.UpdateLedgerPermissionsModeResult;
import com.amazonaws.services.qldb.model.UpdateLedgerRequest;
import com.amazonaws.services.qldb.model.UpdateLedgerResult;
import com.amazonaws.services.qldb.model.transform.CancelJournalKinesisStreamRequestProtocolMarshaller;
import com.amazonaws.services.qldb.model.transform.CancelJournalKinesisStreamResultJsonUnmarshaller;
import com.amazonaws.services.qldb.model.transform.CreateLedgerRequestProtocolMarshaller;
import com.amazonaws.services.qldb.model.transform.CreateLedgerResultJsonUnmarshaller;
import com.amazonaws.services.qldb.model.transform.DeleteLedgerRequestProtocolMarshaller;
import com.amazonaws.services.qldb.model.transform.DeleteLedgerResultJsonUnmarshaller;
import com.amazonaws.services.qldb.model.transform.DescribeJournalKinesisStreamRequestProtocolMarshaller;
import com.amazonaws.services.qldb.model.transform.DescribeJournalKinesisStreamResultJsonUnmarshaller;
import com.amazonaws.services.qldb.model.transform.DescribeJournalS3ExportRequestProtocolMarshaller;
import com.amazonaws.services.qldb.model.transform.DescribeJournalS3ExportResultJsonUnmarshaller;
import com.amazonaws.services.qldb.model.transform.DescribeLedgerRequestProtocolMarshaller;
import com.amazonaws.services.qldb.model.transform.DescribeLedgerResultJsonUnmarshaller;
import com.amazonaws.services.qldb.model.transform.ExportJournalToS3RequestProtocolMarshaller;
import com.amazonaws.services.qldb.model.transform.ExportJournalToS3ResultJsonUnmarshaller;
import com.amazonaws.services.qldb.model.transform.GetBlockRequestProtocolMarshaller;
import com.amazonaws.services.qldb.model.transform.GetBlockResultJsonUnmarshaller;
import com.amazonaws.services.qldb.model.transform.GetDigestRequestProtocolMarshaller;
import com.amazonaws.services.qldb.model.transform.GetDigestResultJsonUnmarshaller;
import com.amazonaws.services.qldb.model.transform.GetRevisionRequestProtocolMarshaller;
import com.amazonaws.services.qldb.model.transform.GetRevisionResultJsonUnmarshaller;
import com.amazonaws.services.qldb.model.transform.InvalidParameterExceptionUnmarshaller;
import com.amazonaws.services.qldb.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.qldb.model.transform.ListJournalKinesisStreamsForLedgerRequestProtocolMarshaller;
import com.amazonaws.services.qldb.model.transform.ListJournalKinesisStreamsForLedgerResultJsonUnmarshaller;
import com.amazonaws.services.qldb.model.transform.ListJournalS3ExportsForLedgerRequestProtocolMarshaller;
import com.amazonaws.services.qldb.model.transform.ListJournalS3ExportsForLedgerResultJsonUnmarshaller;
import com.amazonaws.services.qldb.model.transform.ListJournalS3ExportsRequestProtocolMarshaller;
import com.amazonaws.services.qldb.model.transform.ListJournalS3ExportsResultJsonUnmarshaller;
import com.amazonaws.services.qldb.model.transform.ListLedgersRequestProtocolMarshaller;
import com.amazonaws.services.qldb.model.transform.ListLedgersResultJsonUnmarshaller;
import com.amazonaws.services.qldb.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.qldb.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.qldb.model.transform.ResourceAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.qldb.model.transform.ResourceInUseExceptionUnmarshaller;
import com.amazonaws.services.qldb.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.qldb.model.transform.ResourcePreconditionNotMetExceptionUnmarshaller;
import com.amazonaws.services.qldb.model.transform.StreamJournalToKinesisRequestProtocolMarshaller;
import com.amazonaws.services.qldb.model.transform.StreamJournalToKinesisResultJsonUnmarshaller;
import com.amazonaws.services.qldb.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.qldb.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.qldb.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.qldb.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.qldb.model.transform.UpdateLedgerPermissionsModeRequestProtocolMarshaller;
import com.amazonaws.services.qldb.model.transform.UpdateLedgerPermissionsModeResultJsonUnmarshaller;
import com.amazonaws.services.qldb.model.transform.UpdateLedgerRequestProtocolMarshaller;
import com.amazonaws.services.qldb.model.transform.UpdateLedgerResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonQLDBClient
extends AmazonWebServiceClient
implements AmazonQLDB {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonQLDB.class);
    private static final String DEFAULT_SIGNING_NAME = "qldb";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourcePreconditionNotMetException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourcePreconditionNotMetExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidParameterExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceInUseExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceAlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonQLDBException.class));

    public static AmazonQLDBClientBuilder builder() {
        return AmazonQLDBClientBuilder.standard();
    }

    AmazonQLDBClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonQLDBClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("qldb.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/qldb/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/qldb/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CancelJournalKinesisStreamResult cancelJournalKinesisStream(CancelJournalKinesisStreamRequest request) {
        request = (CancelJournalKinesisStreamRequest)this.beforeClientExecution(request);
        return this.executeCancelJournalKinesisStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelJournalKinesisStreamResult executeCancelJournalKinesisStream(CancelJournalKinesisStreamRequest cancelJournalKinesisStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelJournalKinesisStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelJournalKinesisStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelJournalKinesisStreamRequestProtocolMarshaller(protocolFactory).marshall((CancelJournalKinesisStreamRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelJournalKinesisStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QLDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelJournalKinesisStream");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelJournalKinesisStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelJournalKinesisStreamResult cancelJournalKinesisStreamResult = (CancelJournalKinesisStreamResult)response.getAwsResponse();
            return cancelJournalKinesisStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateLedgerResult createLedger(CreateLedgerRequest request) {
        request = (CreateLedgerRequest)this.beforeClientExecution(request);
        return this.executeCreateLedger(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateLedgerResult executeCreateLedger(CreateLedgerRequest createLedgerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createLedgerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateLedgerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateLedgerRequestProtocolMarshaller(protocolFactory).marshall((CreateLedgerRequest)super.beforeMarshalling((AmazonWebServiceRequest)createLedgerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QLDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateLedger");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateLedgerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateLedgerResult createLedgerResult = (CreateLedgerResult)response.getAwsResponse();
            return createLedgerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteLedgerResult deleteLedger(DeleteLedgerRequest request) {
        request = (DeleteLedgerRequest)this.beforeClientExecution(request);
        return this.executeDeleteLedger(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteLedgerResult executeDeleteLedger(DeleteLedgerRequest deleteLedgerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteLedgerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteLedgerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteLedgerRequestProtocolMarshaller(protocolFactory).marshall((DeleteLedgerRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteLedgerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QLDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteLedger");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteLedgerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteLedgerResult deleteLedgerResult = (DeleteLedgerResult)response.getAwsResponse();
            return deleteLedgerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeJournalKinesisStreamResult describeJournalKinesisStream(DescribeJournalKinesisStreamRequest request) {
        request = (DescribeJournalKinesisStreamRequest)this.beforeClientExecution(request);
        return this.executeDescribeJournalKinesisStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeJournalKinesisStreamResult executeDescribeJournalKinesisStream(DescribeJournalKinesisStreamRequest describeJournalKinesisStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeJournalKinesisStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeJournalKinesisStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeJournalKinesisStreamRequestProtocolMarshaller(protocolFactory).marshall((DescribeJournalKinesisStreamRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeJournalKinesisStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QLDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeJournalKinesisStream");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeJournalKinesisStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeJournalKinesisStreamResult describeJournalKinesisStreamResult = (DescribeJournalKinesisStreamResult)response.getAwsResponse();
            return describeJournalKinesisStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeJournalS3ExportResult describeJournalS3Export(DescribeJournalS3ExportRequest request) {
        request = (DescribeJournalS3ExportRequest)this.beforeClientExecution(request);
        return this.executeDescribeJournalS3Export(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeJournalS3ExportResult executeDescribeJournalS3Export(DescribeJournalS3ExportRequest describeJournalS3ExportRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeJournalS3ExportRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeJournalS3ExportRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeJournalS3ExportRequestProtocolMarshaller(protocolFactory).marshall((DescribeJournalS3ExportRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeJournalS3ExportRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QLDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeJournalS3Export");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeJournalS3ExportResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeJournalS3ExportResult describeJournalS3ExportResult = (DescribeJournalS3ExportResult)response.getAwsResponse();
            return describeJournalS3ExportResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeLedgerResult describeLedger(DescribeLedgerRequest request) {
        request = (DescribeLedgerRequest)this.beforeClientExecution(request);
        return this.executeDescribeLedger(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeLedgerResult executeDescribeLedger(DescribeLedgerRequest describeLedgerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeLedgerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeLedgerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeLedgerRequestProtocolMarshaller(protocolFactory).marshall((DescribeLedgerRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeLedgerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QLDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeLedger");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeLedgerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeLedgerResult describeLedgerResult = (DescribeLedgerResult)response.getAwsResponse();
            return describeLedgerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ExportJournalToS3Result exportJournalToS3(ExportJournalToS3Request request) {
        request = (ExportJournalToS3Request)this.beforeClientExecution(request);
        return this.executeExportJournalToS3(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExportJournalToS3Result executeExportJournalToS3(ExportJournalToS3Request exportJournalToS3Request) {
        ExecutionContext executionContext = this.createExecutionContext(exportJournalToS3Request);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExportJournalToS3Request> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExportJournalToS3RequestProtocolMarshaller(protocolFactory).marshall((ExportJournalToS3Request)super.beforeMarshalling((AmazonWebServiceRequest)exportJournalToS3Request));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QLDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ExportJournalToS3");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ExportJournalToS3ResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExportJournalToS3Result exportJournalToS3Result = (ExportJournalToS3Result)response.getAwsResponse();
            return exportJournalToS3Result;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetBlockResult getBlock(GetBlockRequest request) {
        request = (GetBlockRequest)this.beforeClientExecution(request);
        return this.executeGetBlock(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetBlockResult executeGetBlock(GetBlockRequest getBlockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBlockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBlockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetBlockRequestProtocolMarshaller(protocolFactory).marshall((GetBlockRequest)super.beforeMarshalling((AmazonWebServiceRequest)getBlockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QLDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetBlock");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetBlockResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetBlockResult getBlockResult = (GetBlockResult)response.getAwsResponse();
            return getBlockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDigestResult getDigest(GetDigestRequest request) {
        request = (GetDigestRequest)this.beforeClientExecution(request);
        return this.executeGetDigest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDigestResult executeGetDigest(GetDigestRequest getDigestRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDigestRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDigestRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDigestRequestProtocolMarshaller(protocolFactory).marshall((GetDigestRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDigestRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QLDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDigest");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDigestResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDigestResult getDigestResult = (GetDigestResult)response.getAwsResponse();
            return getDigestResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRevisionResult getRevision(GetRevisionRequest request) {
        request = (GetRevisionRequest)this.beforeClientExecution(request);
        return this.executeGetRevision(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRevisionResult executeGetRevision(GetRevisionRequest getRevisionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRevisionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRevisionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRevisionRequestProtocolMarshaller(protocolFactory).marshall((GetRevisionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRevisionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QLDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetRevision");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRevisionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRevisionResult getRevisionResult = (GetRevisionResult)response.getAwsResponse();
            return getRevisionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListJournalKinesisStreamsForLedgerResult listJournalKinesisStreamsForLedger(ListJournalKinesisStreamsForLedgerRequest request) {
        request = (ListJournalKinesisStreamsForLedgerRequest)this.beforeClientExecution(request);
        return this.executeListJournalKinesisStreamsForLedger(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListJournalKinesisStreamsForLedgerResult executeListJournalKinesisStreamsForLedger(ListJournalKinesisStreamsForLedgerRequest listJournalKinesisStreamsForLedgerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listJournalKinesisStreamsForLedgerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJournalKinesisStreamsForLedgerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJournalKinesisStreamsForLedgerRequestProtocolMarshaller(protocolFactory).marshall((ListJournalKinesisStreamsForLedgerRequest)super.beforeMarshalling((AmazonWebServiceRequest)listJournalKinesisStreamsForLedgerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QLDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListJournalKinesisStreamsForLedger");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListJournalKinesisStreamsForLedgerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListJournalKinesisStreamsForLedgerResult listJournalKinesisStreamsForLedgerResult = (ListJournalKinesisStreamsForLedgerResult)response.getAwsResponse();
            return listJournalKinesisStreamsForLedgerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListJournalS3ExportsResult listJournalS3Exports(ListJournalS3ExportsRequest request) {
        request = (ListJournalS3ExportsRequest)this.beforeClientExecution(request);
        return this.executeListJournalS3Exports(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListJournalS3ExportsResult executeListJournalS3Exports(ListJournalS3ExportsRequest listJournalS3ExportsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listJournalS3ExportsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJournalS3ExportsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJournalS3ExportsRequestProtocolMarshaller(protocolFactory).marshall((ListJournalS3ExportsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listJournalS3ExportsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QLDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListJournalS3Exports");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListJournalS3ExportsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListJournalS3ExportsResult listJournalS3ExportsResult = (ListJournalS3ExportsResult)response.getAwsResponse();
            return listJournalS3ExportsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListJournalS3ExportsForLedgerResult listJournalS3ExportsForLedger(ListJournalS3ExportsForLedgerRequest request) {
        request = (ListJournalS3ExportsForLedgerRequest)this.beforeClientExecution(request);
        return this.executeListJournalS3ExportsForLedger(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListJournalS3ExportsForLedgerResult executeListJournalS3ExportsForLedger(ListJournalS3ExportsForLedgerRequest listJournalS3ExportsForLedgerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listJournalS3ExportsForLedgerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJournalS3ExportsForLedgerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJournalS3ExportsForLedgerRequestProtocolMarshaller(protocolFactory).marshall((ListJournalS3ExportsForLedgerRequest)super.beforeMarshalling((AmazonWebServiceRequest)listJournalS3ExportsForLedgerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QLDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListJournalS3ExportsForLedger");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListJournalS3ExportsForLedgerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListJournalS3ExportsForLedgerResult listJournalS3ExportsForLedgerResult = (ListJournalS3ExportsForLedgerResult)response.getAwsResponse();
            return listJournalS3ExportsForLedgerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListLedgersResult listLedgers(ListLedgersRequest request) {
        request = (ListLedgersRequest)this.beforeClientExecution(request);
        return this.executeListLedgers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListLedgersResult executeListLedgers(ListLedgersRequest listLedgersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listLedgersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListLedgersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListLedgersRequestProtocolMarshaller(protocolFactory).marshall((ListLedgersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listLedgersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QLDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListLedgers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListLedgersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListLedgersResult listLedgersResult = (ListLedgersResult)response.getAwsResponse();
            return listLedgersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QLDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StreamJournalToKinesisResult streamJournalToKinesis(StreamJournalToKinesisRequest request) {
        request = (StreamJournalToKinesisRequest)this.beforeClientExecution(request);
        return this.executeStreamJournalToKinesis(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StreamJournalToKinesisResult executeStreamJournalToKinesis(StreamJournalToKinesisRequest streamJournalToKinesisRequest) {
        ExecutionContext executionContext = this.createExecutionContext(streamJournalToKinesisRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StreamJournalToKinesisRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StreamJournalToKinesisRequestProtocolMarshaller(protocolFactory).marshall((StreamJournalToKinesisRequest)super.beforeMarshalling((AmazonWebServiceRequest)streamJournalToKinesisRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QLDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StreamJournalToKinesis");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StreamJournalToKinesisResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StreamJournalToKinesisResult streamJournalToKinesisResult = (StreamJournalToKinesisResult)response.getAwsResponse();
            return streamJournalToKinesisResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QLDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QLDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateLedgerResult updateLedger(UpdateLedgerRequest request) {
        request = (UpdateLedgerRequest)this.beforeClientExecution(request);
        return this.executeUpdateLedger(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateLedgerResult executeUpdateLedger(UpdateLedgerRequest updateLedgerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateLedgerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateLedgerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateLedgerRequestProtocolMarshaller(protocolFactory).marshall((UpdateLedgerRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateLedgerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QLDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateLedger");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateLedgerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateLedgerResult updateLedgerResult = (UpdateLedgerResult)response.getAwsResponse();
            return updateLedgerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateLedgerPermissionsModeResult updateLedgerPermissionsMode(UpdateLedgerPermissionsModeRequest request) {
        request = (UpdateLedgerPermissionsModeRequest)this.beforeClientExecution(request);
        return this.executeUpdateLedgerPermissionsMode(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateLedgerPermissionsModeResult executeUpdateLedgerPermissionsMode(UpdateLedgerPermissionsModeRequest updateLedgerPermissionsModeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateLedgerPermissionsModeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateLedgerPermissionsModeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateLedgerPermissionsModeRequestProtocolMarshaller(protocolFactory).marshall((UpdateLedgerPermissionsModeRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateLedgerPermissionsModeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QLDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateLedgerPermissionsMode");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateLedgerPermissionsModeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateLedgerPermissionsModeResult updateLedgerPermissionsModeResult = (UpdateLedgerPermissionsModeResult)response.getAwsResponse();
            return updateLedgerPermissionsModeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

