/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.qconnect.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/CreateAssistant" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateAssistantRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     */
    private String clientToken;
    /**
     * <p>
     * The description of the assistant.
     * </p>
     */
    private String description;
    /**
     * <p>
     * The name of the assistant.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The configuration information for the customer managed key used for encryption.
     * </p>
     * <p>
     * The customer managed key must have a policy that allows <code>kms:CreateGrant</code>,
     * <code> kms:DescribeKey</code>, <code>kms:Decrypt</code>, and <code>kms:GenerateDataKey*</code> permissions to the
     * IAM identity using the key to invoke Amazon Q in Connect. To use Amazon Q in Connect with chat, the key policy
     * must also allow <code>kms:Decrypt</code>, <code>kms:GenerateDataKey*</code>, and <code>kms:DescribeKey</code>
     * permissions to the <code>connect.amazonaws.com</code> service principal.
     * </p>
     * <p>
     * For more information about setting up a customer managed key for Amazon Q in Connect, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html">Enable Amazon Q in Connect for your
     * instance</a>.
     * </p>
     */
    private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;
    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     */
    private java.util.Map<String, String> tags;
    /**
     * <p>
     * The type of assistant.
     * </p>
     */
    private String type;

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     *        href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries
     *        safe with idempotent APIs</a>.
     */

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */

    public String getClientToken() {
        return this.clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     *        href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries
     *        safe with idempotent APIs</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateAssistantRequest withClientToken(String clientToken) {
        setClientToken(clientToken);
        return this;
    }

    /**
     * <p>
     * The description of the assistant.
     * </p>
     * 
     * @param description
     *        The description of the assistant.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * The description of the assistant.
     * </p>
     * 
     * @return The description of the assistant.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * The description of the assistant.
     * </p>
     * 
     * @param description
     *        The description of the assistant.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateAssistantRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * The name of the assistant.
     * </p>
     * 
     * @param name
     *        The name of the assistant.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the assistant.
     * </p>
     * 
     * @return The name of the assistant.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the assistant.
     * </p>
     * 
     * @param name
     *        The name of the assistant.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateAssistantRequest withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The configuration information for the customer managed key used for encryption.
     * </p>
     * <p>
     * The customer managed key must have a policy that allows <code>kms:CreateGrant</code>,
     * <code> kms:DescribeKey</code>, <code>kms:Decrypt</code>, and <code>kms:GenerateDataKey*</code> permissions to the
     * IAM identity using the key to invoke Amazon Q in Connect. To use Amazon Q in Connect with chat, the key policy
     * must also allow <code>kms:Decrypt</code>, <code>kms:GenerateDataKey*</code>, and <code>kms:DescribeKey</code>
     * permissions to the <code>connect.amazonaws.com</code> service principal.
     * </p>
     * <p>
     * For more information about setting up a customer managed key for Amazon Q in Connect, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html">Enable Amazon Q in Connect for your
     * instance</a>.
     * </p>
     * 
     * @param serverSideEncryptionConfiguration
     *        The configuration information for the customer managed key used for encryption. </p>
     *        <p>
     *        The customer managed key must have a policy that allows <code>kms:CreateGrant</code>,
     *        <code> kms:DescribeKey</code>, <code>kms:Decrypt</code>, and <code>kms:GenerateDataKey*</code> permissions
     *        to the IAM identity using the key to invoke Amazon Q in Connect. To use Amazon Q in Connect with chat, the
     *        key policy must also allow <code>kms:Decrypt</code>, <code>kms:GenerateDataKey*</code>, and
     *        <code>kms:DescribeKey</code> permissions to the <code>connect.amazonaws.com</code> service principal.
     *        </p>
     *        <p>
     *        For more information about setting up a customer managed key for Amazon Q in Connect, see <a
     *        href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html">Enable Amazon Q in Connect for
     *        your instance</a>.
     */

    public void setServerSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
        this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
    }

    /**
     * <p>
     * The configuration information for the customer managed key used for encryption.
     * </p>
     * <p>
     * The customer managed key must have a policy that allows <code>kms:CreateGrant</code>,
     * <code> kms:DescribeKey</code>, <code>kms:Decrypt</code>, and <code>kms:GenerateDataKey*</code> permissions to the
     * IAM identity using the key to invoke Amazon Q in Connect. To use Amazon Q in Connect with chat, the key policy
     * must also allow <code>kms:Decrypt</code>, <code>kms:GenerateDataKey*</code>, and <code>kms:DescribeKey</code>
     * permissions to the <code>connect.amazonaws.com</code> service principal.
     * </p>
     * <p>
     * For more information about setting up a customer managed key for Amazon Q in Connect, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html">Enable Amazon Q in Connect for your
     * instance</a>.
     * </p>
     * 
     * @return The configuration information for the customer managed key used for encryption. </p>
     *         <p>
     *         The customer managed key must have a policy that allows <code>kms:CreateGrant</code>,
     *         <code> kms:DescribeKey</code>, <code>kms:Decrypt</code>, and <code>kms:GenerateDataKey*</code>
     *         permissions to the IAM identity using the key to invoke Amazon Q in Connect. To use Amazon Q in Connect
     *         with chat, the key policy must also allow <code>kms:Decrypt</code>, <code>kms:GenerateDataKey*</code>,
     *         and <code>kms:DescribeKey</code> permissions to the <code>connect.amazonaws.com</code> service principal.
     *         </p>
     *         <p>
     *         For more information about setting up a customer managed key for Amazon Q in Connect, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html">Enable Amazon Q in Connect for
     *         your instance</a>.
     */

    public ServerSideEncryptionConfiguration getServerSideEncryptionConfiguration() {
        return this.serverSideEncryptionConfiguration;
    }

    /**
     * <p>
     * The configuration information for the customer managed key used for encryption.
     * </p>
     * <p>
     * The customer managed key must have a policy that allows <code>kms:CreateGrant</code>,
     * <code> kms:DescribeKey</code>, <code>kms:Decrypt</code>, and <code>kms:GenerateDataKey*</code> permissions to the
     * IAM identity using the key to invoke Amazon Q in Connect. To use Amazon Q in Connect with chat, the key policy
     * must also allow <code>kms:Decrypt</code>, <code>kms:GenerateDataKey*</code>, and <code>kms:DescribeKey</code>
     * permissions to the <code>connect.amazonaws.com</code> service principal.
     * </p>
     * <p>
     * For more information about setting up a customer managed key for Amazon Q in Connect, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html">Enable Amazon Q in Connect for your
     * instance</a>.
     * </p>
     * 
     * @param serverSideEncryptionConfiguration
     *        The configuration information for the customer managed key used for encryption. </p>
     *        <p>
     *        The customer managed key must have a policy that allows <code>kms:CreateGrant</code>,
     *        <code> kms:DescribeKey</code>, <code>kms:Decrypt</code>, and <code>kms:GenerateDataKey*</code> permissions
     *        to the IAM identity using the key to invoke Amazon Q in Connect. To use Amazon Q in Connect with chat, the
     *        key policy must also allow <code>kms:Decrypt</code>, <code>kms:GenerateDataKey*</code>, and
     *        <code>kms:DescribeKey</code> permissions to the <code>connect.amazonaws.com</code> service principal.
     *        </p>
     *        <p>
     *        For more information about setting up a customer managed key for Amazon Q in Connect, see <a
     *        href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html">Enable Amazon Q in Connect for
     *        your instance</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateAssistantRequest withServerSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
        setServerSideEncryptionConfiguration(serverSideEncryptionConfiguration);
        return this;
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */

    public java.util.Map<String, String> getTags() {
        return tags;
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * 
     * @param tags
     *        The tags used to organize, track, or control access for this resource.
     */

    public void setTags(java.util.Map<String, String> tags) {
        this.tags = tags;
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * 
     * @param tags
     *        The tags used to organize, track, or control access for this resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateAssistantRequest withTags(java.util.Map<String, String> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Add a single Tags entry
     *
     * @see CreateAssistantRequest#withTags
     * @returns a reference to this object so that method calls can be chained together.
     */

    public CreateAssistantRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new java.util.HashMap<String, String>();
        }
        if (this.tags.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.tags.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into Tags.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateAssistantRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    /**
     * <p>
     * The type of assistant.
     * </p>
     * 
     * @param type
     *        The type of assistant.
     * @see AssistantType
     */

    public void setType(String type) {
        this.type = type;
    }

    /**
     * <p>
     * The type of assistant.
     * </p>
     * 
     * @return The type of assistant.
     * @see AssistantType
     */

    public String getType() {
        return this.type;
    }

    /**
     * <p>
     * The type of assistant.
     * </p>
     * 
     * @param type
     *        The type of assistant.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AssistantType
     */

    public CreateAssistantRequest withType(String type) {
        setType(type);
        return this;
    }

    /**
     * <p>
     * The type of assistant.
     * </p>
     * 
     * @param type
     *        The type of assistant.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AssistantType
     */

    public CreateAssistantRequest withType(AssistantType type) {
        this.type = type.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getClientToken() != null)
            sb.append("ClientToken: ").append(getClientToken()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getServerSideEncryptionConfiguration() != null)
            sb.append("ServerSideEncryptionConfiguration: ").append(getServerSideEncryptionConfiguration()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags()).append(",");
        if (getType() != null)
            sb.append("Type: ").append(getType());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateAssistantRequest == false)
            return false;
        CreateAssistantRequest other = (CreateAssistantRequest) obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null)
            return false;
        if (other.getClientToken() != null && other.getClientToken().equals(this.getClientToken()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getServerSideEncryptionConfiguration() == null ^ this.getServerSideEncryptionConfiguration() == null)
            return false;
        if (other.getServerSideEncryptionConfiguration() != null
                && other.getServerSideEncryptionConfiguration().equals(this.getServerSideEncryptionConfiguration()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        if (other.getType() == null ^ this.getType() == null)
            return false;
        if (other.getType() != null && other.getType().equals(this.getType()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getClientToken() == null) ? 0 : getClientToken().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getServerSideEncryptionConfiguration() == null) ? 0 : getServerSideEncryptionConfiguration().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        hashCode = prime * hashCode + ((getType() == null) ? 0 : getType().hashCode());
        return hashCode;
    }

    @Override
    public CreateAssistantRequest clone() {
        return (CreateAssistantRequest) super.clone();
    }

}
