/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qbusiness.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.qbusiness.model.ChatSyncRequest;
import com.amazonaws.util.IdempotentUtils;
import java.util.List;

@SdkInternalApi
public class ChatSyncRequestMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("applicationId").build();
    private static final MarshallingInfo<List> ATTACHMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attachments").build();
    private static final MarshallingInfo<StructuredPojo> ATTRIBUTEFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attributeFilter").build();
    private static final MarshallingInfo<String> CHATMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("chatMode").build();
    private static final MarshallingInfo<StructuredPojo> CHATMODECONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("chatModeConfiguration").build();
    private static final MarshallingInfo<String> CLIENTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientToken").defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<String> CONVERSATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("conversationId").build();
    private static final MarshallingInfo<String> PARENTMESSAGEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parentMessageId").build();
    private static final MarshallingInfo<List> USERGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("userGroups").build();
    private static final MarshallingInfo<String> USERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("userId").build();
    private static final MarshallingInfo<String> USERMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("userMessage").build();
    private static final ChatSyncRequestMarshaller instance = new ChatSyncRequestMarshaller();

    public static ChatSyncRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(ChatSyncRequest chatSyncRequest, ProtocolMarshaller protocolMarshaller) {
        if (chatSyncRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)chatSyncRequest.getApplicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall(chatSyncRequest.getAttachments(), ATTACHMENTS_BINDING);
            protocolMarshaller.marshall((Object)chatSyncRequest.getAttributeFilter(), ATTRIBUTEFILTER_BINDING);
            protocolMarshaller.marshall((Object)chatSyncRequest.getChatMode(), CHATMODE_BINDING);
            protocolMarshaller.marshall((Object)chatSyncRequest.getChatModeConfiguration(), CHATMODECONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)chatSyncRequest.getClientToken(), CLIENTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)chatSyncRequest.getConversationId(), CONVERSATIONID_BINDING);
            protocolMarshaller.marshall((Object)chatSyncRequest.getParentMessageId(), PARENTMESSAGEID_BINDING);
            protocolMarshaller.marshall(chatSyncRequest.getUserGroups(), USERGROUPS_BINDING);
            protocolMarshaller.marshall((Object)chatSyncRequest.getUserId(), USERID_BINDING);
            protocolMarshaller.marshall((Object)chatSyncRequest.getUserMessage(), USERMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

