/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qbusiness.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.qbusiness.model.ActionReview;
import com.amazonaws.services.qbusiness.model.AttachmentOutput;
import com.amazonaws.services.qbusiness.model.MessageType;
import com.amazonaws.services.qbusiness.model.SourceAttribution;
import com.amazonaws.services.qbusiness.model.transform.MessageMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Message
implements Serializable,
Cloneable,
StructuredPojo {
    private ActionReview actionReview;
    private List<AttachmentOutput> attachments;
    private String body;
    private String messageId;
    private List<SourceAttribution> sourceAttribution;
    private Date time;
    private String type;

    public void setActionReview(ActionReview actionReview) {
        this.actionReview = actionReview;
    }

    public ActionReview getActionReview() {
        return this.actionReview;
    }

    public Message withActionReview(ActionReview actionReview) {
        this.setActionReview(actionReview);
        return this;
    }

    public List<AttachmentOutput> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Collection<AttachmentOutput> attachments) {
        if (attachments == null) {
            this.attachments = null;
            return;
        }
        this.attachments = new ArrayList<AttachmentOutput>(attachments);
    }

    public Message withAttachments(AttachmentOutput ... attachments) {
        if (this.attachments == null) {
            this.setAttachments(new ArrayList<AttachmentOutput>(attachments.length));
        }
        for (AttachmentOutput ele : attachments) {
            this.attachments.add(ele);
        }
        return this;
    }

    public Message withAttachments(Collection<AttachmentOutput> attachments) {
        this.setAttachments(attachments);
        return this;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getBody() {
        return this.body;
    }

    public Message withBody(String body) {
        this.setBody(body);
        return this;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Message withMessageId(String messageId) {
        this.setMessageId(messageId);
        return this;
    }

    public List<SourceAttribution> getSourceAttribution() {
        return this.sourceAttribution;
    }

    public void setSourceAttribution(Collection<SourceAttribution> sourceAttribution) {
        if (sourceAttribution == null) {
            this.sourceAttribution = null;
            return;
        }
        this.sourceAttribution = new ArrayList<SourceAttribution>(sourceAttribution);
    }

    public Message withSourceAttribution(SourceAttribution ... sourceAttribution) {
        if (this.sourceAttribution == null) {
            this.setSourceAttribution(new ArrayList<SourceAttribution>(sourceAttribution.length));
        }
        for (SourceAttribution ele : sourceAttribution) {
            this.sourceAttribution.add(ele);
        }
        return this;
    }

    public Message withSourceAttribution(Collection<SourceAttribution> sourceAttribution) {
        this.setSourceAttribution(sourceAttribution);
        return this;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public Date getTime() {
        return this.time;
    }

    public Message withTime(Date time) {
        this.setTime(time);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Message withType(String type) {
        this.setType(type);
        return this;
    }

    public Message withType(MessageType type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActionReview() != null) {
            sb.append("ActionReview: ").append(this.getActionReview()).append(",");
        }
        if (this.getAttachments() != null) {
            sb.append("Attachments: ").append(this.getAttachments()).append(",");
        }
        if (this.getBody() != null) {
            sb.append("Body: ").append(this.getBody()).append(",");
        }
        if (this.getMessageId() != null) {
            sb.append("MessageId: ").append(this.getMessageId()).append(",");
        }
        if (this.getSourceAttribution() != null) {
            sb.append("SourceAttribution: ").append(this.getSourceAttribution()).append(",");
        }
        if (this.getTime() != null) {
            sb.append("Time: ").append(this.getTime()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        if (other.getActionReview() == null ^ this.getActionReview() == null) {
            return false;
        }
        if (other.getActionReview() != null && !other.getActionReview().equals(this.getActionReview())) {
            return false;
        }
        if (other.getAttachments() == null ^ this.getAttachments() == null) {
            return false;
        }
        if (other.getAttachments() != null && !other.getAttachments().equals(this.getAttachments())) {
            return false;
        }
        if (other.getBody() == null ^ this.getBody() == null) {
            return false;
        }
        if (other.getBody() != null && !other.getBody().equals(this.getBody())) {
            return false;
        }
        if (other.getMessageId() == null ^ this.getMessageId() == null) {
            return false;
        }
        if (other.getMessageId() != null && !other.getMessageId().equals(this.getMessageId())) {
            return false;
        }
        if (other.getSourceAttribution() == null ^ this.getSourceAttribution() == null) {
            return false;
        }
        if (other.getSourceAttribution() != null && !other.getSourceAttribution().equals(this.getSourceAttribution())) {
            return false;
        }
        if (other.getTime() == null ^ this.getTime() == null) {
            return false;
        }
        if (other.getTime() != null && !other.getTime().equals(this.getTime())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActionReview() == null ? 0 : this.getActionReview().hashCode());
        hashCode = 31 * hashCode + (this.getAttachments() == null ? 0 : this.getAttachments().hashCode());
        hashCode = 31 * hashCode + (this.getBody() == null ? 0 : this.getBody().hashCode());
        hashCode = 31 * hashCode + (this.getMessageId() == null ? 0 : this.getMessageId().hashCode());
        hashCode = 31 * hashCode + (this.getSourceAttribution() == null ? 0 : this.getSourceAttribution().hashCode());
        hashCode = 31 * hashCode + (this.getTime() == null ? 0 : this.getTime().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public Message clone() {
        try {
            return (Message)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

