/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qapps;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.qapps.AWSQAppsAsync;
import com.amazonaws.services.qapps.AWSQAppsAsyncClientBuilder;
import com.amazonaws.services.qapps.AWSQAppsClient;
import com.amazonaws.services.qapps.model.AssociateLibraryItemReviewRequest;
import com.amazonaws.services.qapps.model.AssociateLibraryItemReviewResult;
import com.amazonaws.services.qapps.model.AssociateQAppWithUserRequest;
import com.amazonaws.services.qapps.model.AssociateQAppWithUserResult;
import com.amazonaws.services.qapps.model.CreateLibraryItemRequest;
import com.amazonaws.services.qapps.model.CreateLibraryItemResult;
import com.amazonaws.services.qapps.model.CreateQAppRequest;
import com.amazonaws.services.qapps.model.CreateQAppResult;
import com.amazonaws.services.qapps.model.DeleteLibraryItemRequest;
import com.amazonaws.services.qapps.model.DeleteLibraryItemResult;
import com.amazonaws.services.qapps.model.DeleteQAppRequest;
import com.amazonaws.services.qapps.model.DeleteQAppResult;
import com.amazonaws.services.qapps.model.DisassociateLibraryItemReviewRequest;
import com.amazonaws.services.qapps.model.DisassociateLibraryItemReviewResult;
import com.amazonaws.services.qapps.model.DisassociateQAppFromUserRequest;
import com.amazonaws.services.qapps.model.DisassociateQAppFromUserResult;
import com.amazonaws.services.qapps.model.GetLibraryItemRequest;
import com.amazonaws.services.qapps.model.GetLibraryItemResult;
import com.amazonaws.services.qapps.model.GetQAppRequest;
import com.amazonaws.services.qapps.model.GetQAppResult;
import com.amazonaws.services.qapps.model.GetQAppSessionRequest;
import com.amazonaws.services.qapps.model.GetQAppSessionResult;
import com.amazonaws.services.qapps.model.ImportDocumentRequest;
import com.amazonaws.services.qapps.model.ImportDocumentResult;
import com.amazonaws.services.qapps.model.ListLibraryItemsRequest;
import com.amazonaws.services.qapps.model.ListLibraryItemsResult;
import com.amazonaws.services.qapps.model.ListQAppsRequest;
import com.amazonaws.services.qapps.model.ListQAppsResult;
import com.amazonaws.services.qapps.model.ListTagsForResourceRequest;
import com.amazonaws.services.qapps.model.ListTagsForResourceResult;
import com.amazonaws.services.qapps.model.PredictQAppRequest;
import com.amazonaws.services.qapps.model.PredictQAppResult;
import com.amazonaws.services.qapps.model.StartQAppSessionRequest;
import com.amazonaws.services.qapps.model.StartQAppSessionResult;
import com.amazonaws.services.qapps.model.StopQAppSessionRequest;
import com.amazonaws.services.qapps.model.StopQAppSessionResult;
import com.amazonaws.services.qapps.model.TagResourceRequest;
import com.amazonaws.services.qapps.model.TagResourceResult;
import com.amazonaws.services.qapps.model.UntagResourceRequest;
import com.amazonaws.services.qapps.model.UntagResourceResult;
import com.amazonaws.services.qapps.model.UpdateLibraryItemRequest;
import com.amazonaws.services.qapps.model.UpdateLibraryItemResult;
import com.amazonaws.services.qapps.model.UpdateQAppRequest;
import com.amazonaws.services.qapps.model.UpdateQAppResult;
import com.amazonaws.services.qapps.model.UpdateQAppSessionRequest;
import com.amazonaws.services.qapps.model.UpdateQAppSessionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSQAppsAsyncClient
extends AWSQAppsClient
implements AWSQAppsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSQAppsAsyncClientBuilder asyncBuilder() {
        return AWSQAppsAsyncClientBuilder.standard();
    }

    AWSQAppsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSQAppsAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateLibraryItemReviewResult> associateLibraryItemReviewAsync(AssociateLibraryItemReviewRequest request) {
        return this.associateLibraryItemReviewAsync(request, null);
    }

    @Override
    public Future<AssociateLibraryItemReviewResult> associateLibraryItemReviewAsync(AssociateLibraryItemReviewRequest request, final AsyncHandler<AssociateLibraryItemReviewRequest, AssociateLibraryItemReviewResult> asyncHandler) {
        final AssociateLibraryItemReviewRequest finalRequest = (AssociateLibraryItemReviewRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateLibraryItemReviewResult>(){

            @Override
            public AssociateLibraryItemReviewResult call() throws Exception {
                AssociateLibraryItemReviewResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeAssociateLibraryItemReview(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssociateQAppWithUserResult> associateQAppWithUserAsync(AssociateQAppWithUserRequest request) {
        return this.associateQAppWithUserAsync(request, null);
    }

    @Override
    public Future<AssociateQAppWithUserResult> associateQAppWithUserAsync(AssociateQAppWithUserRequest request, final AsyncHandler<AssociateQAppWithUserRequest, AssociateQAppWithUserResult> asyncHandler) {
        final AssociateQAppWithUserRequest finalRequest = (AssociateQAppWithUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateQAppWithUserResult>(){

            @Override
            public AssociateQAppWithUserResult call() throws Exception {
                AssociateQAppWithUserResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeAssociateQAppWithUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLibraryItemResult> createLibraryItemAsync(CreateLibraryItemRequest request) {
        return this.createLibraryItemAsync(request, null);
    }

    @Override
    public Future<CreateLibraryItemResult> createLibraryItemAsync(CreateLibraryItemRequest request, final AsyncHandler<CreateLibraryItemRequest, CreateLibraryItemResult> asyncHandler) {
        final CreateLibraryItemRequest finalRequest = (CreateLibraryItemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateLibraryItemResult>(){

            @Override
            public CreateLibraryItemResult call() throws Exception {
                CreateLibraryItemResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeCreateLibraryItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateQAppResult> createQAppAsync(CreateQAppRequest request) {
        return this.createQAppAsync(request, null);
    }

    @Override
    public Future<CreateQAppResult> createQAppAsync(CreateQAppRequest request, final AsyncHandler<CreateQAppRequest, CreateQAppResult> asyncHandler) {
        final CreateQAppRequest finalRequest = (CreateQAppRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateQAppResult>(){

            @Override
            public CreateQAppResult call() throws Exception {
                CreateQAppResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeCreateQApp(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLibraryItemResult> deleteLibraryItemAsync(DeleteLibraryItemRequest request) {
        return this.deleteLibraryItemAsync(request, null);
    }

    @Override
    public Future<DeleteLibraryItemResult> deleteLibraryItemAsync(DeleteLibraryItemRequest request, final AsyncHandler<DeleteLibraryItemRequest, DeleteLibraryItemResult> asyncHandler) {
        final DeleteLibraryItemRequest finalRequest = (DeleteLibraryItemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteLibraryItemResult>(){

            @Override
            public DeleteLibraryItemResult call() throws Exception {
                DeleteLibraryItemResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeDeleteLibraryItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteQAppResult> deleteQAppAsync(DeleteQAppRequest request) {
        return this.deleteQAppAsync(request, null);
    }

    @Override
    public Future<DeleteQAppResult> deleteQAppAsync(DeleteQAppRequest request, final AsyncHandler<DeleteQAppRequest, DeleteQAppResult> asyncHandler) {
        final DeleteQAppRequest finalRequest = (DeleteQAppRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteQAppResult>(){

            @Override
            public DeleteQAppResult call() throws Exception {
                DeleteQAppResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeDeleteQApp(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateLibraryItemReviewResult> disassociateLibraryItemReviewAsync(DisassociateLibraryItemReviewRequest request) {
        return this.disassociateLibraryItemReviewAsync(request, null);
    }

    @Override
    public Future<DisassociateLibraryItemReviewResult> disassociateLibraryItemReviewAsync(DisassociateLibraryItemReviewRequest request, final AsyncHandler<DisassociateLibraryItemReviewRequest, DisassociateLibraryItemReviewResult> asyncHandler) {
        final DisassociateLibraryItemReviewRequest finalRequest = (DisassociateLibraryItemReviewRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateLibraryItemReviewResult>(){

            @Override
            public DisassociateLibraryItemReviewResult call() throws Exception {
                DisassociateLibraryItemReviewResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeDisassociateLibraryItemReview(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateQAppFromUserResult> disassociateQAppFromUserAsync(DisassociateQAppFromUserRequest request) {
        return this.disassociateQAppFromUserAsync(request, null);
    }

    @Override
    public Future<DisassociateQAppFromUserResult> disassociateQAppFromUserAsync(DisassociateQAppFromUserRequest request, final AsyncHandler<DisassociateQAppFromUserRequest, DisassociateQAppFromUserResult> asyncHandler) {
        final DisassociateQAppFromUserRequest finalRequest = (DisassociateQAppFromUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateQAppFromUserResult>(){

            @Override
            public DisassociateQAppFromUserResult call() throws Exception {
                DisassociateQAppFromUserResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeDisassociateQAppFromUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLibraryItemResult> getLibraryItemAsync(GetLibraryItemRequest request) {
        return this.getLibraryItemAsync(request, null);
    }

    @Override
    public Future<GetLibraryItemResult> getLibraryItemAsync(GetLibraryItemRequest request, final AsyncHandler<GetLibraryItemRequest, GetLibraryItemResult> asyncHandler) {
        final GetLibraryItemRequest finalRequest = (GetLibraryItemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLibraryItemResult>(){

            @Override
            public GetLibraryItemResult call() throws Exception {
                GetLibraryItemResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeGetLibraryItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetQAppResult> getQAppAsync(GetQAppRequest request) {
        return this.getQAppAsync(request, null);
    }

    @Override
    public Future<GetQAppResult> getQAppAsync(GetQAppRequest request, final AsyncHandler<GetQAppRequest, GetQAppResult> asyncHandler) {
        final GetQAppRequest finalRequest = (GetQAppRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetQAppResult>(){

            @Override
            public GetQAppResult call() throws Exception {
                GetQAppResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeGetQApp(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetQAppSessionResult> getQAppSessionAsync(GetQAppSessionRequest request) {
        return this.getQAppSessionAsync(request, null);
    }

    @Override
    public Future<GetQAppSessionResult> getQAppSessionAsync(GetQAppSessionRequest request, final AsyncHandler<GetQAppSessionRequest, GetQAppSessionResult> asyncHandler) {
        final GetQAppSessionRequest finalRequest = (GetQAppSessionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetQAppSessionResult>(){

            @Override
            public GetQAppSessionResult call() throws Exception {
                GetQAppSessionResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeGetQAppSession(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ImportDocumentResult> importDocumentAsync(ImportDocumentRequest request) {
        return this.importDocumentAsync(request, null);
    }

    @Override
    public Future<ImportDocumentResult> importDocumentAsync(ImportDocumentRequest request, final AsyncHandler<ImportDocumentRequest, ImportDocumentResult> asyncHandler) {
        final ImportDocumentRequest finalRequest = (ImportDocumentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ImportDocumentResult>(){

            @Override
            public ImportDocumentResult call() throws Exception {
                ImportDocumentResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeImportDocument(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLibraryItemsResult> listLibraryItemsAsync(ListLibraryItemsRequest request) {
        return this.listLibraryItemsAsync(request, null);
    }

    @Override
    public Future<ListLibraryItemsResult> listLibraryItemsAsync(ListLibraryItemsRequest request, final AsyncHandler<ListLibraryItemsRequest, ListLibraryItemsResult> asyncHandler) {
        final ListLibraryItemsRequest finalRequest = (ListLibraryItemsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListLibraryItemsResult>(){

            @Override
            public ListLibraryItemsResult call() throws Exception {
                ListLibraryItemsResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeListLibraryItems(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListQAppsResult> listQAppsAsync(ListQAppsRequest request) {
        return this.listQAppsAsync(request, null);
    }

    @Override
    public Future<ListQAppsResult> listQAppsAsync(ListQAppsRequest request, final AsyncHandler<ListQAppsRequest, ListQAppsResult> asyncHandler) {
        final ListQAppsRequest finalRequest = (ListQAppsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListQAppsResult>(){

            @Override
            public ListQAppsResult call() throws Exception {
                ListQAppsResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeListQApps(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PredictQAppResult> predictQAppAsync(PredictQAppRequest request) {
        return this.predictQAppAsync(request, null);
    }

    @Override
    public Future<PredictQAppResult> predictQAppAsync(PredictQAppRequest request, final AsyncHandler<PredictQAppRequest, PredictQAppResult> asyncHandler) {
        final PredictQAppRequest finalRequest = (PredictQAppRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PredictQAppResult>(){

            @Override
            public PredictQAppResult call() throws Exception {
                PredictQAppResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executePredictQApp(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartQAppSessionResult> startQAppSessionAsync(StartQAppSessionRequest request) {
        return this.startQAppSessionAsync(request, null);
    }

    @Override
    public Future<StartQAppSessionResult> startQAppSessionAsync(StartQAppSessionRequest request, final AsyncHandler<StartQAppSessionRequest, StartQAppSessionResult> asyncHandler) {
        final StartQAppSessionRequest finalRequest = (StartQAppSessionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartQAppSessionResult>(){

            @Override
            public StartQAppSessionResult call() throws Exception {
                StartQAppSessionResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeStartQAppSession(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopQAppSessionResult> stopQAppSessionAsync(StopQAppSessionRequest request) {
        return this.stopQAppSessionAsync(request, null);
    }

    @Override
    public Future<StopQAppSessionResult> stopQAppSessionAsync(StopQAppSessionRequest request, final AsyncHandler<StopQAppSessionRequest, StopQAppSessionResult> asyncHandler) {
        final StopQAppSessionRequest finalRequest = (StopQAppSessionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopQAppSessionResult>(){

            @Override
            public StopQAppSessionResult call() throws Exception {
                StopQAppSessionResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeStopQAppSession(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateLibraryItemResult> updateLibraryItemAsync(UpdateLibraryItemRequest request) {
        return this.updateLibraryItemAsync(request, null);
    }

    @Override
    public Future<UpdateLibraryItemResult> updateLibraryItemAsync(UpdateLibraryItemRequest request, final AsyncHandler<UpdateLibraryItemRequest, UpdateLibraryItemResult> asyncHandler) {
        final UpdateLibraryItemRequest finalRequest = (UpdateLibraryItemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateLibraryItemResult>(){

            @Override
            public UpdateLibraryItemResult call() throws Exception {
                UpdateLibraryItemResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeUpdateLibraryItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateQAppResult> updateQAppAsync(UpdateQAppRequest request) {
        return this.updateQAppAsync(request, null);
    }

    @Override
    public Future<UpdateQAppResult> updateQAppAsync(UpdateQAppRequest request, final AsyncHandler<UpdateQAppRequest, UpdateQAppResult> asyncHandler) {
        final UpdateQAppRequest finalRequest = (UpdateQAppRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateQAppResult>(){

            @Override
            public UpdateQAppResult call() throws Exception {
                UpdateQAppResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeUpdateQApp(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateQAppSessionResult> updateQAppSessionAsync(UpdateQAppSessionRequest request) {
        return this.updateQAppSessionAsync(request, null);
    }

    @Override
    public Future<UpdateQAppSessionResult> updateQAppSessionAsync(UpdateQAppSessionRequest request, final AsyncHandler<UpdateQAppSessionRequest, UpdateQAppSessionResult> asyncHandler) {
        final UpdateQAppSessionRequest finalRequest = (UpdateQAppSessionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateQAppSessionResult>(){

            @Override
            public UpdateQAppSessionResult call() throws Exception {
                UpdateQAppSessionResult result = null;
                try {
                    result = AWSQAppsAsyncClient.this.executeUpdateQAppSession(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

