/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.prometheus.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.prometheus.model.EksConfiguration;
import java.util.List;

@SdkInternalApi
public class EksConfigurationMarshaller {
    private static final MarshallingInfo<String> CLUSTERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clusterArn").build();
    private static final MarshallingInfo<List> SECURITYGROUPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("securityGroupIds").build();
    private static final MarshallingInfo<List> SUBNETIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subnetIds").build();
    private static final EksConfigurationMarshaller instance = new EksConfigurationMarshaller();

    public static EksConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(EksConfiguration eksConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (eksConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)eksConfiguration.getClusterArn(), CLUSTERARN_BINDING);
            protocolMarshaller.marshall(eksConfiguration.getSecurityGroupIds(), SECURITYGROUPIDS_BINDING);
            protocolMarshaller.marshall(eksConfiguration.getSubnetIds(), SUBNETIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

