/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.prometheus.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.prometheus.model.ScraperSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListScrapersResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ScraperSummary> scrapers;
    private String nextToken;

    public List<ScraperSummary> getScrapers() {
        return this.scrapers;
    }

    public void setScrapers(Collection<ScraperSummary> scrapers) {
        if (scrapers == null) {
            this.scrapers = null;
            return;
        }
        this.scrapers = new ArrayList<ScraperSummary>(scrapers);
    }

    public ListScrapersResult withScrapers(ScraperSummary ... scrapers) {
        if (this.scrapers == null) {
            this.setScrapers(new ArrayList<ScraperSummary>(scrapers.length));
        }
        for (ScraperSummary ele : scrapers) {
            this.scrapers.add(ele);
        }
        return this;
    }

    public ListScrapersResult withScrapers(Collection<ScraperSummary> scrapers) {
        this.setScrapers(scrapers);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListScrapersResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getScrapers() != null) {
            sb.append("Scrapers: ").append(this.getScrapers()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScrapersResult)) {
            return false;
        }
        ListScrapersResult other = (ListScrapersResult)obj;
        if (other.getScrapers() == null ^ this.getScrapers() == null) {
            return false;
        }
        if (other.getScrapers() != null && !other.getScrapers().equals(this.getScrapers())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getScrapers() == null ? 0 : this.getScrapers().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListScrapersResult clone() {
        try {
            return (ListScrapersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

