/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.presign.PresignerParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.polly.AmazonPolly;
import com.amazonaws.services.polly.AmazonPollyClientBuilder;
import com.amazonaws.services.polly.model.AmazonPollyException;
import com.amazonaws.services.polly.model.DeleteLexiconRequest;
import com.amazonaws.services.polly.model.DeleteLexiconResult;
import com.amazonaws.services.polly.model.DescribeVoicesRequest;
import com.amazonaws.services.polly.model.DescribeVoicesResult;
import com.amazonaws.services.polly.model.GetLexiconRequest;
import com.amazonaws.services.polly.model.GetLexiconResult;
import com.amazonaws.services.polly.model.GetSpeechSynthesisTaskRequest;
import com.amazonaws.services.polly.model.GetSpeechSynthesisTaskResult;
import com.amazonaws.services.polly.model.ListLexiconsRequest;
import com.amazonaws.services.polly.model.ListLexiconsResult;
import com.amazonaws.services.polly.model.ListSpeechSynthesisTasksRequest;
import com.amazonaws.services.polly.model.ListSpeechSynthesisTasksResult;
import com.amazonaws.services.polly.model.PutLexiconRequest;
import com.amazonaws.services.polly.model.PutLexiconResult;
import com.amazonaws.services.polly.model.StartSpeechSynthesisTaskRequest;
import com.amazonaws.services.polly.model.StartSpeechSynthesisTaskResult;
import com.amazonaws.services.polly.model.SynthesizeSpeechRequest;
import com.amazonaws.services.polly.model.SynthesizeSpeechResult;
import com.amazonaws.services.polly.model.transform.DeleteLexiconRequestProtocolMarshaller;
import com.amazonaws.services.polly.model.transform.DeleteLexiconResultJsonUnmarshaller;
import com.amazonaws.services.polly.model.transform.DescribeVoicesRequestProtocolMarshaller;
import com.amazonaws.services.polly.model.transform.DescribeVoicesResultJsonUnmarshaller;
import com.amazonaws.services.polly.model.transform.EngineNotSupportedExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.GetLexiconRequestProtocolMarshaller;
import com.amazonaws.services.polly.model.transform.GetLexiconResultJsonUnmarshaller;
import com.amazonaws.services.polly.model.transform.GetSpeechSynthesisTaskRequestProtocolMarshaller;
import com.amazonaws.services.polly.model.transform.GetSpeechSynthesisTaskResultJsonUnmarshaller;
import com.amazonaws.services.polly.model.transform.InvalidLexiconExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.InvalidS3BucketExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.InvalidS3KeyExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.InvalidSampleRateExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.InvalidSnsTopicArnExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.InvalidSsmlExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.InvalidTaskIdExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.LanguageNotSupportedExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.LexiconNotFoundExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.LexiconSizeExceededExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.ListLexiconsRequestProtocolMarshaller;
import com.amazonaws.services.polly.model.transform.ListLexiconsResultJsonUnmarshaller;
import com.amazonaws.services.polly.model.transform.ListSpeechSynthesisTasksRequestProtocolMarshaller;
import com.amazonaws.services.polly.model.transform.ListSpeechSynthesisTasksResultJsonUnmarshaller;
import com.amazonaws.services.polly.model.transform.MarksNotSupportedForFormatExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.MaxLexemeLengthExceededExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.MaxLexiconsNumberExceededExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.PutLexiconRequestProtocolMarshaller;
import com.amazonaws.services.polly.model.transform.PutLexiconResultJsonUnmarshaller;
import com.amazonaws.services.polly.model.transform.ServiceFailureExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.SsmlMarksNotSupportedForTextTypeExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.StartSpeechSynthesisTaskRequestProtocolMarshaller;
import com.amazonaws.services.polly.model.transform.StartSpeechSynthesisTaskResultJsonUnmarshaller;
import com.amazonaws.services.polly.model.transform.SynthesisTaskNotFoundExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.SynthesizeSpeechRequestProtocolMarshaller;
import com.amazonaws.services.polly.model.transform.SynthesizeSpeechResultJsonUnmarshaller;
import com.amazonaws.services.polly.model.transform.TextLengthExceededExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.UnsupportedPlsAlphabetExceptionUnmarshaller;
import com.amazonaws.services.polly.model.transform.UnsupportedPlsLanguageExceptionUnmarshaller;
import com.amazonaws.services.polly.presign.AmazonPollyPresigners;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonPollyClient
extends AmazonWebServiceClient
implements AmazonPolly {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonPolly.class);
    private static final String DEFAULT_SIGNING_NAME = "polly";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidS3BucketException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidS3BucketExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSampleRateException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidSampleRateExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SynthesisTaskNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)SynthesisTaskNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MaxLexiconsNumberExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)MaxLexiconsNumberExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MaxLexemeLengthExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)MaxLexemeLengthExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedPlsAlphabetException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnsupportedPlsAlphabetExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LanguageNotSupportedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LanguageNotSupportedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TextLengthExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TextLengthExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidLexiconException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidLexiconExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SsmlMarksNotSupportedForTextTypeException").withExceptionUnmarshaller((JsonErrorUnmarshaller)SsmlMarksNotSupportedForTextTypeExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidS3KeyException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidS3KeyExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSnsTopicArnException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidSnsTopicArnExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MarksNotSupportedForFormatException").withExceptionUnmarshaller((JsonErrorUnmarshaller)MarksNotSupportedForFormatExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidTaskIdException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidTaskIdExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedPlsLanguageException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnsupportedPlsLanguageExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LexiconNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LexiconNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LexiconSizeExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LexiconSizeExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSsmlException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidSsmlExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidNextTokenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EngineNotSupportedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)EngineNotSupportedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceFailureException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceFailureExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonPollyException.class));

    @Deprecated
    public AmazonPollyClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonPollyClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonPollyClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonPollyClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    @Deprecated
    public AmazonPollyClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonPollyClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonPollyClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    public static AmazonPollyClientBuilder builder() {
        return AmazonPollyClientBuilder.standard();
    }

    AmazonPollyClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonPollyClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("polly.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/polly/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/polly/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public DeleteLexiconResult deleteLexicon(DeleteLexiconRequest request) {
        request = (DeleteLexiconRequest)this.beforeClientExecution(request);
        return this.executeDeleteLexicon(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteLexiconResult executeDeleteLexicon(DeleteLexiconRequest deleteLexiconRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteLexiconRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteLexiconRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteLexiconRequestProtocolMarshaller(protocolFactory).marshall((DeleteLexiconRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteLexiconRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Polly");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteLexicon");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteLexiconResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteLexiconResult deleteLexiconResult = (DeleteLexiconResult)response.getAwsResponse();
            return deleteLexiconResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeVoicesResult describeVoices(DescribeVoicesRequest request) {
        request = (DescribeVoicesRequest)this.beforeClientExecution(request);
        return this.executeDescribeVoices(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeVoicesResult executeDescribeVoices(DescribeVoicesRequest describeVoicesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeVoicesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeVoicesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeVoicesRequestProtocolMarshaller(protocolFactory).marshall((DescribeVoicesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeVoicesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Polly");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeVoices");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeVoicesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeVoicesResult describeVoicesResult = (DescribeVoicesResult)response.getAwsResponse();
            return describeVoicesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetLexiconResult getLexicon(GetLexiconRequest request) {
        request = (GetLexiconRequest)this.beforeClientExecution(request);
        return this.executeGetLexicon(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetLexiconResult executeGetLexicon(GetLexiconRequest getLexiconRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getLexiconRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetLexiconRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetLexiconRequestProtocolMarshaller(protocolFactory).marshall((GetLexiconRequest)super.beforeMarshalling((AmazonWebServiceRequest)getLexiconRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Polly");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetLexicon");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetLexiconResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetLexiconResult getLexiconResult = (GetLexiconResult)response.getAwsResponse();
            return getLexiconResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSpeechSynthesisTaskResult getSpeechSynthesisTask(GetSpeechSynthesisTaskRequest request) {
        request = (GetSpeechSynthesisTaskRequest)this.beforeClientExecution(request);
        return this.executeGetSpeechSynthesisTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSpeechSynthesisTaskResult executeGetSpeechSynthesisTask(GetSpeechSynthesisTaskRequest getSpeechSynthesisTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSpeechSynthesisTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSpeechSynthesisTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSpeechSynthesisTaskRequestProtocolMarshaller(protocolFactory).marshall((GetSpeechSynthesisTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSpeechSynthesisTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Polly");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSpeechSynthesisTask");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSpeechSynthesisTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSpeechSynthesisTaskResult getSpeechSynthesisTaskResult = (GetSpeechSynthesisTaskResult)response.getAwsResponse();
            return getSpeechSynthesisTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListLexiconsResult listLexicons(ListLexiconsRequest request) {
        request = (ListLexiconsRequest)this.beforeClientExecution(request);
        return this.executeListLexicons(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListLexiconsResult executeListLexicons(ListLexiconsRequest listLexiconsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listLexiconsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListLexiconsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListLexiconsRequestProtocolMarshaller(protocolFactory).marshall((ListLexiconsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listLexiconsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Polly");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListLexicons");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListLexiconsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListLexiconsResult listLexiconsResult = (ListLexiconsResult)response.getAwsResponse();
            return listLexiconsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSpeechSynthesisTasksResult listSpeechSynthesisTasks(ListSpeechSynthesisTasksRequest request) {
        request = (ListSpeechSynthesisTasksRequest)this.beforeClientExecution(request);
        return this.executeListSpeechSynthesisTasks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSpeechSynthesisTasksResult executeListSpeechSynthesisTasks(ListSpeechSynthesisTasksRequest listSpeechSynthesisTasksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSpeechSynthesisTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSpeechSynthesisTasksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSpeechSynthesisTasksRequestProtocolMarshaller(protocolFactory).marshall((ListSpeechSynthesisTasksRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSpeechSynthesisTasksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Polly");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSpeechSynthesisTasks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSpeechSynthesisTasksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSpeechSynthesisTasksResult listSpeechSynthesisTasksResult = (ListSpeechSynthesisTasksResult)response.getAwsResponse();
            return listSpeechSynthesisTasksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutLexiconResult putLexicon(PutLexiconRequest request) {
        request = (PutLexiconRequest)this.beforeClientExecution(request);
        return this.executePutLexicon(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutLexiconResult executePutLexicon(PutLexiconRequest putLexiconRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putLexiconRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutLexiconRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutLexiconRequestProtocolMarshaller(protocolFactory).marshall((PutLexiconRequest)super.beforeMarshalling((AmazonWebServiceRequest)putLexiconRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Polly");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutLexicon");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutLexiconResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutLexiconResult putLexiconResult = (PutLexiconResult)response.getAwsResponse();
            return putLexiconResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartSpeechSynthesisTaskResult startSpeechSynthesisTask(StartSpeechSynthesisTaskRequest request) {
        request = (StartSpeechSynthesisTaskRequest)this.beforeClientExecution(request);
        return this.executeStartSpeechSynthesisTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartSpeechSynthesisTaskResult executeStartSpeechSynthesisTask(StartSpeechSynthesisTaskRequest startSpeechSynthesisTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startSpeechSynthesisTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartSpeechSynthesisTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartSpeechSynthesisTaskRequestProtocolMarshaller(protocolFactory).marshall((StartSpeechSynthesisTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)startSpeechSynthesisTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Polly");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartSpeechSynthesisTask");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartSpeechSynthesisTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartSpeechSynthesisTaskResult startSpeechSynthesisTaskResult = (StartSpeechSynthesisTaskResult)response.getAwsResponse();
            return startSpeechSynthesisTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SynthesizeSpeechResult synthesizeSpeech(SynthesizeSpeechRequest request) {
        request = (SynthesizeSpeechRequest)this.beforeClientExecution(request);
        return this.executeSynthesizeSpeech(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SynthesizeSpeechResult executeSynthesizeSpeech(SynthesizeSpeechRequest synthesizeSpeechRequest) {
        ExecutionContext executionContext = this.createExecutionContext(synthesizeSpeechRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SynthesizeSpeechRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SynthesizeSpeechRequestProtocolMarshaller(protocolFactory).marshall((SynthesizeSpeechRequest)super.beforeMarshalling((AmazonWebServiceRequest)synthesizeSpeechRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Polly");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SynthesizeSpeech");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(true), (Unmarshaller)new SynthesizeSpeechResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            request.addHandlerContext(HandlerContextKey.HAS_STREAMING_OUTPUT, (Object)Boolean.TRUE);
            SynthesizeSpeechResult synthesizeSpeechResult = (SynthesizeSpeechResult)response.getAwsResponse();
            return synthesizeSpeechResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public AmazonPollyPresigners presigners() {
        return new AmazonPollyPresigners(PresignerParams.builder().endpoint(this.endpoint).credentialsProvider(this.awsCredentialsProvider).signerProvider(this.getSignerProvider()).build());
    }
}

