/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.polly.model.PutLexiconRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PutLexiconRequestMarshaller
implements Marshaller<Request<PutLexiconRequest>, PutLexiconRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public PutLexiconRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PutLexiconRequest> marshall(PutLexiconRequest putLexiconRequest) {
        if (putLexiconRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putLexiconRequest, "AmazonPolly");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/v1/lexicons/{LexiconName}";
        uriResourcePath = uriResourcePath.replace("{LexiconName}", putLexiconRequest.getName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)putLexiconRequest.getName()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (putLexiconRequest.getContent() != null) {
                jsonGenerator.writeFieldName("Content").writeValue(putLexiconRequest.getContent());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

