/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pipes.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pipes.model.EcsEnvironmentFile;
import com.amazonaws.services.pipes.model.EcsEnvironmentVariable;
import com.amazonaws.services.pipes.model.EcsResourceRequirement;
import com.amazonaws.services.pipes.model.transform.EcsContainerOverrideMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EcsContainerOverride
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> command;
    private Integer cpu;
    private List<EcsEnvironmentVariable> environment;
    private List<EcsEnvironmentFile> environmentFiles;
    private Integer memory;
    private Integer memoryReservation;
    private String name;
    private List<EcsResourceRequirement> resourceRequirements;

    public List<String> getCommand() {
        return this.command;
    }

    public void setCommand(Collection<String> command) {
        if (command == null) {
            this.command = null;
            return;
        }
        this.command = new ArrayList<String>(command);
    }

    public EcsContainerOverride withCommand(String ... command) {
        if (this.command == null) {
            this.setCommand(new ArrayList<String>(command.length));
        }
        for (String ele : command) {
            this.command.add(ele);
        }
        return this;
    }

    public EcsContainerOverride withCommand(Collection<String> command) {
        this.setCommand(command);
        return this;
    }

    public void setCpu(Integer cpu) {
        this.cpu = cpu;
    }

    public Integer getCpu() {
        return this.cpu;
    }

    public EcsContainerOverride withCpu(Integer cpu) {
        this.setCpu(cpu);
        return this;
    }

    public List<EcsEnvironmentVariable> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Collection<EcsEnvironmentVariable> environment) {
        if (environment == null) {
            this.environment = null;
            return;
        }
        this.environment = new ArrayList<EcsEnvironmentVariable>(environment);
    }

    public EcsContainerOverride withEnvironment(EcsEnvironmentVariable ... environment) {
        if (this.environment == null) {
            this.setEnvironment(new ArrayList<EcsEnvironmentVariable>(environment.length));
        }
        for (EcsEnvironmentVariable ele : environment) {
            this.environment.add(ele);
        }
        return this;
    }

    public EcsContainerOverride withEnvironment(Collection<EcsEnvironmentVariable> environment) {
        this.setEnvironment(environment);
        return this;
    }

    public List<EcsEnvironmentFile> getEnvironmentFiles() {
        return this.environmentFiles;
    }

    public void setEnvironmentFiles(Collection<EcsEnvironmentFile> environmentFiles) {
        if (environmentFiles == null) {
            this.environmentFiles = null;
            return;
        }
        this.environmentFiles = new ArrayList<EcsEnvironmentFile>(environmentFiles);
    }

    public EcsContainerOverride withEnvironmentFiles(EcsEnvironmentFile ... environmentFiles) {
        if (this.environmentFiles == null) {
            this.setEnvironmentFiles(new ArrayList<EcsEnvironmentFile>(environmentFiles.length));
        }
        for (EcsEnvironmentFile ele : environmentFiles) {
            this.environmentFiles.add(ele);
        }
        return this;
    }

    public EcsContainerOverride withEnvironmentFiles(Collection<EcsEnvironmentFile> environmentFiles) {
        this.setEnvironmentFiles(environmentFiles);
        return this;
    }

    public void setMemory(Integer memory) {
        this.memory = memory;
    }

    public Integer getMemory() {
        return this.memory;
    }

    public EcsContainerOverride withMemory(Integer memory) {
        this.setMemory(memory);
        return this;
    }

    public void setMemoryReservation(Integer memoryReservation) {
        this.memoryReservation = memoryReservation;
    }

    public Integer getMemoryReservation() {
        return this.memoryReservation;
    }

    public EcsContainerOverride withMemoryReservation(Integer memoryReservation) {
        this.setMemoryReservation(memoryReservation);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public EcsContainerOverride withName(String name) {
        this.setName(name);
        return this;
    }

    public List<EcsResourceRequirement> getResourceRequirements() {
        return this.resourceRequirements;
    }

    public void setResourceRequirements(Collection<EcsResourceRequirement> resourceRequirements) {
        if (resourceRequirements == null) {
            this.resourceRequirements = null;
            return;
        }
        this.resourceRequirements = new ArrayList<EcsResourceRequirement>(resourceRequirements);
    }

    public EcsContainerOverride withResourceRequirements(EcsResourceRequirement ... resourceRequirements) {
        if (this.resourceRequirements == null) {
            this.setResourceRequirements(new ArrayList<EcsResourceRequirement>(resourceRequirements.length));
        }
        for (EcsResourceRequirement ele : resourceRequirements) {
            this.resourceRequirements.add(ele);
        }
        return this;
    }

    public EcsContainerOverride withResourceRequirements(Collection<EcsResourceRequirement> resourceRequirements) {
        this.setResourceRequirements(resourceRequirements);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCommand() != null) {
            sb.append("Command: ").append(this.getCommand()).append(",");
        }
        if (this.getCpu() != null) {
            sb.append("Cpu: ").append(this.getCpu()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment()).append(",");
        }
        if (this.getEnvironmentFiles() != null) {
            sb.append("EnvironmentFiles: ").append(this.getEnvironmentFiles()).append(",");
        }
        if (this.getMemory() != null) {
            sb.append("Memory: ").append(this.getMemory()).append(",");
        }
        if (this.getMemoryReservation() != null) {
            sb.append("MemoryReservation: ").append(this.getMemoryReservation()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getResourceRequirements() != null) {
            sb.append("ResourceRequirements: ").append(this.getResourceRequirements());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsContainerOverride)) {
            return false;
        }
        EcsContainerOverride other = (EcsContainerOverride)obj;
        if (other.getCommand() == null ^ this.getCommand() == null) {
            return false;
        }
        if (other.getCommand() != null && !other.getCommand().equals(this.getCommand())) {
            return false;
        }
        if (other.getCpu() == null ^ this.getCpu() == null) {
            return false;
        }
        if (other.getCpu() != null && !other.getCpu().equals(this.getCpu())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        if (other.getEnvironment() != null && !other.getEnvironment().equals(this.getEnvironment())) {
            return false;
        }
        if (other.getEnvironmentFiles() == null ^ this.getEnvironmentFiles() == null) {
            return false;
        }
        if (other.getEnvironmentFiles() != null && !other.getEnvironmentFiles().equals(this.getEnvironmentFiles())) {
            return false;
        }
        if (other.getMemory() == null ^ this.getMemory() == null) {
            return false;
        }
        if (other.getMemory() != null && !other.getMemory().equals(this.getMemory())) {
            return false;
        }
        if (other.getMemoryReservation() == null ^ this.getMemoryReservation() == null) {
            return false;
        }
        if (other.getMemoryReservation() != null && !other.getMemoryReservation().equals(this.getMemoryReservation())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getResourceRequirements() == null ^ this.getResourceRequirements() == null) {
            return false;
        }
        return other.getResourceRequirements() == null || other.getResourceRequirements().equals(this.getResourceRequirements());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCommand() == null ? 0 : this.getCommand().hashCode());
        hashCode = 31 * hashCode + (this.getCpu() == null ? 0 : this.getCpu().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentFiles() == null ? 0 : this.getEnvironmentFiles().hashCode());
        hashCode = 31 * hashCode + (this.getMemory() == null ? 0 : this.getMemory().hashCode());
        hashCode = 31 * hashCode + (this.getMemoryReservation() == null ? 0 : this.getMemoryReservation().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getResourceRequirements() == null ? 0 : this.getResourceRequirements().hashCode());
        return hashCode;
    }

    public EcsContainerOverride clone() {
        try {
            return (EcsContainerOverride)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EcsContainerOverrideMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

