/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.pipes.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The Amazon Kinesis Data Firehose logging configuration settings for the pipe.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/FirehoseLogDestinationParameters"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class FirehoseLogDestinationParameters implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the Kinesis Data Firehose delivery stream to which EventBridge
     * delivers the pipe log records.
     * </p>
     */
    private String deliveryStreamArn;

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the Kinesis Data Firehose delivery stream to which EventBridge
     * delivers the pipe log records.
     * </p>
     * 
     * @param deliveryStreamArn
     *        Specifies the Amazon Resource Name (ARN) of the Kinesis Data Firehose delivery stream to which EventBridge
     *        delivers the pipe log records.
     */

    public void setDeliveryStreamArn(String deliveryStreamArn) {
        this.deliveryStreamArn = deliveryStreamArn;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the Kinesis Data Firehose delivery stream to which EventBridge
     * delivers the pipe log records.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the Kinesis Data Firehose delivery stream to which
     *         EventBridge delivers the pipe log records.
     */

    public String getDeliveryStreamArn() {
        return this.deliveryStreamArn;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the Kinesis Data Firehose delivery stream to which EventBridge
     * delivers the pipe log records.
     * </p>
     * 
     * @param deliveryStreamArn
     *        Specifies the Amazon Resource Name (ARN) of the Kinesis Data Firehose delivery stream to which EventBridge
     *        delivers the pipe log records.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FirehoseLogDestinationParameters withDeliveryStreamArn(String deliveryStreamArn) {
        setDeliveryStreamArn(deliveryStreamArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDeliveryStreamArn() != null)
            sb.append("DeliveryStreamArn: ").append(getDeliveryStreamArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof FirehoseLogDestinationParameters == false)
            return false;
        FirehoseLogDestinationParameters other = (FirehoseLogDestinationParameters) obj;
        if (other.getDeliveryStreamArn() == null ^ this.getDeliveryStreamArn() == null)
            return false;
        if (other.getDeliveryStreamArn() != null && other.getDeliveryStreamArn().equals(this.getDeliveryStreamArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDeliveryStreamArn() == null) ? 0 : getDeliveryStreamArn().hashCode());
        return hashCode;
    }

    @Override
    public FirehoseLogDestinationParameters clone() {
        try {
            return (FirehoseLogDestinationParameters) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.pipes.model.transform.FirehoseLogDestinationParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
