/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pinpoint.model.InAppMessage;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class InAppMessageMarshaller {
    private static final MarshallingInfo<List> CONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Content").build();
    private static final MarshallingInfo<Map> CUSTOMCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomConfig").build();
    private static final MarshallingInfo<String> LAYOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Layout").build();
    private static final InAppMessageMarshaller instance = new InAppMessageMarshaller();

    public static InAppMessageMarshaller getInstance() {
        return instance;
    }

    public void marshall(InAppMessage inAppMessage, ProtocolMarshaller protocolMarshaller) {
        if (inAppMessage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(inAppMessage.getContent(), CONTENT_BINDING);
            protocolMarshaller.marshall(inAppMessage.getCustomConfig(), CUSTOMCONFIG_BINDING);
            protocolMarshaller.marshall((Object)inAppMessage.getLayout(), LAYOUT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

