/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.Activity;
import com.amazonaws.services.pinpoint.model.JourneyLimits;
import com.amazonaws.services.pinpoint.model.JourneySchedule;
import com.amazonaws.services.pinpoint.model.QuietTime;
import com.amazonaws.services.pinpoint.model.StartCondition;
import com.amazonaws.services.pinpoint.model.State;
import com.amazonaws.services.pinpoint.model.transform.WriteJourneyRequestMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class WriteJourneyRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, Activity> activities;
    private String creationDate;
    private String lastModifiedDate;
    private JourneyLimits limits;
    private Boolean localTime;
    private String name;
    private QuietTime quietTime;
    private String refreshFrequency;
    private JourneySchedule schedule;
    private String startActivity;
    private StartCondition startCondition;
    private String state;
    private Boolean waitForQuietTime;
    private Boolean refreshOnSegmentUpdate;

    public Map<String, Activity> getActivities() {
        return this.activities;
    }

    public void setActivities(Map<String, Activity> activities) {
        this.activities = activities;
    }

    public WriteJourneyRequest withActivities(Map<String, Activity> activities) {
        this.setActivities(activities);
        return this;
    }

    public WriteJourneyRequest addActivitiesEntry(String key, Activity value) {
        if (null == this.activities) {
            this.activities = new HashMap<String, Activity>();
        }
        if (this.activities.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.activities.put(key, value);
        return this;
    }

    public WriteJourneyRequest clearActivitiesEntries() {
        this.activities = null;
        return this;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public WriteJourneyRequest withCreationDate(String creationDate) {
        this.setCreationDate(creationDate);
        return this;
    }

    public void setLastModifiedDate(String lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public WriteJourneyRequest withLastModifiedDate(String lastModifiedDate) {
        this.setLastModifiedDate(lastModifiedDate);
        return this;
    }

    public void setLimits(JourneyLimits limits) {
        this.limits = limits;
    }

    public JourneyLimits getLimits() {
        return this.limits;
    }

    public WriteJourneyRequest withLimits(JourneyLimits limits) {
        this.setLimits(limits);
        return this;
    }

    public void setLocalTime(Boolean localTime) {
        this.localTime = localTime;
    }

    public Boolean getLocalTime() {
        return this.localTime;
    }

    public WriteJourneyRequest withLocalTime(Boolean localTime) {
        this.setLocalTime(localTime);
        return this;
    }

    public Boolean isLocalTime() {
        return this.localTime;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public WriteJourneyRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setQuietTime(QuietTime quietTime) {
        this.quietTime = quietTime;
    }

    public QuietTime getQuietTime() {
        return this.quietTime;
    }

    public WriteJourneyRequest withQuietTime(QuietTime quietTime) {
        this.setQuietTime(quietTime);
        return this;
    }

    public void setRefreshFrequency(String refreshFrequency) {
        this.refreshFrequency = refreshFrequency;
    }

    public String getRefreshFrequency() {
        return this.refreshFrequency;
    }

    public WriteJourneyRequest withRefreshFrequency(String refreshFrequency) {
        this.setRefreshFrequency(refreshFrequency);
        return this;
    }

    public void setSchedule(JourneySchedule schedule) {
        this.schedule = schedule;
    }

    public JourneySchedule getSchedule() {
        return this.schedule;
    }

    public WriteJourneyRequest withSchedule(JourneySchedule schedule) {
        this.setSchedule(schedule);
        return this;
    }

    public void setStartActivity(String startActivity) {
        this.startActivity = startActivity;
    }

    public String getStartActivity() {
        return this.startActivity;
    }

    public WriteJourneyRequest withStartActivity(String startActivity) {
        this.setStartActivity(startActivity);
        return this;
    }

    public void setStartCondition(StartCondition startCondition) {
        this.startCondition = startCondition;
    }

    public StartCondition getStartCondition() {
        return this.startCondition;
    }

    public WriteJourneyRequest withStartCondition(StartCondition startCondition) {
        this.setStartCondition(startCondition);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public WriteJourneyRequest withState(String state) {
        this.setState(state);
        return this;
    }

    public WriteJourneyRequest withState(State state) {
        this.state = state.toString();
        return this;
    }

    public void setWaitForQuietTime(Boolean waitForQuietTime) {
        this.waitForQuietTime = waitForQuietTime;
    }

    public Boolean getWaitForQuietTime() {
        return this.waitForQuietTime;
    }

    public WriteJourneyRequest withWaitForQuietTime(Boolean waitForQuietTime) {
        this.setWaitForQuietTime(waitForQuietTime);
        return this;
    }

    public Boolean isWaitForQuietTime() {
        return this.waitForQuietTime;
    }

    public void setRefreshOnSegmentUpdate(Boolean refreshOnSegmentUpdate) {
        this.refreshOnSegmentUpdate = refreshOnSegmentUpdate;
    }

    public Boolean getRefreshOnSegmentUpdate() {
        return this.refreshOnSegmentUpdate;
    }

    public WriteJourneyRequest withRefreshOnSegmentUpdate(Boolean refreshOnSegmentUpdate) {
        this.setRefreshOnSegmentUpdate(refreshOnSegmentUpdate);
        return this;
    }

    public Boolean isRefreshOnSegmentUpdate() {
        return this.refreshOnSegmentUpdate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActivities() != null) {
            sb.append("Activities: ").append(this.getActivities()).append(",");
        }
        if (this.getCreationDate() != null) {
            sb.append("CreationDate: ").append(this.getCreationDate()).append(",");
        }
        if (this.getLastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.getLastModifiedDate()).append(",");
        }
        if (this.getLimits() != null) {
            sb.append("Limits: ").append(this.getLimits()).append(",");
        }
        if (this.getLocalTime() != null) {
            sb.append("LocalTime: ").append(this.getLocalTime()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getQuietTime() != null) {
            sb.append("QuietTime: ").append(this.getQuietTime()).append(",");
        }
        if (this.getRefreshFrequency() != null) {
            sb.append("RefreshFrequency: ").append(this.getRefreshFrequency()).append(",");
        }
        if (this.getSchedule() != null) {
            sb.append("Schedule: ").append(this.getSchedule()).append(",");
        }
        if (this.getStartActivity() != null) {
            sb.append("StartActivity: ").append(this.getStartActivity()).append(",");
        }
        if (this.getStartCondition() != null) {
            sb.append("StartCondition: ").append(this.getStartCondition()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getWaitForQuietTime() != null) {
            sb.append("WaitForQuietTime: ").append(this.getWaitForQuietTime()).append(",");
        }
        if (this.getRefreshOnSegmentUpdate() != null) {
            sb.append("RefreshOnSegmentUpdate: ").append(this.getRefreshOnSegmentUpdate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteJourneyRequest)) {
            return false;
        }
        WriteJourneyRequest other = (WriteJourneyRequest)obj;
        if (other.getActivities() == null ^ this.getActivities() == null) {
            return false;
        }
        if (other.getActivities() != null && !other.getActivities().equals(this.getActivities())) {
            return false;
        }
        if (other.getCreationDate() == null ^ this.getCreationDate() == null) {
            return false;
        }
        if (other.getCreationDate() != null && !other.getCreationDate().equals(this.getCreationDate())) {
            return false;
        }
        if (other.getLastModifiedDate() == null ^ this.getLastModifiedDate() == null) {
            return false;
        }
        if (other.getLastModifiedDate() != null && !other.getLastModifiedDate().equals(this.getLastModifiedDate())) {
            return false;
        }
        if (other.getLimits() == null ^ this.getLimits() == null) {
            return false;
        }
        if (other.getLimits() != null && !other.getLimits().equals(this.getLimits())) {
            return false;
        }
        if (other.getLocalTime() == null ^ this.getLocalTime() == null) {
            return false;
        }
        if (other.getLocalTime() != null && !other.getLocalTime().equals(this.getLocalTime())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getQuietTime() == null ^ this.getQuietTime() == null) {
            return false;
        }
        if (other.getQuietTime() != null && !other.getQuietTime().equals(this.getQuietTime())) {
            return false;
        }
        if (other.getRefreshFrequency() == null ^ this.getRefreshFrequency() == null) {
            return false;
        }
        if (other.getRefreshFrequency() != null && !other.getRefreshFrequency().equals(this.getRefreshFrequency())) {
            return false;
        }
        if (other.getSchedule() == null ^ this.getSchedule() == null) {
            return false;
        }
        if (other.getSchedule() != null && !other.getSchedule().equals(this.getSchedule())) {
            return false;
        }
        if (other.getStartActivity() == null ^ this.getStartActivity() == null) {
            return false;
        }
        if (other.getStartActivity() != null && !other.getStartActivity().equals(this.getStartActivity())) {
            return false;
        }
        if (other.getStartCondition() == null ^ this.getStartCondition() == null) {
            return false;
        }
        if (other.getStartCondition() != null && !other.getStartCondition().equals(this.getStartCondition())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getWaitForQuietTime() == null ^ this.getWaitForQuietTime() == null) {
            return false;
        }
        if (other.getWaitForQuietTime() != null && !other.getWaitForQuietTime().equals(this.getWaitForQuietTime())) {
            return false;
        }
        if (other.getRefreshOnSegmentUpdate() == null ^ this.getRefreshOnSegmentUpdate() == null) {
            return false;
        }
        return other.getRefreshOnSegmentUpdate() == null || other.getRefreshOnSegmentUpdate().equals(this.getRefreshOnSegmentUpdate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActivities() == null ? 0 : this.getActivities().hashCode());
        hashCode = 31 * hashCode + (this.getCreationDate() == null ? 0 : this.getCreationDate().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedDate() == null ? 0 : this.getLastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.getLimits() == null ? 0 : this.getLimits().hashCode());
        hashCode = 31 * hashCode + (this.getLocalTime() == null ? 0 : this.getLocalTime().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getQuietTime() == null ? 0 : this.getQuietTime().hashCode());
        hashCode = 31 * hashCode + (this.getRefreshFrequency() == null ? 0 : this.getRefreshFrequency().hashCode());
        hashCode = 31 * hashCode + (this.getSchedule() == null ? 0 : this.getSchedule().hashCode());
        hashCode = 31 * hashCode + (this.getStartActivity() == null ? 0 : this.getStartActivity().hashCode());
        hashCode = 31 * hashCode + (this.getStartCondition() == null ? 0 : this.getStartCondition().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getWaitForQuietTime() == null ? 0 : this.getWaitForQuietTime().hashCode());
        hashCode = 31 * hashCode + (this.getRefreshOnSegmentUpdate() == null ? 0 : this.getRefreshOnSegmentUpdate().hashCode());
        return hashCode;
    }

    public WriteJourneyRequest clone() {
        try {
            return (WriteJourneyRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WriteJourneyRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

