/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.transform.VoiceMessageMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VoiceMessage
implements Serializable,
Cloneable,
StructuredPojo {
    private String body;
    private String languageCode;
    private String originationNumber;
    private Map<String, List<String>> substitutions;
    private String voiceId;

    public void setBody(String body) {
        this.body = body;
    }

    public String getBody() {
        return this.body;
    }

    public VoiceMessage withBody(String body) {
        this.setBody(body);
        return this;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public VoiceMessage withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public void setOriginationNumber(String originationNumber) {
        this.originationNumber = originationNumber;
    }

    public String getOriginationNumber() {
        return this.originationNumber;
    }

    public VoiceMessage withOriginationNumber(String originationNumber) {
        this.setOriginationNumber(originationNumber);
        return this;
    }

    public Map<String, List<String>> getSubstitutions() {
        return this.substitutions;
    }

    public void setSubstitutions(Map<String, List<String>> substitutions) {
        this.substitutions = substitutions;
    }

    public VoiceMessage withSubstitutions(Map<String, List<String>> substitutions) {
        this.setSubstitutions(substitutions);
        return this;
    }

    public VoiceMessage addSubstitutionsEntry(String key, List<String> value) {
        if (null == this.substitutions) {
            this.substitutions = new HashMap<String, List<String>>();
        }
        if (this.substitutions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.substitutions.put(key, value);
        return this;
    }

    public VoiceMessage clearSubstitutionsEntries() {
        this.substitutions = null;
        return this;
    }

    public void setVoiceId(String voiceId) {
        this.voiceId = voiceId;
    }

    public String getVoiceId() {
        return this.voiceId;
    }

    public VoiceMessage withVoiceId(String voiceId) {
        this.setVoiceId(voiceId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBody() != null) {
            sb.append("Body: ").append(this.getBody()).append(",");
        }
        if (this.getLanguageCode() != null) {
            sb.append("LanguageCode: ").append(this.getLanguageCode()).append(",");
        }
        if (this.getOriginationNumber() != null) {
            sb.append("OriginationNumber: ").append(this.getOriginationNumber()).append(",");
        }
        if (this.getSubstitutions() != null) {
            sb.append("Substitutions: ").append(this.getSubstitutions()).append(",");
        }
        if (this.getVoiceId() != null) {
            sb.append("VoiceId: ").append(this.getVoiceId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceMessage)) {
            return false;
        }
        VoiceMessage other = (VoiceMessage)obj;
        if (other.getBody() == null ^ this.getBody() == null) {
            return false;
        }
        if (other.getBody() != null && !other.getBody().equals(this.getBody())) {
            return false;
        }
        if (other.getLanguageCode() == null ^ this.getLanguageCode() == null) {
            return false;
        }
        if (other.getLanguageCode() != null && !other.getLanguageCode().equals(this.getLanguageCode())) {
            return false;
        }
        if (other.getOriginationNumber() == null ^ this.getOriginationNumber() == null) {
            return false;
        }
        if (other.getOriginationNumber() != null && !other.getOriginationNumber().equals(this.getOriginationNumber())) {
            return false;
        }
        if (other.getSubstitutions() == null ^ this.getSubstitutions() == null) {
            return false;
        }
        if (other.getSubstitutions() != null && !other.getSubstitutions().equals(this.getSubstitutions())) {
            return false;
        }
        if (other.getVoiceId() == null ^ this.getVoiceId() == null) {
            return false;
        }
        return other.getVoiceId() == null || other.getVoiceId().equals(this.getVoiceId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBody() == null ? 0 : this.getBody().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageCode() == null ? 0 : this.getLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getOriginationNumber() == null ? 0 : this.getOriginationNumber().hashCode());
        hashCode = 31 * hashCode + (this.getSubstitutions() == null ? 0 : this.getSubstitutions().hashCode());
        hashCode = 31 * hashCode + (this.getVoiceId() == null ? 0 : this.getVoiceId().hashCode());
        return hashCode;
    }

    public VoiceMessage clone() {
        try {
            return (VoiceMessage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VoiceMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

