/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.UpdateSegmentRequest;
import com.amazonaws.services.pinpoint.model.WriteSegmentRequest;
import com.amazonaws.services.pinpoint.model.transform.SegmentDimensionsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UpdateSegmentRequestMarshaller
implements Marshaller<Request<UpdateSegmentRequest>, UpdateSegmentRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateSegmentRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateSegmentRequest> marshall(UpdateSegmentRequest updateSegmentRequest) {
        if (updateSegmentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateSegmentRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/v1/apps/{application-id}/segments/{segment-id}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "application-id", updateSegmentRequest.getApplicationId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "segment-id", updateSegmentRequest.getSegmentId());
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            WriteSegmentRequest writeSegmentRequest = updateSegmentRequest.getWriteSegmentRequest();
            if (writeSegmentRequest != null) {
                jsonGenerator.writeStartObject();
                if (writeSegmentRequest.getDimensions() != null) {
                    jsonGenerator.writeFieldName("Dimensions");
                    SegmentDimensionsJsonMarshaller.getInstance().marshall(writeSegmentRequest.getDimensions(), jsonGenerator);
                }
                if (writeSegmentRequest.getName() != null) {
                    jsonGenerator.writeFieldName("Name").writeValue(writeSegmentRequest.getName());
                }
                jsonGenerator.writeEndObject();
            }
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

