/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.pinpoint.AmazonPinpointAsync;
import com.amazonaws.services.pinpoint.AmazonPinpointClient;
import com.amazonaws.services.pinpoint.model.CreateCampaignRequest;
import com.amazonaws.services.pinpoint.model.CreateCampaignResult;
import com.amazonaws.services.pinpoint.model.CreateImportJobRequest;
import com.amazonaws.services.pinpoint.model.CreateImportJobResult;
import com.amazonaws.services.pinpoint.model.CreateSegmentRequest;
import com.amazonaws.services.pinpoint.model.CreateSegmentResult;
import com.amazonaws.services.pinpoint.model.DeleteApnsChannelRequest;
import com.amazonaws.services.pinpoint.model.DeleteApnsChannelResult;
import com.amazonaws.services.pinpoint.model.DeleteCampaignRequest;
import com.amazonaws.services.pinpoint.model.DeleteCampaignResult;
import com.amazonaws.services.pinpoint.model.DeleteGcmChannelRequest;
import com.amazonaws.services.pinpoint.model.DeleteGcmChannelResult;
import com.amazonaws.services.pinpoint.model.DeleteSegmentRequest;
import com.amazonaws.services.pinpoint.model.DeleteSegmentResult;
import com.amazonaws.services.pinpoint.model.GetApnsChannelRequest;
import com.amazonaws.services.pinpoint.model.GetApnsChannelResult;
import com.amazonaws.services.pinpoint.model.GetApplicationSettingsRequest;
import com.amazonaws.services.pinpoint.model.GetApplicationSettingsResult;
import com.amazonaws.services.pinpoint.model.GetCampaignActivitiesRequest;
import com.amazonaws.services.pinpoint.model.GetCampaignActivitiesResult;
import com.amazonaws.services.pinpoint.model.GetCampaignRequest;
import com.amazonaws.services.pinpoint.model.GetCampaignResult;
import com.amazonaws.services.pinpoint.model.GetCampaignVersionRequest;
import com.amazonaws.services.pinpoint.model.GetCampaignVersionResult;
import com.amazonaws.services.pinpoint.model.GetCampaignVersionsRequest;
import com.amazonaws.services.pinpoint.model.GetCampaignVersionsResult;
import com.amazonaws.services.pinpoint.model.GetCampaignsRequest;
import com.amazonaws.services.pinpoint.model.GetCampaignsResult;
import com.amazonaws.services.pinpoint.model.GetEndpointRequest;
import com.amazonaws.services.pinpoint.model.GetEndpointResult;
import com.amazonaws.services.pinpoint.model.GetGcmChannelRequest;
import com.amazonaws.services.pinpoint.model.GetGcmChannelResult;
import com.amazonaws.services.pinpoint.model.GetImportJobRequest;
import com.amazonaws.services.pinpoint.model.GetImportJobResult;
import com.amazonaws.services.pinpoint.model.GetImportJobsRequest;
import com.amazonaws.services.pinpoint.model.GetImportJobsResult;
import com.amazonaws.services.pinpoint.model.GetSegmentImportJobsRequest;
import com.amazonaws.services.pinpoint.model.GetSegmentImportJobsResult;
import com.amazonaws.services.pinpoint.model.GetSegmentRequest;
import com.amazonaws.services.pinpoint.model.GetSegmentResult;
import com.amazonaws.services.pinpoint.model.GetSegmentVersionRequest;
import com.amazonaws.services.pinpoint.model.GetSegmentVersionResult;
import com.amazonaws.services.pinpoint.model.GetSegmentVersionsRequest;
import com.amazonaws.services.pinpoint.model.GetSegmentVersionsResult;
import com.amazonaws.services.pinpoint.model.GetSegmentsRequest;
import com.amazonaws.services.pinpoint.model.GetSegmentsResult;
import com.amazonaws.services.pinpoint.model.UpdateApnsChannelRequest;
import com.amazonaws.services.pinpoint.model.UpdateApnsChannelResult;
import com.amazonaws.services.pinpoint.model.UpdateApplicationSettingsRequest;
import com.amazonaws.services.pinpoint.model.UpdateApplicationSettingsResult;
import com.amazonaws.services.pinpoint.model.UpdateCampaignRequest;
import com.amazonaws.services.pinpoint.model.UpdateCampaignResult;
import com.amazonaws.services.pinpoint.model.UpdateEndpointRequest;
import com.amazonaws.services.pinpoint.model.UpdateEndpointResult;
import com.amazonaws.services.pinpoint.model.UpdateEndpointsBatchRequest;
import com.amazonaws.services.pinpoint.model.UpdateEndpointsBatchResult;
import com.amazonaws.services.pinpoint.model.UpdateGcmChannelRequest;
import com.amazonaws.services.pinpoint.model.UpdateGcmChannelResult;
import com.amazonaws.services.pinpoint.model.UpdateSegmentRequest;
import com.amazonaws.services.pinpoint.model.UpdateSegmentResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonPinpointAsyncClient
extends AmazonPinpointClient
implements AmazonPinpointAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonPinpointAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    public AmazonPinpointAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonPinpointAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonPinpointAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AmazonPinpointAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonPinpointAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonPinpointAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonPinpointAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AmazonPinpointAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AmazonPinpointAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateCampaignResult> createCampaignAsync(CreateCampaignRequest request) {
        return this.createCampaignAsync(request, null);
    }

    @Override
    public Future<CreateCampaignResult> createCampaignAsync(final CreateCampaignRequest request, final AsyncHandler<CreateCampaignRequest, CreateCampaignResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateCampaignResult>(){

            @Override
            public CreateCampaignResult call() throws Exception {
                CreateCampaignResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.createCampaign(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateImportJobResult> createImportJobAsync(CreateImportJobRequest request) {
        return this.createImportJobAsync(request, null);
    }

    @Override
    public Future<CreateImportJobResult> createImportJobAsync(final CreateImportJobRequest request, final AsyncHandler<CreateImportJobRequest, CreateImportJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateImportJobResult>(){

            @Override
            public CreateImportJobResult call() throws Exception {
                CreateImportJobResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.createImportJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSegmentResult> createSegmentAsync(CreateSegmentRequest request) {
        return this.createSegmentAsync(request, null);
    }

    @Override
    public Future<CreateSegmentResult> createSegmentAsync(final CreateSegmentRequest request, final AsyncHandler<CreateSegmentRequest, CreateSegmentResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateSegmentResult>(){

            @Override
            public CreateSegmentResult call() throws Exception {
                CreateSegmentResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.createSegment(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteApnsChannelResult> deleteApnsChannelAsync(DeleteApnsChannelRequest request) {
        return this.deleteApnsChannelAsync(request, null);
    }

    @Override
    public Future<DeleteApnsChannelResult> deleteApnsChannelAsync(final DeleteApnsChannelRequest request, final AsyncHandler<DeleteApnsChannelRequest, DeleteApnsChannelResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteApnsChannelResult>(){

            @Override
            public DeleteApnsChannelResult call() throws Exception {
                DeleteApnsChannelResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.deleteApnsChannel(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCampaignResult> deleteCampaignAsync(DeleteCampaignRequest request) {
        return this.deleteCampaignAsync(request, null);
    }

    @Override
    public Future<DeleteCampaignResult> deleteCampaignAsync(final DeleteCampaignRequest request, final AsyncHandler<DeleteCampaignRequest, DeleteCampaignResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteCampaignResult>(){

            @Override
            public DeleteCampaignResult call() throws Exception {
                DeleteCampaignResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.deleteCampaign(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteGcmChannelResult> deleteGcmChannelAsync(DeleteGcmChannelRequest request) {
        return this.deleteGcmChannelAsync(request, null);
    }

    @Override
    public Future<DeleteGcmChannelResult> deleteGcmChannelAsync(final DeleteGcmChannelRequest request, final AsyncHandler<DeleteGcmChannelRequest, DeleteGcmChannelResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteGcmChannelResult>(){

            @Override
            public DeleteGcmChannelResult call() throws Exception {
                DeleteGcmChannelResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.deleteGcmChannel(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSegmentResult> deleteSegmentAsync(DeleteSegmentRequest request) {
        return this.deleteSegmentAsync(request, null);
    }

    @Override
    public Future<DeleteSegmentResult> deleteSegmentAsync(final DeleteSegmentRequest request, final AsyncHandler<DeleteSegmentRequest, DeleteSegmentResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteSegmentResult>(){

            @Override
            public DeleteSegmentResult call() throws Exception {
                DeleteSegmentResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.deleteSegment(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetApnsChannelResult> getApnsChannelAsync(GetApnsChannelRequest request) {
        return this.getApnsChannelAsync(request, null);
    }

    @Override
    public Future<GetApnsChannelResult> getApnsChannelAsync(final GetApnsChannelRequest request, final AsyncHandler<GetApnsChannelRequest, GetApnsChannelResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetApnsChannelResult>(){

            @Override
            public GetApnsChannelResult call() throws Exception {
                GetApnsChannelResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.getApnsChannel(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetApplicationSettingsResult> getApplicationSettingsAsync(GetApplicationSettingsRequest request) {
        return this.getApplicationSettingsAsync(request, null);
    }

    @Override
    public Future<GetApplicationSettingsResult> getApplicationSettingsAsync(final GetApplicationSettingsRequest request, final AsyncHandler<GetApplicationSettingsRequest, GetApplicationSettingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetApplicationSettingsResult>(){

            @Override
            public GetApplicationSettingsResult call() throws Exception {
                GetApplicationSettingsResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.getApplicationSettings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCampaignResult> getCampaignAsync(GetCampaignRequest request) {
        return this.getCampaignAsync(request, null);
    }

    @Override
    public Future<GetCampaignResult> getCampaignAsync(final GetCampaignRequest request, final AsyncHandler<GetCampaignRequest, GetCampaignResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetCampaignResult>(){

            @Override
            public GetCampaignResult call() throws Exception {
                GetCampaignResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.getCampaign(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCampaignActivitiesResult> getCampaignActivitiesAsync(GetCampaignActivitiesRequest request) {
        return this.getCampaignActivitiesAsync(request, null);
    }

    @Override
    public Future<GetCampaignActivitiesResult> getCampaignActivitiesAsync(final GetCampaignActivitiesRequest request, final AsyncHandler<GetCampaignActivitiesRequest, GetCampaignActivitiesResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetCampaignActivitiesResult>(){

            @Override
            public GetCampaignActivitiesResult call() throws Exception {
                GetCampaignActivitiesResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.getCampaignActivities(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCampaignVersionResult> getCampaignVersionAsync(GetCampaignVersionRequest request) {
        return this.getCampaignVersionAsync(request, null);
    }

    @Override
    public Future<GetCampaignVersionResult> getCampaignVersionAsync(final GetCampaignVersionRequest request, final AsyncHandler<GetCampaignVersionRequest, GetCampaignVersionResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetCampaignVersionResult>(){

            @Override
            public GetCampaignVersionResult call() throws Exception {
                GetCampaignVersionResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.getCampaignVersion(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCampaignVersionsResult> getCampaignVersionsAsync(GetCampaignVersionsRequest request) {
        return this.getCampaignVersionsAsync(request, null);
    }

    @Override
    public Future<GetCampaignVersionsResult> getCampaignVersionsAsync(final GetCampaignVersionsRequest request, final AsyncHandler<GetCampaignVersionsRequest, GetCampaignVersionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetCampaignVersionsResult>(){

            @Override
            public GetCampaignVersionsResult call() throws Exception {
                GetCampaignVersionsResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.getCampaignVersions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCampaignsResult> getCampaignsAsync(GetCampaignsRequest request) {
        return this.getCampaignsAsync(request, null);
    }

    @Override
    public Future<GetCampaignsResult> getCampaignsAsync(final GetCampaignsRequest request, final AsyncHandler<GetCampaignsRequest, GetCampaignsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetCampaignsResult>(){

            @Override
            public GetCampaignsResult call() throws Exception {
                GetCampaignsResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.getCampaigns(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEndpointResult> getEndpointAsync(GetEndpointRequest request) {
        return this.getEndpointAsync(request, null);
    }

    @Override
    public Future<GetEndpointResult> getEndpointAsync(final GetEndpointRequest request, final AsyncHandler<GetEndpointRequest, GetEndpointResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetEndpointResult>(){

            @Override
            public GetEndpointResult call() throws Exception {
                GetEndpointResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.getEndpoint(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetGcmChannelResult> getGcmChannelAsync(GetGcmChannelRequest request) {
        return this.getGcmChannelAsync(request, null);
    }

    @Override
    public Future<GetGcmChannelResult> getGcmChannelAsync(final GetGcmChannelRequest request, final AsyncHandler<GetGcmChannelRequest, GetGcmChannelResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetGcmChannelResult>(){

            @Override
            public GetGcmChannelResult call() throws Exception {
                GetGcmChannelResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.getGcmChannel(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetImportJobResult> getImportJobAsync(GetImportJobRequest request) {
        return this.getImportJobAsync(request, null);
    }

    @Override
    public Future<GetImportJobResult> getImportJobAsync(final GetImportJobRequest request, final AsyncHandler<GetImportJobRequest, GetImportJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetImportJobResult>(){

            @Override
            public GetImportJobResult call() throws Exception {
                GetImportJobResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.getImportJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetImportJobsResult> getImportJobsAsync(GetImportJobsRequest request) {
        return this.getImportJobsAsync(request, null);
    }

    @Override
    public Future<GetImportJobsResult> getImportJobsAsync(final GetImportJobsRequest request, final AsyncHandler<GetImportJobsRequest, GetImportJobsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetImportJobsResult>(){

            @Override
            public GetImportJobsResult call() throws Exception {
                GetImportJobsResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.getImportJobs(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSegmentResult> getSegmentAsync(GetSegmentRequest request) {
        return this.getSegmentAsync(request, null);
    }

    @Override
    public Future<GetSegmentResult> getSegmentAsync(final GetSegmentRequest request, final AsyncHandler<GetSegmentRequest, GetSegmentResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetSegmentResult>(){

            @Override
            public GetSegmentResult call() throws Exception {
                GetSegmentResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.getSegment(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSegmentImportJobsResult> getSegmentImportJobsAsync(GetSegmentImportJobsRequest request) {
        return this.getSegmentImportJobsAsync(request, null);
    }

    @Override
    public Future<GetSegmentImportJobsResult> getSegmentImportJobsAsync(final GetSegmentImportJobsRequest request, final AsyncHandler<GetSegmentImportJobsRequest, GetSegmentImportJobsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetSegmentImportJobsResult>(){

            @Override
            public GetSegmentImportJobsResult call() throws Exception {
                GetSegmentImportJobsResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.getSegmentImportJobs(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSegmentVersionResult> getSegmentVersionAsync(GetSegmentVersionRequest request) {
        return this.getSegmentVersionAsync(request, null);
    }

    @Override
    public Future<GetSegmentVersionResult> getSegmentVersionAsync(final GetSegmentVersionRequest request, final AsyncHandler<GetSegmentVersionRequest, GetSegmentVersionResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetSegmentVersionResult>(){

            @Override
            public GetSegmentVersionResult call() throws Exception {
                GetSegmentVersionResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.getSegmentVersion(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSegmentVersionsResult> getSegmentVersionsAsync(GetSegmentVersionsRequest request) {
        return this.getSegmentVersionsAsync(request, null);
    }

    @Override
    public Future<GetSegmentVersionsResult> getSegmentVersionsAsync(final GetSegmentVersionsRequest request, final AsyncHandler<GetSegmentVersionsRequest, GetSegmentVersionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetSegmentVersionsResult>(){

            @Override
            public GetSegmentVersionsResult call() throws Exception {
                GetSegmentVersionsResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.getSegmentVersions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSegmentsResult> getSegmentsAsync(GetSegmentsRequest request) {
        return this.getSegmentsAsync(request, null);
    }

    @Override
    public Future<GetSegmentsResult> getSegmentsAsync(final GetSegmentsRequest request, final AsyncHandler<GetSegmentsRequest, GetSegmentsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetSegmentsResult>(){

            @Override
            public GetSegmentsResult call() throws Exception {
                GetSegmentsResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.getSegments(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateApnsChannelResult> updateApnsChannelAsync(UpdateApnsChannelRequest request) {
        return this.updateApnsChannelAsync(request, null);
    }

    @Override
    public Future<UpdateApnsChannelResult> updateApnsChannelAsync(final UpdateApnsChannelRequest request, final AsyncHandler<UpdateApnsChannelRequest, UpdateApnsChannelResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateApnsChannelResult>(){

            @Override
            public UpdateApnsChannelResult call() throws Exception {
                UpdateApnsChannelResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.updateApnsChannel(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateApplicationSettingsResult> updateApplicationSettingsAsync(UpdateApplicationSettingsRequest request) {
        return this.updateApplicationSettingsAsync(request, null);
    }

    @Override
    public Future<UpdateApplicationSettingsResult> updateApplicationSettingsAsync(final UpdateApplicationSettingsRequest request, final AsyncHandler<UpdateApplicationSettingsRequest, UpdateApplicationSettingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateApplicationSettingsResult>(){

            @Override
            public UpdateApplicationSettingsResult call() throws Exception {
                UpdateApplicationSettingsResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.updateApplicationSettings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateCampaignResult> updateCampaignAsync(UpdateCampaignRequest request) {
        return this.updateCampaignAsync(request, null);
    }

    @Override
    public Future<UpdateCampaignResult> updateCampaignAsync(final UpdateCampaignRequest request, final AsyncHandler<UpdateCampaignRequest, UpdateCampaignResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateCampaignResult>(){

            @Override
            public UpdateCampaignResult call() throws Exception {
                UpdateCampaignResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.updateCampaign(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateEndpointResult> updateEndpointAsync(UpdateEndpointRequest request) {
        return this.updateEndpointAsync(request, null);
    }

    @Override
    public Future<UpdateEndpointResult> updateEndpointAsync(final UpdateEndpointRequest request, final AsyncHandler<UpdateEndpointRequest, UpdateEndpointResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateEndpointResult>(){

            @Override
            public UpdateEndpointResult call() throws Exception {
                UpdateEndpointResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.updateEndpoint(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateEndpointsBatchResult> updateEndpointsBatchAsync(UpdateEndpointsBatchRequest request) {
        return this.updateEndpointsBatchAsync(request, null);
    }

    @Override
    public Future<UpdateEndpointsBatchResult> updateEndpointsBatchAsync(final UpdateEndpointsBatchRequest request, final AsyncHandler<UpdateEndpointsBatchRequest, UpdateEndpointsBatchResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateEndpointsBatchResult>(){

            @Override
            public UpdateEndpointsBatchResult call() throws Exception {
                UpdateEndpointsBatchResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.updateEndpointsBatch(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateGcmChannelResult> updateGcmChannelAsync(UpdateGcmChannelRequest request) {
        return this.updateGcmChannelAsync(request, null);
    }

    @Override
    public Future<UpdateGcmChannelResult> updateGcmChannelAsync(final UpdateGcmChannelRequest request, final AsyncHandler<UpdateGcmChannelRequest, UpdateGcmChannelResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateGcmChannelResult>(){

            @Override
            public UpdateGcmChannelResult call() throws Exception {
                UpdateGcmChannelResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.updateGcmChannel(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSegmentResult> updateSegmentAsync(UpdateSegmentRequest request) {
        return this.updateSegmentAsync(request, null);
    }

    @Override
    public Future<UpdateSegmentResult> updateSegmentAsync(final UpdateSegmentRequest request, final AsyncHandler<UpdateSegmentRequest, UpdateSegmentResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateSegmentResult>(){

            @Override
            public UpdateSegmentResult call() throws Exception {
                UpdateSegmentResult result;
                try {
                    result = AmazonPinpointAsyncClient.this.updateSegment(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

