/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.ApplicationSettingsResource;
import com.amazonaws.services.pinpoint.model.transform.CampaignLimitsJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.QuietTimeJsonMarshaller;

public class ApplicationSettingsResourceJsonMarshaller {
    private static ApplicationSettingsResourceJsonMarshaller instance;

    public void marshall(ApplicationSettingsResource applicationSettingsResource, StructuredJsonGenerator jsonGenerator) {
        if (applicationSettingsResource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (applicationSettingsResource.getApplicationId() != null) {
                jsonGenerator.writeFieldName("ApplicationId").writeValue(applicationSettingsResource.getApplicationId());
            }
            if (applicationSettingsResource.getLastModifiedDate() != null) {
                jsonGenerator.writeFieldName("LastModifiedDate").writeValue(applicationSettingsResource.getLastModifiedDate());
            }
            if (applicationSettingsResource.getLimits() != null) {
                jsonGenerator.writeFieldName("Limits");
                CampaignLimitsJsonMarshaller.getInstance().marshall(applicationSettingsResource.getLimits(), jsonGenerator);
            }
            if (applicationSettingsResource.getQuietTime() != null) {
                jsonGenerator.writeFieldName("QuietTime");
                QuietTimeJsonMarshaller.getInstance().marshall(applicationSettingsResource.getQuietTime(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ApplicationSettingsResourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ApplicationSettingsResourceJsonMarshaller();
        }
        return instance;
    }
}

