/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.pinpoint.model.GetSegmentImportJobsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetSegmentImportJobsRequestMarshaller
implements Marshaller<Request<GetSegmentImportJobsRequest>, GetSegmentImportJobsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetSegmentImportJobsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetSegmentImportJobsRequest> marshall(GetSegmentImportJobsRequest getSegmentImportJobsRequest) {
        if (getSegmentImportJobsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getSegmentImportJobsRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/v1/apps/{application-id}/segments/{segment-id}/jobs/import";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "application-id", getSegmentImportJobsRequest.getApplicationId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "segment-id", getSegmentImportJobsRequest.getSegmentId());
        request.setResourcePath(uriResourcePath);
        if (getSegmentImportJobsRequest.getPageSize() != null) {
            request.addParameter("page-size", StringUtils.fromString((String)getSegmentImportJobsRequest.getPageSize()));
        }
        if (getSegmentImportJobsRequest.getToken() != null) {
            request.addParameter("token", StringUtils.fromString((String)getSegmentImportJobsRequest.getToken()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

