/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.CreateImportJobRequest;
import com.amazonaws.services.pinpoint.model.ImportJobRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateImportJobRequestMarshaller
implements Marshaller<Request<CreateImportJobRequest>, CreateImportJobRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateImportJobRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateImportJobRequest> marshall(CreateImportJobRequest createImportJobRequest) {
        if (createImportJobRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createImportJobRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/v1/apps/{application-id}/jobs/import";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "application-id", createImportJobRequest.getApplicationId());
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            ImportJobRequest importJobRequest = createImportJobRequest.getImportJobRequest();
            if (importJobRequest != null) {
                jsonGenerator.writeStartObject();
                if (importJobRequest.getDefineSegment() != null) {
                    jsonGenerator.writeFieldName("DefineSegment").writeValue(importJobRequest.getDefineSegment().booleanValue());
                }
                if (importJobRequest.getExternalId() != null) {
                    jsonGenerator.writeFieldName("ExternalId").writeValue(importJobRequest.getExternalId());
                }
                if (importJobRequest.getFormat() != null) {
                    jsonGenerator.writeFieldName("Format").writeValue(importJobRequest.getFormat());
                }
                if (importJobRequest.getRegisterEndpoints() != null) {
                    jsonGenerator.writeFieldName("RegisterEndpoints").writeValue(importJobRequest.getRegisterEndpoints().booleanValue());
                }
                if (importJobRequest.getRoleArn() != null) {
                    jsonGenerator.writeFieldName("RoleArn").writeValue(importJobRequest.getRoleArn());
                }
                if (importJobRequest.getS3Url() != null) {
                    jsonGenerator.writeFieldName("S3Url").writeValue(importJobRequest.getS3Url());
                }
                if (importJobRequest.getSegmentId() != null) {
                    jsonGenerator.writeFieldName("SegmentId").writeValue(importJobRequest.getSegmentId());
                }
                if (importJobRequest.getSegmentName() != null) {
                    jsonGenerator.writeFieldName("SegmentName").writeValue(importJobRequest.getSegmentName());
                }
                jsonGenerator.writeEndObject();
            }
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

