/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.pinpoint.model.GetCampaignVersionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetCampaignVersionsRequestMarshaller
implements Marshaller<Request<GetCampaignVersionsRequest>, GetCampaignVersionsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetCampaignVersionsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetCampaignVersionsRequest> marshall(GetCampaignVersionsRequest getCampaignVersionsRequest) {
        if (getCampaignVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getCampaignVersionsRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/v1/apps/{application-id}/campaigns/{campaign-id}/versions";
        uriResourcePath = uriResourcePath.replace("{application-id}", getCampaignVersionsRequest.getApplicationId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getCampaignVersionsRequest.getApplicationId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{campaign-id}", getCampaignVersionsRequest.getCampaignId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getCampaignVersionsRequest.getCampaignId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        if (getCampaignVersionsRequest.getPageSize() != null) {
            request.addParameter("page-size", StringUtils.fromString((String)getCampaignVersionsRequest.getPageSize()));
        }
        if (getCampaignVersionsRequest.getToken() != null) {
            request.addParameter("token", StringUtils.fromString((String)getCampaignVersionsRequest.getToken()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

