/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.EndpointResponse;
import com.amazonaws.services.pinpoint.model.transform.EndpointDemographicJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.EndpointLocationJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.EndpointUserJsonMarshaller;
import java.util.List;
import java.util.Map;

public class EndpointResponseJsonMarshaller {
    private static EndpointResponseJsonMarshaller instance;

    public void marshall(EndpointResponse endpointResponse, StructuredJsonGenerator jsonGenerator) {
        if (endpointResponse == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, Double> metricsMap;
            Map<String, List<String>> attributesMap;
            jsonGenerator.writeStartObject();
            if (endpointResponse.getAddress() != null) {
                jsonGenerator.writeFieldName("Address").writeValue(endpointResponse.getAddress());
            }
            if (endpointResponse.getApplicationId() != null) {
                jsonGenerator.writeFieldName("ApplicationId").writeValue(endpointResponse.getApplicationId());
            }
            if ((attributesMap = endpointResponse.getAttributes()) != null) {
                jsonGenerator.writeFieldName("Attributes");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, List<String>> attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(attributesMapValue.getKey());
                    jsonGenerator.writeStartArray();
                    for (String attributesMapValueList : attributesMapValue.getValue()) {
                        if (attributesMapValueList == null) continue;
                        jsonGenerator.writeValue(attributesMapValueList);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndObject();
            }
            if (endpointResponse.getChannelType() != null) {
                jsonGenerator.writeFieldName("ChannelType").writeValue(endpointResponse.getChannelType());
            }
            if (endpointResponse.getCohortId() != null) {
                jsonGenerator.writeFieldName("CohortId").writeValue(endpointResponse.getCohortId());
            }
            if (endpointResponse.getCreationDate() != null) {
                jsonGenerator.writeFieldName("CreationDate").writeValue(endpointResponse.getCreationDate());
            }
            if (endpointResponse.getDemographic() != null) {
                jsonGenerator.writeFieldName("Demographic");
                EndpointDemographicJsonMarshaller.getInstance().marshall(endpointResponse.getDemographic(), jsonGenerator);
            }
            if (endpointResponse.getEffectiveDate() != null) {
                jsonGenerator.writeFieldName("EffectiveDate").writeValue(endpointResponse.getEffectiveDate());
            }
            if (endpointResponse.getEndpointStatus() != null) {
                jsonGenerator.writeFieldName("EndpointStatus").writeValue(endpointResponse.getEndpointStatus());
            }
            if (endpointResponse.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(endpointResponse.getId());
            }
            if (endpointResponse.getLocation() != null) {
                jsonGenerator.writeFieldName("Location");
                EndpointLocationJsonMarshaller.getInstance().marshall(endpointResponse.getLocation(), jsonGenerator);
            }
            if ((metricsMap = endpointResponse.getMetrics()) != null) {
                jsonGenerator.writeFieldName("Metrics");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, Double> metricsMapValue : metricsMap.entrySet()) {
                    if (metricsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(metricsMapValue.getKey());
                    jsonGenerator.writeValue(metricsMapValue.getValue().doubleValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (endpointResponse.getOptOut() != null) {
                jsonGenerator.writeFieldName("OptOut").writeValue(endpointResponse.getOptOut());
            }
            if (endpointResponse.getRequestId() != null) {
                jsonGenerator.writeFieldName("RequestId").writeValue(endpointResponse.getRequestId());
            }
            if (endpointResponse.getShardId() != null) {
                jsonGenerator.writeFieldName("ShardId").writeValue(endpointResponse.getShardId());
            }
            if (endpointResponse.getUser() != null) {
                jsonGenerator.writeFieldName("User");
                EndpointUserJsonMarshaller.getInstance().marshall(endpointResponse.getUser(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EndpointResponseJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EndpointResponseJsonMarshaller();
        }
        return instance;
    }
}

