/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.CreateSegmentRequest;
import com.amazonaws.services.pinpoint.model.WriteSegmentRequest;
import com.amazonaws.services.pinpoint.model.transform.SegmentDimensionsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateSegmentRequestMarshaller
implements Marshaller<Request<CreateSegmentRequest>, CreateSegmentRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateSegmentRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateSegmentRequest> marshall(CreateSegmentRequest createSegmentRequest) {
        if (createSegmentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createSegmentRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/v1/apps/{application-id}/segments";
        uriResourcePath = uriResourcePath.replace("{application-id}", createSegmentRequest.getApplicationId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)createSegmentRequest.getApplicationId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            WriteSegmentRequest writeSegmentRequest = createSegmentRequest.getWriteSegmentRequest();
            if (writeSegmentRequest != null) {
                jsonGenerator.writeStartObject();
                if (writeSegmentRequest.getDimensions() != null) {
                    jsonGenerator.writeFieldName("Dimensions");
                    SegmentDimensionsJsonMarshaller.getInstance().marshall(writeSegmentRequest.getDimensions(), jsonGenerator);
                }
                if (writeSegmentRequest.getName() != null) {
                    jsonGenerator.writeFieldName("Name").writeValue(writeSegmentRequest.getName());
                }
                jsonGenerator.writeEndObject();
            }
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

