/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pinpoint.model.ADMMessage;
import java.util.Map;

@SdkInternalApi
public class ADMMessageMarshaller {
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").build();
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Body").build();
    private static final MarshallingInfo<String> CONSOLIDATIONKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsolidationKey").build();
    private static final MarshallingInfo<Map> DATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Data").build();
    private static final MarshallingInfo<String> EXPIRESAFTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpiresAfter").build();
    private static final MarshallingInfo<String> ICONREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IconReference").build();
    private static final MarshallingInfo<String> IMAGEICONURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageIconUrl").build();
    private static final MarshallingInfo<String> IMAGEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageUrl").build();
    private static final MarshallingInfo<String> JSONDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JsonData").build();
    private static final MarshallingInfo<String> MD5_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MD5").build();
    private static final MarshallingInfo<String> RAWCONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RawContent").build();
    private static final MarshallingInfo<Boolean> SILENTPUSH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SilentPush").build();
    private static final MarshallingInfo<String> SMALLIMAGEICONURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SmallImageIconUrl").build();
    private static final MarshallingInfo<String> SOUND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sound").build();
    private static final MarshallingInfo<Map> SUBSTITUTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Substitutions").build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Url").build();
    private static final ADMMessageMarshaller instance = new ADMMessageMarshaller();

    public static ADMMessageMarshaller getInstance() {
        return instance;
    }

    public void marshall(ADMMessage aDMMessage, ProtocolMarshaller protocolMarshaller) {
        if (aDMMessage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)aDMMessage.getAction(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)aDMMessage.getBody(), BODY_BINDING);
            protocolMarshaller.marshall((Object)aDMMessage.getConsolidationKey(), CONSOLIDATIONKEY_BINDING);
            protocolMarshaller.marshall(aDMMessage.getData(), DATA_BINDING);
            protocolMarshaller.marshall((Object)aDMMessage.getExpiresAfter(), EXPIRESAFTER_BINDING);
            protocolMarshaller.marshall((Object)aDMMessage.getIconReference(), ICONREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)aDMMessage.getImageIconUrl(), IMAGEICONURL_BINDING);
            protocolMarshaller.marshall((Object)aDMMessage.getImageUrl(), IMAGEURL_BINDING);
            protocolMarshaller.marshall((Object)aDMMessage.getJsonData(), JSONDATA_BINDING);
            protocolMarshaller.marshall((Object)aDMMessage.getMD5(), MD5_BINDING);
            protocolMarshaller.marshall((Object)aDMMessage.getRawContent(), RAWCONTENT_BINDING);
            protocolMarshaller.marshall((Object)aDMMessage.getSilentPush(), SILENTPUSH_BINDING);
            protocolMarshaller.marshall((Object)aDMMessage.getSmallImageIconUrl(), SMALLIMAGEICONURL_BINDING);
            protocolMarshaller.marshall((Object)aDMMessage.getSound(), SOUND_BINDING);
            protocolMarshaller.marshall(aDMMessage.getSubstitutions(), SUBSTITUTIONS_BINDING);
            protocolMarshaller.marshall((Object)aDMMessage.getTitle(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)aDMMessage.getUrl(), URL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

