/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pi;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.pi.AWSPI;
import com.amazonaws.services.pi.AWSPIClientBuilder;
import com.amazonaws.services.pi.model.AWSPIException;
import com.amazonaws.services.pi.model.CreatePerformanceAnalysisReportRequest;
import com.amazonaws.services.pi.model.CreatePerformanceAnalysisReportResult;
import com.amazonaws.services.pi.model.DeletePerformanceAnalysisReportRequest;
import com.amazonaws.services.pi.model.DeletePerformanceAnalysisReportResult;
import com.amazonaws.services.pi.model.DescribeDimensionKeysRequest;
import com.amazonaws.services.pi.model.DescribeDimensionKeysResult;
import com.amazonaws.services.pi.model.GetDimensionKeyDetailsRequest;
import com.amazonaws.services.pi.model.GetDimensionKeyDetailsResult;
import com.amazonaws.services.pi.model.GetPerformanceAnalysisReportRequest;
import com.amazonaws.services.pi.model.GetPerformanceAnalysisReportResult;
import com.amazonaws.services.pi.model.GetResourceMetadataRequest;
import com.amazonaws.services.pi.model.GetResourceMetadataResult;
import com.amazonaws.services.pi.model.GetResourceMetricsRequest;
import com.amazonaws.services.pi.model.GetResourceMetricsResult;
import com.amazonaws.services.pi.model.ListAvailableResourceDimensionsRequest;
import com.amazonaws.services.pi.model.ListAvailableResourceDimensionsResult;
import com.amazonaws.services.pi.model.ListAvailableResourceMetricsRequest;
import com.amazonaws.services.pi.model.ListAvailableResourceMetricsResult;
import com.amazonaws.services.pi.model.ListPerformanceAnalysisReportsRequest;
import com.amazonaws.services.pi.model.ListPerformanceAnalysisReportsResult;
import com.amazonaws.services.pi.model.ListTagsForResourceRequest;
import com.amazonaws.services.pi.model.ListTagsForResourceResult;
import com.amazonaws.services.pi.model.TagResourceRequest;
import com.amazonaws.services.pi.model.TagResourceResult;
import com.amazonaws.services.pi.model.UntagResourceRequest;
import com.amazonaws.services.pi.model.UntagResourceResult;
import com.amazonaws.services.pi.model.transform.CreatePerformanceAnalysisReportRequestProtocolMarshaller;
import com.amazonaws.services.pi.model.transform.CreatePerformanceAnalysisReportResultJsonUnmarshaller;
import com.amazonaws.services.pi.model.transform.DeletePerformanceAnalysisReportRequestProtocolMarshaller;
import com.amazonaws.services.pi.model.transform.DeletePerformanceAnalysisReportResultJsonUnmarshaller;
import com.amazonaws.services.pi.model.transform.DescribeDimensionKeysRequestProtocolMarshaller;
import com.amazonaws.services.pi.model.transform.DescribeDimensionKeysResultJsonUnmarshaller;
import com.amazonaws.services.pi.model.transform.GetDimensionKeyDetailsRequestProtocolMarshaller;
import com.amazonaws.services.pi.model.transform.GetDimensionKeyDetailsResultJsonUnmarshaller;
import com.amazonaws.services.pi.model.transform.GetPerformanceAnalysisReportRequestProtocolMarshaller;
import com.amazonaws.services.pi.model.transform.GetPerformanceAnalysisReportResultJsonUnmarshaller;
import com.amazonaws.services.pi.model.transform.GetResourceMetadataRequestProtocolMarshaller;
import com.amazonaws.services.pi.model.transform.GetResourceMetadataResultJsonUnmarshaller;
import com.amazonaws.services.pi.model.transform.GetResourceMetricsRequestProtocolMarshaller;
import com.amazonaws.services.pi.model.transform.GetResourceMetricsResultJsonUnmarshaller;
import com.amazonaws.services.pi.model.transform.InternalServiceErrorExceptionUnmarshaller;
import com.amazonaws.services.pi.model.transform.InvalidArgumentExceptionUnmarshaller;
import com.amazonaws.services.pi.model.transform.ListAvailableResourceDimensionsRequestProtocolMarshaller;
import com.amazonaws.services.pi.model.transform.ListAvailableResourceDimensionsResultJsonUnmarshaller;
import com.amazonaws.services.pi.model.transform.ListAvailableResourceMetricsRequestProtocolMarshaller;
import com.amazonaws.services.pi.model.transform.ListAvailableResourceMetricsResultJsonUnmarshaller;
import com.amazonaws.services.pi.model.transform.ListPerformanceAnalysisReportsRequestProtocolMarshaller;
import com.amazonaws.services.pi.model.transform.ListPerformanceAnalysisReportsResultJsonUnmarshaller;
import com.amazonaws.services.pi.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.pi.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.pi.model.transform.NotAuthorizedExceptionUnmarshaller;
import com.amazonaws.services.pi.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.pi.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.pi.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.pi.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSPIClient
extends AmazonWebServiceClient
implements AWSPI {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSPI.class);
    private static final String DEFAULT_SIGNING_NAME = "pi";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidArgumentException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidArgumentExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotAuthorizedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotAuthorizedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServiceError").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServiceErrorExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSPIException.class));

    public static AWSPIClientBuilder builder() {
        return AWSPIClientBuilder.standard();
    }

    AWSPIClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSPIClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("pi.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/pi/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/pi/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreatePerformanceAnalysisReportResult createPerformanceAnalysisReport(CreatePerformanceAnalysisReportRequest request) {
        request = (CreatePerformanceAnalysisReportRequest)this.beforeClientExecution(request);
        return this.executeCreatePerformanceAnalysisReport(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreatePerformanceAnalysisReportResult executeCreatePerformanceAnalysisReport(CreatePerformanceAnalysisReportRequest createPerformanceAnalysisReportRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPerformanceAnalysisReportRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePerformanceAnalysisReportRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePerformanceAnalysisReportRequestProtocolMarshaller(protocolFactory).marshall((CreatePerformanceAnalysisReportRequest)super.beforeMarshalling((AmazonWebServiceRequest)createPerformanceAnalysisReportRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PI");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreatePerformanceAnalysisReport");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePerformanceAnalysisReportResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePerformanceAnalysisReportResult createPerformanceAnalysisReportResult = (CreatePerformanceAnalysisReportResult)response.getAwsResponse();
            return createPerformanceAnalysisReportResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePerformanceAnalysisReportResult deletePerformanceAnalysisReport(DeletePerformanceAnalysisReportRequest request) {
        request = (DeletePerformanceAnalysisReportRequest)this.beforeClientExecution(request);
        return this.executeDeletePerformanceAnalysisReport(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePerformanceAnalysisReportResult executeDeletePerformanceAnalysisReport(DeletePerformanceAnalysisReportRequest deletePerformanceAnalysisReportRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePerformanceAnalysisReportRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePerformanceAnalysisReportRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePerformanceAnalysisReportRequestProtocolMarshaller(protocolFactory).marshall((DeletePerformanceAnalysisReportRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePerformanceAnalysisReportRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PI");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeletePerformanceAnalysisReport");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePerformanceAnalysisReportResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeletePerformanceAnalysisReportResult deletePerformanceAnalysisReportResult = (DeletePerformanceAnalysisReportResult)response.getAwsResponse();
            return deletePerformanceAnalysisReportResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDimensionKeysResult describeDimensionKeys(DescribeDimensionKeysRequest request) {
        request = (DescribeDimensionKeysRequest)this.beforeClientExecution(request);
        return this.executeDescribeDimensionKeys(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDimensionKeysResult executeDescribeDimensionKeys(DescribeDimensionKeysRequest describeDimensionKeysRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDimensionKeysRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDimensionKeysRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDimensionKeysRequestProtocolMarshaller(protocolFactory).marshall((DescribeDimensionKeysRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDimensionKeysRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PI");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeDimensionKeys");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDimensionKeysResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDimensionKeysResult describeDimensionKeysResult = (DescribeDimensionKeysResult)response.getAwsResponse();
            return describeDimensionKeysResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDimensionKeyDetailsResult getDimensionKeyDetails(GetDimensionKeyDetailsRequest request) {
        request = (GetDimensionKeyDetailsRequest)this.beforeClientExecution(request);
        return this.executeGetDimensionKeyDetails(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDimensionKeyDetailsResult executeGetDimensionKeyDetails(GetDimensionKeyDetailsRequest getDimensionKeyDetailsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDimensionKeyDetailsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDimensionKeyDetailsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDimensionKeyDetailsRequestProtocolMarshaller(protocolFactory).marshall((GetDimensionKeyDetailsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDimensionKeyDetailsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PI");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDimensionKeyDetails");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDimensionKeyDetailsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDimensionKeyDetailsResult getDimensionKeyDetailsResult = (GetDimensionKeyDetailsResult)response.getAwsResponse();
            return getDimensionKeyDetailsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPerformanceAnalysisReportResult getPerformanceAnalysisReport(GetPerformanceAnalysisReportRequest request) {
        request = (GetPerformanceAnalysisReportRequest)this.beforeClientExecution(request);
        return this.executeGetPerformanceAnalysisReport(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPerformanceAnalysisReportResult executeGetPerformanceAnalysisReport(GetPerformanceAnalysisReportRequest getPerformanceAnalysisReportRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPerformanceAnalysisReportRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPerformanceAnalysisReportRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPerformanceAnalysisReportRequestProtocolMarshaller(protocolFactory).marshall((GetPerformanceAnalysisReportRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPerformanceAnalysisReportRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PI");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetPerformanceAnalysisReport");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPerformanceAnalysisReportResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPerformanceAnalysisReportResult getPerformanceAnalysisReportResult = (GetPerformanceAnalysisReportResult)response.getAwsResponse();
            return getPerformanceAnalysisReportResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetResourceMetadataResult getResourceMetadata(GetResourceMetadataRequest request) {
        request = (GetResourceMetadataRequest)this.beforeClientExecution(request);
        return this.executeGetResourceMetadata(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetResourceMetadataResult executeGetResourceMetadata(GetResourceMetadataRequest getResourceMetadataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getResourceMetadataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetResourceMetadataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetResourceMetadataRequestProtocolMarshaller(protocolFactory).marshall((GetResourceMetadataRequest)super.beforeMarshalling((AmazonWebServiceRequest)getResourceMetadataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PI");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetResourceMetadata");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetResourceMetadataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetResourceMetadataResult getResourceMetadataResult = (GetResourceMetadataResult)response.getAwsResponse();
            return getResourceMetadataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetResourceMetricsResult getResourceMetrics(GetResourceMetricsRequest request) {
        request = (GetResourceMetricsRequest)this.beforeClientExecution(request);
        return this.executeGetResourceMetrics(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetResourceMetricsResult executeGetResourceMetrics(GetResourceMetricsRequest getResourceMetricsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getResourceMetricsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetResourceMetricsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetResourceMetricsRequestProtocolMarshaller(protocolFactory).marshall((GetResourceMetricsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getResourceMetricsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PI");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetResourceMetrics");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetResourceMetricsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetResourceMetricsResult getResourceMetricsResult = (GetResourceMetricsResult)response.getAwsResponse();
            return getResourceMetricsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAvailableResourceDimensionsResult listAvailableResourceDimensions(ListAvailableResourceDimensionsRequest request) {
        request = (ListAvailableResourceDimensionsRequest)this.beforeClientExecution(request);
        return this.executeListAvailableResourceDimensions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAvailableResourceDimensionsResult executeListAvailableResourceDimensions(ListAvailableResourceDimensionsRequest listAvailableResourceDimensionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAvailableResourceDimensionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAvailableResourceDimensionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAvailableResourceDimensionsRequestProtocolMarshaller(protocolFactory).marshall((ListAvailableResourceDimensionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAvailableResourceDimensionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PI");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAvailableResourceDimensions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAvailableResourceDimensionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAvailableResourceDimensionsResult listAvailableResourceDimensionsResult = (ListAvailableResourceDimensionsResult)response.getAwsResponse();
            return listAvailableResourceDimensionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAvailableResourceMetricsResult listAvailableResourceMetrics(ListAvailableResourceMetricsRequest request) {
        request = (ListAvailableResourceMetricsRequest)this.beforeClientExecution(request);
        return this.executeListAvailableResourceMetrics(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAvailableResourceMetricsResult executeListAvailableResourceMetrics(ListAvailableResourceMetricsRequest listAvailableResourceMetricsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAvailableResourceMetricsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAvailableResourceMetricsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAvailableResourceMetricsRequestProtocolMarshaller(protocolFactory).marshall((ListAvailableResourceMetricsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAvailableResourceMetricsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PI");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAvailableResourceMetrics");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAvailableResourceMetricsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAvailableResourceMetricsResult listAvailableResourceMetricsResult = (ListAvailableResourceMetricsResult)response.getAwsResponse();
            return listAvailableResourceMetricsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPerformanceAnalysisReportsResult listPerformanceAnalysisReports(ListPerformanceAnalysisReportsRequest request) {
        request = (ListPerformanceAnalysisReportsRequest)this.beforeClientExecution(request);
        return this.executeListPerformanceAnalysisReports(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPerformanceAnalysisReportsResult executeListPerformanceAnalysisReports(ListPerformanceAnalysisReportsRequest listPerformanceAnalysisReportsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPerformanceAnalysisReportsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPerformanceAnalysisReportsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPerformanceAnalysisReportsRequestProtocolMarshaller(protocolFactory).marshall((ListPerformanceAnalysisReportsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPerformanceAnalysisReportsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PI");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPerformanceAnalysisReports");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPerformanceAnalysisReportsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPerformanceAnalysisReportsResult listPerformanceAnalysisReportsResult = (ListPerformanceAnalysisReportsResult)response.getAwsResponse();
            return listPerformanceAnalysisReportsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PI");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PI");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PI");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

