/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pi;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.pi.AWSPIAsync;
import com.amazonaws.services.pi.AWSPIAsyncClientBuilder;
import com.amazonaws.services.pi.AWSPIClient;
import com.amazonaws.services.pi.model.DescribeDimensionKeysRequest;
import com.amazonaws.services.pi.model.DescribeDimensionKeysResult;
import com.amazonaws.services.pi.model.GetDimensionKeyDetailsRequest;
import com.amazonaws.services.pi.model.GetDimensionKeyDetailsResult;
import com.amazonaws.services.pi.model.GetResourceMetadataRequest;
import com.amazonaws.services.pi.model.GetResourceMetadataResult;
import com.amazonaws.services.pi.model.GetResourceMetricsRequest;
import com.amazonaws.services.pi.model.GetResourceMetricsResult;
import com.amazonaws.services.pi.model.ListAvailableResourceDimensionsRequest;
import com.amazonaws.services.pi.model.ListAvailableResourceDimensionsResult;
import com.amazonaws.services.pi.model.ListAvailableResourceMetricsRequest;
import com.amazonaws.services.pi.model.ListAvailableResourceMetricsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSPIAsyncClient
extends AWSPIClient
implements AWSPIAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSPIAsyncClientBuilder asyncBuilder() {
        return AWSPIAsyncClientBuilder.standard();
    }

    AWSPIAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSPIAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DescribeDimensionKeysResult> describeDimensionKeysAsync(DescribeDimensionKeysRequest request) {
        return this.describeDimensionKeysAsync(request, null);
    }

    @Override
    public Future<DescribeDimensionKeysResult> describeDimensionKeysAsync(DescribeDimensionKeysRequest request, final AsyncHandler<DescribeDimensionKeysRequest, DescribeDimensionKeysResult> asyncHandler) {
        final DescribeDimensionKeysRequest finalRequest = (DescribeDimensionKeysRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDimensionKeysResult>(){

            @Override
            public DescribeDimensionKeysResult call() throws Exception {
                DescribeDimensionKeysResult result = null;
                try {
                    result = AWSPIAsyncClient.this.executeDescribeDimensionKeys(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDimensionKeyDetailsResult> getDimensionKeyDetailsAsync(GetDimensionKeyDetailsRequest request) {
        return this.getDimensionKeyDetailsAsync(request, null);
    }

    @Override
    public Future<GetDimensionKeyDetailsResult> getDimensionKeyDetailsAsync(GetDimensionKeyDetailsRequest request, final AsyncHandler<GetDimensionKeyDetailsRequest, GetDimensionKeyDetailsResult> asyncHandler) {
        final GetDimensionKeyDetailsRequest finalRequest = (GetDimensionKeyDetailsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDimensionKeyDetailsResult>(){

            @Override
            public GetDimensionKeyDetailsResult call() throws Exception {
                GetDimensionKeyDetailsResult result = null;
                try {
                    result = AWSPIAsyncClient.this.executeGetDimensionKeyDetails(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetResourceMetadataResult> getResourceMetadataAsync(GetResourceMetadataRequest request) {
        return this.getResourceMetadataAsync(request, null);
    }

    @Override
    public Future<GetResourceMetadataResult> getResourceMetadataAsync(GetResourceMetadataRequest request, final AsyncHandler<GetResourceMetadataRequest, GetResourceMetadataResult> asyncHandler) {
        final GetResourceMetadataRequest finalRequest = (GetResourceMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResourceMetadataResult>(){

            @Override
            public GetResourceMetadataResult call() throws Exception {
                GetResourceMetadataResult result = null;
                try {
                    result = AWSPIAsyncClient.this.executeGetResourceMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetResourceMetricsResult> getResourceMetricsAsync(GetResourceMetricsRequest request) {
        return this.getResourceMetricsAsync(request, null);
    }

    @Override
    public Future<GetResourceMetricsResult> getResourceMetricsAsync(GetResourceMetricsRequest request, final AsyncHandler<GetResourceMetricsRequest, GetResourceMetricsResult> asyncHandler) {
        final GetResourceMetricsRequest finalRequest = (GetResourceMetricsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResourceMetricsResult>(){

            @Override
            public GetResourceMetricsResult call() throws Exception {
                GetResourceMetricsResult result = null;
                try {
                    result = AWSPIAsyncClient.this.executeGetResourceMetrics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAvailableResourceDimensionsResult> listAvailableResourceDimensionsAsync(ListAvailableResourceDimensionsRequest request) {
        return this.listAvailableResourceDimensionsAsync(request, null);
    }

    @Override
    public Future<ListAvailableResourceDimensionsResult> listAvailableResourceDimensionsAsync(ListAvailableResourceDimensionsRequest request, final AsyncHandler<ListAvailableResourceDimensionsRequest, ListAvailableResourceDimensionsResult> asyncHandler) {
        final ListAvailableResourceDimensionsRequest finalRequest = (ListAvailableResourceDimensionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAvailableResourceDimensionsResult>(){

            @Override
            public ListAvailableResourceDimensionsResult call() throws Exception {
                ListAvailableResourceDimensionsResult result = null;
                try {
                    result = AWSPIAsyncClient.this.executeListAvailableResourceDimensions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAvailableResourceMetricsResult> listAvailableResourceMetricsAsync(ListAvailableResourceMetricsRequest request) {
        return this.listAvailableResourceMetricsAsync(request, null);
    }

    @Override
    public Future<ListAvailableResourceMetricsResult> listAvailableResourceMetricsAsync(ListAvailableResourceMetricsRequest request, final AsyncHandler<ListAvailableResourceMetricsRequest, ListAvailableResourceMetricsResult> asyncHandler) {
        final ListAvailableResourceMetricsRequest finalRequest = (ListAvailableResourceMetricsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAvailableResourceMetricsResult>(){

            @Override
            public ListAvailableResourceMetricsResult call() throws Exception {
                ListAvailableResourceMetricsResult result = null;
                try {
                    result = AWSPIAsyncClient.this.executeListAvailableResourceMetrics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

