/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.personalize.model.transform.AutoMLConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AutoMLConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String metricName;
    private List<String> recipeList;

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public AutoMLConfig withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public List<String> getRecipeList() {
        return this.recipeList;
    }

    public void setRecipeList(Collection<String> recipeList) {
        if (recipeList == null) {
            this.recipeList = null;
            return;
        }
        this.recipeList = new ArrayList<String>(recipeList);
    }

    public AutoMLConfig withRecipeList(String ... recipeList) {
        if (this.recipeList == null) {
            this.setRecipeList(new ArrayList<String>(recipeList.length));
        }
        for (String ele : recipeList) {
            this.recipeList.add(ele);
        }
        return this;
    }

    public AutoMLConfig withRecipeList(Collection<String> recipeList) {
        this.setRecipeList(recipeList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName()).append(",");
        }
        if (this.getRecipeList() != null) {
            sb.append("RecipeList: ").append(this.getRecipeList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLConfig)) {
            return false;
        }
        AutoMLConfig other = (AutoMLConfig)obj;
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getRecipeList() == null ^ this.getRecipeList() == null) {
            return false;
        }
        return other.getRecipeList() == null || other.getRecipeList().equals(this.getRecipeList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getRecipeList() == null ? 0 : this.getRecipeList().hashCode());
        return hashCode;
    }

    public AutoMLConfig clone() {
        try {
            return (AutoMLConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoMLConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

