/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.personalize.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Provides the name and default range of a continuous hyperparameter and whether the hyperparameter is tunable. A
 * tunable hyperparameter can have its value determined during hyperparameter optimization (HPO).
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DefaultContinuousHyperParameterRange"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DefaultContinuousHyperParameterRange implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the hyperparameter.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The minimum allowable value for the hyperparameter.
     * </p>
     */
    private Double minValue;
    /**
     * <p>
     * The maximum allowable value for the hyperparameter.
     * </p>
     */
    private Double maxValue;
    /**
     * <p>
     * Whether the hyperparameter is tunable.
     * </p>
     */
    private Boolean isTunable;

    /**
     * <p>
     * The name of the hyperparameter.
     * </p>
     * 
     * @param name
     *        The name of the hyperparameter.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the hyperparameter.
     * </p>
     * 
     * @return The name of the hyperparameter.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the hyperparameter.
     * </p>
     * 
     * @param name
     *        The name of the hyperparameter.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DefaultContinuousHyperParameterRange withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The minimum allowable value for the hyperparameter.
     * </p>
     * 
     * @param minValue
     *        The minimum allowable value for the hyperparameter.
     */

    public void setMinValue(Double minValue) {
        this.minValue = minValue;
    }

    /**
     * <p>
     * The minimum allowable value for the hyperparameter.
     * </p>
     * 
     * @return The minimum allowable value for the hyperparameter.
     */

    public Double getMinValue() {
        return this.minValue;
    }

    /**
     * <p>
     * The minimum allowable value for the hyperparameter.
     * </p>
     * 
     * @param minValue
     *        The minimum allowable value for the hyperparameter.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DefaultContinuousHyperParameterRange withMinValue(Double minValue) {
        setMinValue(minValue);
        return this;
    }

    /**
     * <p>
     * The maximum allowable value for the hyperparameter.
     * </p>
     * 
     * @param maxValue
     *        The maximum allowable value for the hyperparameter.
     */

    public void setMaxValue(Double maxValue) {
        this.maxValue = maxValue;
    }

    /**
     * <p>
     * The maximum allowable value for the hyperparameter.
     * </p>
     * 
     * @return The maximum allowable value for the hyperparameter.
     */

    public Double getMaxValue() {
        return this.maxValue;
    }

    /**
     * <p>
     * The maximum allowable value for the hyperparameter.
     * </p>
     * 
     * @param maxValue
     *        The maximum allowable value for the hyperparameter.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DefaultContinuousHyperParameterRange withMaxValue(Double maxValue) {
        setMaxValue(maxValue);
        return this;
    }

    /**
     * <p>
     * Whether the hyperparameter is tunable.
     * </p>
     * 
     * @param isTunable
     *        Whether the hyperparameter is tunable.
     */

    public void setIsTunable(Boolean isTunable) {
        this.isTunable = isTunable;
    }

    /**
     * <p>
     * Whether the hyperparameter is tunable.
     * </p>
     * 
     * @return Whether the hyperparameter is tunable.
     */

    public Boolean getIsTunable() {
        return this.isTunable;
    }

    /**
     * <p>
     * Whether the hyperparameter is tunable.
     * </p>
     * 
     * @param isTunable
     *        Whether the hyperparameter is tunable.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DefaultContinuousHyperParameterRange withIsTunable(Boolean isTunable) {
        setIsTunable(isTunable);
        return this;
    }

    /**
     * <p>
     * Whether the hyperparameter is tunable.
     * </p>
     * 
     * @return Whether the hyperparameter is tunable.
     */

    public Boolean isTunable() {
        return this.isTunable;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getMinValue() != null)
            sb.append("MinValue: ").append(getMinValue()).append(",");
        if (getMaxValue() != null)
            sb.append("MaxValue: ").append(getMaxValue()).append(",");
        if (getIsTunable() != null)
            sb.append("IsTunable: ").append(getIsTunable());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DefaultContinuousHyperParameterRange == false)
            return false;
        DefaultContinuousHyperParameterRange other = (DefaultContinuousHyperParameterRange) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getMinValue() == null ^ this.getMinValue() == null)
            return false;
        if (other.getMinValue() != null && other.getMinValue().equals(this.getMinValue()) == false)
            return false;
        if (other.getMaxValue() == null ^ this.getMaxValue() == null)
            return false;
        if (other.getMaxValue() != null && other.getMaxValue().equals(this.getMaxValue()) == false)
            return false;
        if (other.getIsTunable() == null ^ this.getIsTunable() == null)
            return false;
        if (other.getIsTunable() != null && other.getIsTunable().equals(this.getIsTunable()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getMinValue() == null) ? 0 : getMinValue().hashCode());
        hashCode = prime * hashCode + ((getMaxValue() == null) ? 0 : getMaxValue().hashCode());
        hashCode = prime * hashCode + ((getIsTunable() == null) ? 0 : getIsTunable().hashCode());
        return hashCode;
    }

    @Override
    public DefaultContinuousHyperParameterRange clone() {
        try {
            return (DefaultContinuousHyperParameterRange) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.personalize.model.transform.DefaultContinuousHyperParameterRangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
