/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.personalize.model.AlgorithmImage;
import com.amazonaws.services.personalize.model.DefaultHyperParameterRanges;
import com.amazonaws.services.personalize.model.transform.AlgorithmMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Algorithm
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String algorithmArn;
    private AlgorithmImage algorithmImage;
    private Map<String, String> defaultHyperParameters;
    private DefaultHyperParameterRanges defaultHyperParameterRanges;
    private Map<String, String> defaultResourceConfig;
    private String trainingInputMode;
    private String roleArn;
    private Date creationDateTime;
    private Date lastUpdatedDateTime;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Algorithm withName(String name) {
        this.setName(name);
        return this;
    }

    public void setAlgorithmArn(String algorithmArn) {
        this.algorithmArn = algorithmArn;
    }

    public String getAlgorithmArn() {
        return this.algorithmArn;
    }

    public Algorithm withAlgorithmArn(String algorithmArn) {
        this.setAlgorithmArn(algorithmArn);
        return this;
    }

    public void setAlgorithmImage(AlgorithmImage algorithmImage) {
        this.algorithmImage = algorithmImage;
    }

    public AlgorithmImage getAlgorithmImage() {
        return this.algorithmImage;
    }

    public Algorithm withAlgorithmImage(AlgorithmImage algorithmImage) {
        this.setAlgorithmImage(algorithmImage);
        return this;
    }

    public Map<String, String> getDefaultHyperParameters() {
        return this.defaultHyperParameters;
    }

    public void setDefaultHyperParameters(Map<String, String> defaultHyperParameters) {
        this.defaultHyperParameters = defaultHyperParameters;
    }

    public Algorithm withDefaultHyperParameters(Map<String, String> defaultHyperParameters) {
        this.setDefaultHyperParameters(defaultHyperParameters);
        return this;
    }

    public Algorithm addDefaultHyperParametersEntry(String key, String value) {
        if (null == this.defaultHyperParameters) {
            this.defaultHyperParameters = new HashMap<String, String>();
        }
        if (this.defaultHyperParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.defaultHyperParameters.put(key, value);
        return this;
    }

    public Algorithm clearDefaultHyperParametersEntries() {
        this.defaultHyperParameters = null;
        return this;
    }

    public void setDefaultHyperParameterRanges(DefaultHyperParameterRanges defaultHyperParameterRanges) {
        this.defaultHyperParameterRanges = defaultHyperParameterRanges;
    }

    public DefaultHyperParameterRanges getDefaultHyperParameterRanges() {
        return this.defaultHyperParameterRanges;
    }

    public Algorithm withDefaultHyperParameterRanges(DefaultHyperParameterRanges defaultHyperParameterRanges) {
        this.setDefaultHyperParameterRanges(defaultHyperParameterRanges);
        return this;
    }

    public Map<String, String> getDefaultResourceConfig() {
        return this.defaultResourceConfig;
    }

    public void setDefaultResourceConfig(Map<String, String> defaultResourceConfig) {
        this.defaultResourceConfig = defaultResourceConfig;
    }

    public Algorithm withDefaultResourceConfig(Map<String, String> defaultResourceConfig) {
        this.setDefaultResourceConfig(defaultResourceConfig);
        return this;
    }

    public Algorithm addDefaultResourceConfigEntry(String key, String value) {
        if (null == this.defaultResourceConfig) {
            this.defaultResourceConfig = new HashMap<String, String>();
        }
        if (this.defaultResourceConfig.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.defaultResourceConfig.put(key, value);
        return this;
    }

    public Algorithm clearDefaultResourceConfigEntries() {
        this.defaultResourceConfig = null;
        return this;
    }

    public void setTrainingInputMode(String trainingInputMode) {
        this.trainingInputMode = trainingInputMode;
    }

    public String getTrainingInputMode() {
        return this.trainingInputMode;
    }

    public Algorithm withTrainingInputMode(String trainingInputMode) {
        this.setTrainingInputMode(trainingInputMode);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public Algorithm withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setCreationDateTime(Date creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public Date getCreationDateTime() {
        return this.creationDateTime;
    }

    public Algorithm withCreationDateTime(Date creationDateTime) {
        this.setCreationDateTime(creationDateTime);
        return this;
    }

    public void setLastUpdatedDateTime(Date lastUpdatedDateTime) {
        this.lastUpdatedDateTime = lastUpdatedDateTime;
    }

    public Date getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Algorithm withLastUpdatedDateTime(Date lastUpdatedDateTime) {
        this.setLastUpdatedDateTime(lastUpdatedDateTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getAlgorithmArn() != null) {
            sb.append("AlgorithmArn: ").append(this.getAlgorithmArn()).append(",");
        }
        if (this.getAlgorithmImage() != null) {
            sb.append("AlgorithmImage: ").append(this.getAlgorithmImage()).append(",");
        }
        if (this.getDefaultHyperParameters() != null) {
            sb.append("DefaultHyperParameters: ").append(this.getDefaultHyperParameters()).append(",");
        }
        if (this.getDefaultHyperParameterRanges() != null) {
            sb.append("DefaultHyperParameterRanges: ").append(this.getDefaultHyperParameterRanges()).append(",");
        }
        if (this.getDefaultResourceConfig() != null) {
            sb.append("DefaultResourceConfig: ").append(this.getDefaultResourceConfig()).append(",");
        }
        if (this.getTrainingInputMode() != null) {
            sb.append("TrainingInputMode: ").append(this.getTrainingInputMode()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getCreationDateTime() != null) {
            sb.append("CreationDateTime: ").append(this.getCreationDateTime()).append(",");
        }
        if (this.getLastUpdatedDateTime() != null) {
            sb.append("LastUpdatedDateTime: ").append(this.getLastUpdatedDateTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Algorithm)) {
            return false;
        }
        Algorithm other = (Algorithm)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getAlgorithmArn() == null ^ this.getAlgorithmArn() == null) {
            return false;
        }
        if (other.getAlgorithmArn() != null && !other.getAlgorithmArn().equals(this.getAlgorithmArn())) {
            return false;
        }
        if (other.getAlgorithmImage() == null ^ this.getAlgorithmImage() == null) {
            return false;
        }
        if (other.getAlgorithmImage() != null && !other.getAlgorithmImage().equals(this.getAlgorithmImage())) {
            return false;
        }
        if (other.getDefaultHyperParameters() == null ^ this.getDefaultHyperParameters() == null) {
            return false;
        }
        if (other.getDefaultHyperParameters() != null && !other.getDefaultHyperParameters().equals(this.getDefaultHyperParameters())) {
            return false;
        }
        if (other.getDefaultHyperParameterRanges() == null ^ this.getDefaultHyperParameterRanges() == null) {
            return false;
        }
        if (other.getDefaultHyperParameterRanges() != null && !other.getDefaultHyperParameterRanges().equals(this.getDefaultHyperParameterRanges())) {
            return false;
        }
        if (other.getDefaultResourceConfig() == null ^ this.getDefaultResourceConfig() == null) {
            return false;
        }
        if (other.getDefaultResourceConfig() != null && !other.getDefaultResourceConfig().equals(this.getDefaultResourceConfig())) {
            return false;
        }
        if (other.getTrainingInputMode() == null ^ this.getTrainingInputMode() == null) {
            return false;
        }
        if (other.getTrainingInputMode() != null && !other.getTrainingInputMode().equals(this.getTrainingInputMode())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getCreationDateTime() == null ^ this.getCreationDateTime() == null) {
            return false;
        }
        if (other.getCreationDateTime() != null && !other.getCreationDateTime().equals(this.getCreationDateTime())) {
            return false;
        }
        if (other.getLastUpdatedDateTime() == null ^ this.getLastUpdatedDateTime() == null) {
            return false;
        }
        return other.getLastUpdatedDateTime() == null || other.getLastUpdatedDateTime().equals(this.getLastUpdatedDateTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getAlgorithmArn() == null ? 0 : this.getAlgorithmArn().hashCode());
        hashCode = 31 * hashCode + (this.getAlgorithmImage() == null ? 0 : this.getAlgorithmImage().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultHyperParameters() == null ? 0 : this.getDefaultHyperParameters().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultHyperParameterRanges() == null ? 0 : this.getDefaultHyperParameterRanges().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultResourceConfig() == null ? 0 : this.getDefaultResourceConfig().hashCode());
        hashCode = 31 * hashCode + (this.getTrainingInputMode() == null ? 0 : this.getTrainingInputMode().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreationDateTime() == null ? 0 : this.getCreationDateTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedDateTime() == null ? 0 : this.getLastUpdatedDateTime().hashCode());
        return hashCode;
    }

    public Algorithm clone() {
        try {
            return (Algorithm)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AlgorithmMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

