/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pcaconnectorscep.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pcaconnectorscep.model.transform.OpenIdConfigurationMarshaller;
import java.io.Serializable;

public class OpenIdConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String issuer;
    private String subject;
    private String audience;

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public OpenIdConfiguration withIssuer(String issuer) {
        this.setIssuer(issuer);
        return this;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public OpenIdConfiguration withSubject(String subject) {
        this.setSubject(subject);
        return this;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public String getAudience() {
        return this.audience;
    }

    public OpenIdConfiguration withAudience(String audience) {
        this.setAudience(audience);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIssuer() != null) {
            sb.append("Issuer: ").append(this.getIssuer()).append(",");
        }
        if (this.getSubject() != null) {
            sb.append("Subject: ").append(this.getSubject()).append(",");
        }
        if (this.getAudience() != null) {
            sb.append("Audience: ").append(this.getAudience());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenIdConfiguration)) {
            return false;
        }
        OpenIdConfiguration other = (OpenIdConfiguration)obj;
        if (other.getIssuer() == null ^ this.getIssuer() == null) {
            return false;
        }
        if (other.getIssuer() != null && !other.getIssuer().equals(this.getIssuer())) {
            return false;
        }
        if (other.getSubject() == null ^ this.getSubject() == null) {
            return false;
        }
        if (other.getSubject() != null && !other.getSubject().equals(this.getSubject())) {
            return false;
        }
        if (other.getAudience() == null ^ this.getAudience() == null) {
            return false;
        }
        return other.getAudience() == null || other.getAudience().equals(this.getAudience());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIssuer() == null ? 0 : this.getIssuer().hashCode());
        hashCode = 31 * hashCode + (this.getSubject() == null ? 0 : this.getSubject().hashCode());
        hashCode = 31 * hashCode + (this.getAudience() == null ? 0 : this.getAudience().hashCode());
        return hashCode;
    }

    public OpenIdConfiguration clone() {
        try {
            return (OpenIdConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OpenIdConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

