/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pcaconnectorscep.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.pcaconnectorscep.model.ConnectorSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListConnectorsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ConnectorSummary> connectors;
    private String nextToken;

    public List<ConnectorSummary> getConnectors() {
        return this.connectors;
    }

    public void setConnectors(Collection<ConnectorSummary> connectors) {
        if (connectors == null) {
            this.connectors = null;
            return;
        }
        this.connectors = new ArrayList<ConnectorSummary>(connectors);
    }

    public ListConnectorsResult withConnectors(ConnectorSummary ... connectors) {
        if (this.connectors == null) {
            this.setConnectors(new ArrayList<ConnectorSummary>(connectors.length));
        }
        for (ConnectorSummary ele : connectors) {
            this.connectors.add(ele);
        }
        return this;
    }

    public ListConnectorsResult withConnectors(Collection<ConnectorSummary> connectors) {
        this.setConnectors(connectors);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListConnectorsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConnectors() != null) {
            sb.append("Connectors: ").append(this.getConnectors()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectorsResult)) {
            return false;
        }
        ListConnectorsResult other = (ListConnectorsResult)obj;
        if (other.getConnectors() == null ^ this.getConnectors() == null) {
            return false;
        }
        if (other.getConnectors() != null && !other.getConnectors().equals(this.getConnectors())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConnectors() == null ? 0 : this.getConnectors().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListConnectorsResult clone() {
        try {
            return (ListConnectorsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

