/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pcaconnectorscep.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pcaconnectorscep.model.OpenIdConfiguration;

@SdkInternalApi
public class OpenIdConfigurationMarshaller {
    private static final MarshallingInfo<String> ISSUER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Issuer").build();
    private static final MarshallingInfo<String> SUBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subject").build();
    private static final MarshallingInfo<String> AUDIENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Audience").build();
    private static final OpenIdConfigurationMarshaller instance = new OpenIdConfigurationMarshaller();

    public static OpenIdConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(OpenIdConfiguration openIdConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (openIdConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)openIdConfiguration.getIssuer(), ISSUER_BINDING);
            protocolMarshaller.marshall((Object)openIdConfiguration.getSubject(), SUBJECT_BINDING);
            protocolMarshaller.marshall((Object)openIdConfiguration.getAudience(), AUDIENCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

