/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pcaconnectorscep;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.pcaconnectorscep.AWSPcaConnectorScep;
import com.amazonaws.services.pcaconnectorscep.AWSPcaConnectorScepClientBuilder;
import com.amazonaws.services.pcaconnectorscep.model.AWSPcaConnectorScepException;
import com.amazonaws.services.pcaconnectorscep.model.CreateChallengeRequest;
import com.amazonaws.services.pcaconnectorscep.model.CreateChallengeResult;
import com.amazonaws.services.pcaconnectorscep.model.CreateConnectorRequest;
import com.amazonaws.services.pcaconnectorscep.model.CreateConnectorResult;
import com.amazonaws.services.pcaconnectorscep.model.DeleteChallengeRequest;
import com.amazonaws.services.pcaconnectorscep.model.DeleteChallengeResult;
import com.amazonaws.services.pcaconnectorscep.model.DeleteConnectorRequest;
import com.amazonaws.services.pcaconnectorscep.model.DeleteConnectorResult;
import com.amazonaws.services.pcaconnectorscep.model.GetChallengeMetadataRequest;
import com.amazonaws.services.pcaconnectorscep.model.GetChallengeMetadataResult;
import com.amazonaws.services.pcaconnectorscep.model.GetChallengePasswordRequest;
import com.amazonaws.services.pcaconnectorscep.model.GetChallengePasswordResult;
import com.amazonaws.services.pcaconnectorscep.model.GetConnectorRequest;
import com.amazonaws.services.pcaconnectorscep.model.GetConnectorResult;
import com.amazonaws.services.pcaconnectorscep.model.ListChallengeMetadataRequest;
import com.amazonaws.services.pcaconnectorscep.model.ListChallengeMetadataResult;
import com.amazonaws.services.pcaconnectorscep.model.ListConnectorsRequest;
import com.amazonaws.services.pcaconnectorscep.model.ListConnectorsResult;
import com.amazonaws.services.pcaconnectorscep.model.ListTagsForResourceRequest;
import com.amazonaws.services.pcaconnectorscep.model.ListTagsForResourceResult;
import com.amazonaws.services.pcaconnectorscep.model.TagResourceRequest;
import com.amazonaws.services.pcaconnectorscep.model.TagResourceResult;
import com.amazonaws.services.pcaconnectorscep.model.UntagResourceRequest;
import com.amazonaws.services.pcaconnectorscep.model.UntagResourceResult;
import com.amazonaws.services.pcaconnectorscep.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.CreateChallengeRequestProtocolMarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.CreateChallengeResultJsonUnmarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.CreateConnectorRequestProtocolMarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.CreateConnectorResultJsonUnmarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.DeleteChallengeRequestProtocolMarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.DeleteChallengeResultJsonUnmarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.DeleteConnectorRequestProtocolMarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.DeleteConnectorResultJsonUnmarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.GetChallengeMetadataRequestProtocolMarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.GetChallengeMetadataResultJsonUnmarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.GetChallengePasswordRequestProtocolMarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.GetChallengePasswordResultJsonUnmarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.GetConnectorRequestProtocolMarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.GetConnectorResultJsonUnmarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.ListChallengeMetadataRequestProtocolMarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.ListChallengeMetadataResultJsonUnmarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.ListConnectorsRequestProtocolMarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.ListConnectorsResultJsonUnmarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.pcaconnectorscep.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSPcaConnectorScepClient
extends AmazonWebServiceClient
implements AWSPcaConnectorScep {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSPcaConnectorScep.class);
    private static final String DEFAULT_SIGNING_NAME = "pca-connector-scep";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSPcaConnectorScepException.class));

    public static AWSPcaConnectorScepClientBuilder builder() {
        return AWSPcaConnectorScepClientBuilder.standard();
    }

    AWSPcaConnectorScepClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSPcaConnectorScepClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("pca-connector-scep.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/pcaconnectorscep/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/pcaconnectorscep/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateChallengeResult createChallenge(CreateChallengeRequest request) {
        request = (CreateChallengeRequest)this.beforeClientExecution(request);
        return this.executeCreateChallenge(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateChallengeResult executeCreateChallenge(CreateChallengeRequest createChallengeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createChallengeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateChallengeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateChallengeRequestProtocolMarshaller(protocolFactory).marshall((CreateChallengeRequest)super.beforeMarshalling((AmazonWebServiceRequest)createChallengeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Pca Connector Scep");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateChallenge");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateChallengeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateChallengeResult createChallengeResult = (CreateChallengeResult)response.getAwsResponse();
            return createChallengeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateConnectorResult createConnector(CreateConnectorRequest request) {
        request = (CreateConnectorRequest)this.beforeClientExecution(request);
        return this.executeCreateConnector(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateConnectorResult executeCreateConnector(CreateConnectorRequest createConnectorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createConnectorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateConnectorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateConnectorRequestProtocolMarshaller(protocolFactory).marshall((CreateConnectorRequest)super.beforeMarshalling((AmazonWebServiceRequest)createConnectorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Pca Connector Scep");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateConnector");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateConnectorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateConnectorResult createConnectorResult = (CreateConnectorResult)response.getAwsResponse();
            return createConnectorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteChallengeResult deleteChallenge(DeleteChallengeRequest request) {
        request = (DeleteChallengeRequest)this.beforeClientExecution(request);
        return this.executeDeleteChallenge(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteChallengeResult executeDeleteChallenge(DeleteChallengeRequest deleteChallengeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteChallengeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteChallengeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteChallengeRequestProtocolMarshaller(protocolFactory).marshall((DeleteChallengeRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteChallengeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Pca Connector Scep");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteChallenge");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteChallengeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteChallengeResult deleteChallengeResult = (DeleteChallengeResult)response.getAwsResponse();
            return deleteChallengeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteConnectorResult deleteConnector(DeleteConnectorRequest request) {
        request = (DeleteConnectorRequest)this.beforeClientExecution(request);
        return this.executeDeleteConnector(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteConnectorResult executeDeleteConnector(DeleteConnectorRequest deleteConnectorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteConnectorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteConnectorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteConnectorRequestProtocolMarshaller(protocolFactory).marshall((DeleteConnectorRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteConnectorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Pca Connector Scep");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteConnector");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteConnectorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteConnectorResult deleteConnectorResult = (DeleteConnectorResult)response.getAwsResponse();
            return deleteConnectorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetChallengeMetadataResult getChallengeMetadata(GetChallengeMetadataRequest request) {
        request = (GetChallengeMetadataRequest)this.beforeClientExecution(request);
        return this.executeGetChallengeMetadata(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetChallengeMetadataResult executeGetChallengeMetadata(GetChallengeMetadataRequest getChallengeMetadataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getChallengeMetadataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetChallengeMetadataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetChallengeMetadataRequestProtocolMarshaller(protocolFactory).marshall((GetChallengeMetadataRequest)super.beforeMarshalling((AmazonWebServiceRequest)getChallengeMetadataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Pca Connector Scep");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetChallengeMetadata");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetChallengeMetadataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetChallengeMetadataResult getChallengeMetadataResult = (GetChallengeMetadataResult)response.getAwsResponse();
            return getChallengeMetadataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetChallengePasswordResult getChallengePassword(GetChallengePasswordRequest request) {
        request = (GetChallengePasswordRequest)this.beforeClientExecution(request);
        return this.executeGetChallengePassword(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetChallengePasswordResult executeGetChallengePassword(GetChallengePasswordRequest getChallengePasswordRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getChallengePasswordRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetChallengePasswordRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetChallengePasswordRequestProtocolMarshaller(protocolFactory).marshall((GetChallengePasswordRequest)super.beforeMarshalling((AmazonWebServiceRequest)getChallengePasswordRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Pca Connector Scep");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetChallengePassword");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetChallengePasswordResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetChallengePasswordResult getChallengePasswordResult = (GetChallengePasswordResult)response.getAwsResponse();
            return getChallengePasswordResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetConnectorResult getConnector(GetConnectorRequest request) {
        request = (GetConnectorRequest)this.beforeClientExecution(request);
        return this.executeGetConnector(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetConnectorResult executeGetConnector(GetConnectorRequest getConnectorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getConnectorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetConnectorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetConnectorRequestProtocolMarshaller(protocolFactory).marshall((GetConnectorRequest)super.beforeMarshalling((AmazonWebServiceRequest)getConnectorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Pca Connector Scep");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetConnector");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetConnectorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetConnectorResult getConnectorResult = (GetConnectorResult)response.getAwsResponse();
            return getConnectorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListChallengeMetadataResult listChallengeMetadata(ListChallengeMetadataRequest request) {
        request = (ListChallengeMetadataRequest)this.beforeClientExecution(request);
        return this.executeListChallengeMetadata(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListChallengeMetadataResult executeListChallengeMetadata(ListChallengeMetadataRequest listChallengeMetadataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listChallengeMetadataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListChallengeMetadataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListChallengeMetadataRequestProtocolMarshaller(protocolFactory).marshall((ListChallengeMetadataRequest)super.beforeMarshalling((AmazonWebServiceRequest)listChallengeMetadataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Pca Connector Scep");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListChallengeMetadata");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListChallengeMetadataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListChallengeMetadataResult listChallengeMetadataResult = (ListChallengeMetadataResult)response.getAwsResponse();
            return listChallengeMetadataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListConnectorsResult listConnectors(ListConnectorsRequest request) {
        request = (ListConnectorsRequest)this.beforeClientExecution(request);
        return this.executeListConnectors(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListConnectorsResult executeListConnectors(ListConnectorsRequest listConnectorsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listConnectorsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListConnectorsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListConnectorsRequestProtocolMarshaller(protocolFactory).marshall((ListConnectorsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listConnectorsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Pca Connector Scep");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListConnectors");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListConnectorsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListConnectorsResult listConnectorsResult = (ListConnectorsResult)response.getAwsResponse();
            return listConnectorsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Pca Connector Scep");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Pca Connector Scep");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Pca Connector Scep");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

