/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.pcaconnectorad;

import javax.annotation.Generated;

import com.amazonaws.services.pcaconnectorad.model.*;

/**
 * Abstract implementation of {@code AWSPcaConnectorAdAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSPcaConnectorAdAsync extends AbstractAWSPcaConnectorAd implements AWSPcaConnectorAdAsync {

    protected AbstractAWSPcaConnectorAdAsync() {
    }

    @Override
    public java.util.concurrent.Future<CreateConnectorResult> createConnectorAsync(CreateConnectorRequest request) {

        return createConnectorAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateConnectorResult> createConnectorAsync(CreateConnectorRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateConnectorRequest, CreateConnectorResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateDirectoryRegistrationResult> createDirectoryRegistrationAsync(CreateDirectoryRegistrationRequest request) {

        return createDirectoryRegistrationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateDirectoryRegistrationResult> createDirectoryRegistrationAsync(CreateDirectoryRegistrationRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateDirectoryRegistrationRequest, CreateDirectoryRegistrationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateServicePrincipalNameResult> createServicePrincipalNameAsync(CreateServicePrincipalNameRequest request) {

        return createServicePrincipalNameAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateServicePrincipalNameResult> createServicePrincipalNameAsync(CreateServicePrincipalNameRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateServicePrincipalNameRequest, CreateServicePrincipalNameResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateTemplateResult> createTemplateAsync(CreateTemplateRequest request) {

        return createTemplateAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateTemplateResult> createTemplateAsync(CreateTemplateRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateTemplateRequest, CreateTemplateResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateTemplateGroupAccessControlEntryResult> createTemplateGroupAccessControlEntryAsync(
            CreateTemplateGroupAccessControlEntryRequest request) {

        return createTemplateGroupAccessControlEntryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateTemplateGroupAccessControlEntryResult> createTemplateGroupAccessControlEntryAsync(
            CreateTemplateGroupAccessControlEntryRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateTemplateGroupAccessControlEntryRequest, CreateTemplateGroupAccessControlEntryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteConnectorResult> deleteConnectorAsync(DeleteConnectorRequest request) {

        return deleteConnectorAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteConnectorResult> deleteConnectorAsync(DeleteConnectorRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteConnectorRequest, DeleteConnectorResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteDirectoryRegistrationResult> deleteDirectoryRegistrationAsync(DeleteDirectoryRegistrationRequest request) {

        return deleteDirectoryRegistrationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteDirectoryRegistrationResult> deleteDirectoryRegistrationAsync(DeleteDirectoryRegistrationRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteDirectoryRegistrationRequest, DeleteDirectoryRegistrationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteServicePrincipalNameResult> deleteServicePrincipalNameAsync(DeleteServicePrincipalNameRequest request) {

        return deleteServicePrincipalNameAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteServicePrincipalNameResult> deleteServicePrincipalNameAsync(DeleteServicePrincipalNameRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteServicePrincipalNameRequest, DeleteServicePrincipalNameResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteTemplateResult> deleteTemplateAsync(DeleteTemplateRequest request) {

        return deleteTemplateAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteTemplateResult> deleteTemplateAsync(DeleteTemplateRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteTemplateRequest, DeleteTemplateResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteTemplateGroupAccessControlEntryResult> deleteTemplateGroupAccessControlEntryAsync(
            DeleteTemplateGroupAccessControlEntryRequest request) {

        return deleteTemplateGroupAccessControlEntryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteTemplateGroupAccessControlEntryResult> deleteTemplateGroupAccessControlEntryAsync(
            DeleteTemplateGroupAccessControlEntryRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteTemplateGroupAccessControlEntryRequest, DeleteTemplateGroupAccessControlEntryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetConnectorResult> getConnectorAsync(GetConnectorRequest request) {

        return getConnectorAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetConnectorResult> getConnectorAsync(GetConnectorRequest request,
            com.amazonaws.handlers.AsyncHandler<GetConnectorRequest, GetConnectorResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetDirectoryRegistrationResult> getDirectoryRegistrationAsync(GetDirectoryRegistrationRequest request) {

        return getDirectoryRegistrationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetDirectoryRegistrationResult> getDirectoryRegistrationAsync(GetDirectoryRegistrationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetDirectoryRegistrationRequest, GetDirectoryRegistrationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetServicePrincipalNameResult> getServicePrincipalNameAsync(GetServicePrincipalNameRequest request) {

        return getServicePrincipalNameAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetServicePrincipalNameResult> getServicePrincipalNameAsync(GetServicePrincipalNameRequest request,
            com.amazonaws.handlers.AsyncHandler<GetServicePrincipalNameRequest, GetServicePrincipalNameResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetTemplateResult> getTemplateAsync(GetTemplateRequest request) {

        return getTemplateAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetTemplateResult> getTemplateAsync(GetTemplateRequest request,
            com.amazonaws.handlers.AsyncHandler<GetTemplateRequest, GetTemplateResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetTemplateGroupAccessControlEntryResult> getTemplateGroupAccessControlEntryAsync(
            GetTemplateGroupAccessControlEntryRequest request) {

        return getTemplateGroupAccessControlEntryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetTemplateGroupAccessControlEntryResult> getTemplateGroupAccessControlEntryAsync(
            GetTemplateGroupAccessControlEntryRequest request,
            com.amazonaws.handlers.AsyncHandler<GetTemplateGroupAccessControlEntryRequest, GetTemplateGroupAccessControlEntryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListConnectorsResult> listConnectorsAsync(ListConnectorsRequest request) {

        return listConnectorsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListConnectorsResult> listConnectorsAsync(ListConnectorsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListConnectorsRequest, ListConnectorsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListDirectoryRegistrationsResult> listDirectoryRegistrationsAsync(ListDirectoryRegistrationsRequest request) {

        return listDirectoryRegistrationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListDirectoryRegistrationsResult> listDirectoryRegistrationsAsync(ListDirectoryRegistrationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListDirectoryRegistrationsRequest, ListDirectoryRegistrationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListServicePrincipalNamesResult> listServicePrincipalNamesAsync(ListServicePrincipalNamesRequest request) {

        return listServicePrincipalNamesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListServicePrincipalNamesResult> listServicePrincipalNamesAsync(ListServicePrincipalNamesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListServicePrincipalNamesRequest, ListServicePrincipalNamesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTemplateGroupAccessControlEntriesResult> listTemplateGroupAccessControlEntriesAsync(
            ListTemplateGroupAccessControlEntriesRequest request) {

        return listTemplateGroupAccessControlEntriesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTemplateGroupAccessControlEntriesResult> listTemplateGroupAccessControlEntriesAsync(
            ListTemplateGroupAccessControlEntriesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTemplateGroupAccessControlEntriesRequest, ListTemplateGroupAccessControlEntriesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTemplatesResult> listTemplatesAsync(ListTemplatesRequest request) {

        return listTemplatesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTemplatesResult> listTemplatesAsync(ListTemplatesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTemplatesRequest, ListTemplatesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateTemplateResult> updateTemplateAsync(UpdateTemplateRequest request) {

        return updateTemplateAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateTemplateResult> updateTemplateAsync(UpdateTemplateRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateTemplateRequest, UpdateTemplateResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateTemplateGroupAccessControlEntryResult> updateTemplateGroupAccessControlEntryAsync(
            UpdateTemplateGroupAccessControlEntryRequest request) {

        return updateTemplateGroupAccessControlEntryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateTemplateGroupAccessControlEntryResult> updateTemplateGroupAccessControlEntryAsync(
            UpdateTemplateGroupAccessControlEntryRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateTemplateGroupAccessControlEntryRequest, UpdateTemplateGroupAccessControlEntryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
