/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pcaconnectorad.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pcaconnectorad.model.ApplicationPolicy;
import com.amazonaws.services.pcaconnectorad.model.transform.ApplicationPoliciesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ApplicationPolicies
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean critical;
    private List<ApplicationPolicy> policies;

    public void setCritical(Boolean critical) {
        this.critical = critical;
    }

    public Boolean getCritical() {
        return this.critical;
    }

    public ApplicationPolicies withCritical(Boolean critical) {
        this.setCritical(critical);
        return this;
    }

    public Boolean isCritical() {
        return this.critical;
    }

    public List<ApplicationPolicy> getPolicies() {
        return this.policies;
    }

    public void setPolicies(Collection<ApplicationPolicy> policies) {
        if (policies == null) {
            this.policies = null;
            return;
        }
        this.policies = new ArrayList<ApplicationPolicy>(policies);
    }

    public ApplicationPolicies withPolicies(ApplicationPolicy ... policies) {
        if (this.policies == null) {
            this.setPolicies(new ArrayList<ApplicationPolicy>(policies.length));
        }
        for (ApplicationPolicy ele : policies) {
            this.policies.add(ele);
        }
        return this;
    }

    public ApplicationPolicies withPolicies(Collection<ApplicationPolicy> policies) {
        this.setPolicies(policies);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCritical() != null) {
            sb.append("Critical: ").append(this.getCritical()).append(",");
        }
        if (this.getPolicies() != null) {
            sb.append("Policies: ").append(this.getPolicies());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationPolicies)) {
            return false;
        }
        ApplicationPolicies other = (ApplicationPolicies)obj;
        if (other.getCritical() == null ^ this.getCritical() == null) {
            return false;
        }
        if (other.getCritical() != null && !other.getCritical().equals(this.getCritical())) {
            return false;
        }
        if (other.getPolicies() == null ^ this.getPolicies() == null) {
            return false;
        }
        return other.getPolicies() == null || other.getPolicies().equals(this.getPolicies());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCritical() == null ? 0 : this.getCritical().hashCode());
        hashCode = 31 * hashCode + (this.getPolicies() == null ? 0 : this.getPolicies().hashCode());
        return hashCode;
    }

    public ApplicationPolicies clone() {
        try {
            return (ApplicationPolicies)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationPoliciesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

