/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptographydata;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.paymentcryptographydata.AWSPaymentCryptographyData;
import com.amazonaws.services.paymentcryptographydata.AWSPaymentCryptographyDataClientBuilder;
import com.amazonaws.services.paymentcryptographydata.model.AWSPaymentCryptographyDataException;
import com.amazonaws.services.paymentcryptographydata.model.DecryptDataRequest;
import com.amazonaws.services.paymentcryptographydata.model.DecryptDataResult;
import com.amazonaws.services.paymentcryptographydata.model.EncryptDataRequest;
import com.amazonaws.services.paymentcryptographydata.model.EncryptDataResult;
import com.amazonaws.services.paymentcryptographydata.model.GenerateCardValidationDataRequest;
import com.amazonaws.services.paymentcryptographydata.model.GenerateCardValidationDataResult;
import com.amazonaws.services.paymentcryptographydata.model.GenerateMacRequest;
import com.amazonaws.services.paymentcryptographydata.model.GenerateMacResult;
import com.amazonaws.services.paymentcryptographydata.model.GeneratePinDataRequest;
import com.amazonaws.services.paymentcryptographydata.model.GeneratePinDataResult;
import com.amazonaws.services.paymentcryptographydata.model.ReEncryptDataRequest;
import com.amazonaws.services.paymentcryptographydata.model.ReEncryptDataResult;
import com.amazonaws.services.paymentcryptographydata.model.TranslatePinDataRequest;
import com.amazonaws.services.paymentcryptographydata.model.TranslatePinDataResult;
import com.amazonaws.services.paymentcryptographydata.model.VerifyAuthRequestCryptogramRequest;
import com.amazonaws.services.paymentcryptographydata.model.VerifyAuthRequestCryptogramResult;
import com.amazonaws.services.paymentcryptographydata.model.VerifyCardValidationDataRequest;
import com.amazonaws.services.paymentcryptographydata.model.VerifyCardValidationDataResult;
import com.amazonaws.services.paymentcryptographydata.model.VerifyMacRequest;
import com.amazonaws.services.paymentcryptographydata.model.VerifyMacResult;
import com.amazonaws.services.paymentcryptographydata.model.VerifyPinDataRequest;
import com.amazonaws.services.paymentcryptographydata.model.VerifyPinDataResult;
import com.amazonaws.services.paymentcryptographydata.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.DecryptDataRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.DecryptDataResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.EncryptDataRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.EncryptDataResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.GenerateCardValidationDataRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.GenerateCardValidationDataResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.GenerateMacRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.GenerateMacResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.GeneratePinDataRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.GeneratePinDataResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.ReEncryptDataRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.ReEncryptDataResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.TranslatePinDataRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.TranslatePinDataResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.VerificationFailedExceptionUnmarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.VerifyAuthRequestCryptogramRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.VerifyAuthRequestCryptogramResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.VerifyCardValidationDataRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.VerifyCardValidationDataResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.VerifyMacRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.VerifyMacResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.VerifyPinDataRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptographydata.model.transform.VerifyPinDataResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSPaymentCryptographyDataClient
extends AmazonWebServiceClient
implements AWSPaymentCryptographyData {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSPaymentCryptographyData.class);
    private static final String DEFAULT_SIGNING_NAME = "payment-cryptography";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("VerificationFailedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)VerificationFailedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSPaymentCryptographyDataException.class));

    public static AWSPaymentCryptographyDataClientBuilder builder() {
        return AWSPaymentCryptographyDataClientBuilder.standard();
    }

    AWSPaymentCryptographyDataClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSPaymentCryptographyDataClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("dataplane.payment-cryptography");
        this.setEndpoint("dataplane.payment-cryptography.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/paymentcryptographydata/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/paymentcryptographydata/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public DecryptDataResult decryptData(DecryptDataRequest request) {
        request = (DecryptDataRequest)this.beforeClientExecution(request);
        return this.executeDecryptData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DecryptDataResult executeDecryptData(DecryptDataRequest decryptDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(decryptDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DecryptDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DecryptDataRequestProtocolMarshaller(protocolFactory).marshall((DecryptDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)decryptDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DecryptData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DecryptDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DecryptDataResult decryptDataResult = (DecryptDataResult)response.getAwsResponse();
            return decryptDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public EncryptDataResult encryptData(EncryptDataRequest request) {
        request = (EncryptDataRequest)this.beforeClientExecution(request);
        return this.executeEncryptData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final EncryptDataResult executeEncryptData(EncryptDataRequest encryptDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(encryptDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EncryptDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EncryptDataRequestProtocolMarshaller(protocolFactory).marshall((EncryptDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)encryptDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"EncryptData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EncryptDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            EncryptDataResult encryptDataResult = (EncryptDataResult)response.getAwsResponse();
            return encryptDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GenerateCardValidationDataResult generateCardValidationData(GenerateCardValidationDataRequest request) {
        request = (GenerateCardValidationDataRequest)this.beforeClientExecution(request);
        return this.executeGenerateCardValidationData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GenerateCardValidationDataResult executeGenerateCardValidationData(GenerateCardValidationDataRequest generateCardValidationDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(generateCardValidationDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GenerateCardValidationDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GenerateCardValidationDataRequestProtocolMarshaller(protocolFactory).marshall((GenerateCardValidationDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)generateCardValidationDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GenerateCardValidationData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GenerateCardValidationDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GenerateCardValidationDataResult generateCardValidationDataResult = (GenerateCardValidationDataResult)response.getAwsResponse();
            return generateCardValidationDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GenerateMacResult generateMac(GenerateMacRequest request) {
        request = (GenerateMacRequest)this.beforeClientExecution(request);
        return this.executeGenerateMac(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GenerateMacResult executeGenerateMac(GenerateMacRequest generateMacRequest) {
        ExecutionContext executionContext = this.createExecutionContext(generateMacRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GenerateMacRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GenerateMacRequestProtocolMarshaller(protocolFactory).marshall((GenerateMacRequest)super.beforeMarshalling((AmazonWebServiceRequest)generateMacRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GenerateMac");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GenerateMacResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GenerateMacResult generateMacResult = (GenerateMacResult)response.getAwsResponse();
            return generateMacResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GeneratePinDataResult generatePinData(GeneratePinDataRequest request) {
        request = (GeneratePinDataRequest)this.beforeClientExecution(request);
        return this.executeGeneratePinData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GeneratePinDataResult executeGeneratePinData(GeneratePinDataRequest generatePinDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(generatePinDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GeneratePinDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GeneratePinDataRequestProtocolMarshaller(protocolFactory).marshall((GeneratePinDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)generatePinDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GeneratePinData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GeneratePinDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GeneratePinDataResult generatePinDataResult = (GeneratePinDataResult)response.getAwsResponse();
            return generatePinDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ReEncryptDataResult reEncryptData(ReEncryptDataRequest request) {
        request = (ReEncryptDataRequest)this.beforeClientExecution(request);
        return this.executeReEncryptData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ReEncryptDataResult executeReEncryptData(ReEncryptDataRequest reEncryptDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(reEncryptDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ReEncryptDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ReEncryptDataRequestProtocolMarshaller(protocolFactory).marshall((ReEncryptDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)reEncryptDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ReEncryptData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ReEncryptDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ReEncryptDataResult reEncryptDataResult = (ReEncryptDataResult)response.getAwsResponse();
            return reEncryptDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TranslatePinDataResult translatePinData(TranslatePinDataRequest request) {
        request = (TranslatePinDataRequest)this.beforeClientExecution(request);
        return this.executeTranslatePinData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TranslatePinDataResult executeTranslatePinData(TranslatePinDataRequest translatePinDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(translatePinDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TranslatePinDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TranslatePinDataRequestProtocolMarshaller(protocolFactory).marshall((TranslatePinDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)translatePinDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TranslatePinData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TranslatePinDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TranslatePinDataResult translatePinDataResult = (TranslatePinDataResult)response.getAwsResponse();
            return translatePinDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public VerifyAuthRequestCryptogramResult verifyAuthRequestCryptogram(VerifyAuthRequestCryptogramRequest request) {
        request = (VerifyAuthRequestCryptogramRequest)this.beforeClientExecution(request);
        return this.executeVerifyAuthRequestCryptogram(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final VerifyAuthRequestCryptogramResult executeVerifyAuthRequestCryptogram(VerifyAuthRequestCryptogramRequest verifyAuthRequestCryptogramRequest) {
        ExecutionContext executionContext = this.createExecutionContext(verifyAuthRequestCryptogramRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<VerifyAuthRequestCryptogramRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new VerifyAuthRequestCryptogramRequestProtocolMarshaller(protocolFactory).marshall((VerifyAuthRequestCryptogramRequest)super.beforeMarshalling((AmazonWebServiceRequest)verifyAuthRequestCryptogramRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"VerifyAuthRequestCryptogram");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new VerifyAuthRequestCryptogramResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            VerifyAuthRequestCryptogramResult verifyAuthRequestCryptogramResult = (VerifyAuthRequestCryptogramResult)response.getAwsResponse();
            return verifyAuthRequestCryptogramResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public VerifyCardValidationDataResult verifyCardValidationData(VerifyCardValidationDataRequest request) {
        request = (VerifyCardValidationDataRequest)this.beforeClientExecution(request);
        return this.executeVerifyCardValidationData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final VerifyCardValidationDataResult executeVerifyCardValidationData(VerifyCardValidationDataRequest verifyCardValidationDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(verifyCardValidationDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<VerifyCardValidationDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new VerifyCardValidationDataRequestProtocolMarshaller(protocolFactory).marshall((VerifyCardValidationDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)verifyCardValidationDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"VerifyCardValidationData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new VerifyCardValidationDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            VerifyCardValidationDataResult verifyCardValidationDataResult = (VerifyCardValidationDataResult)response.getAwsResponse();
            return verifyCardValidationDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public VerifyMacResult verifyMac(VerifyMacRequest request) {
        request = (VerifyMacRequest)this.beforeClientExecution(request);
        return this.executeVerifyMac(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final VerifyMacResult executeVerifyMac(VerifyMacRequest verifyMacRequest) {
        ExecutionContext executionContext = this.createExecutionContext(verifyMacRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<VerifyMacRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new VerifyMacRequestProtocolMarshaller(protocolFactory).marshall((VerifyMacRequest)super.beforeMarshalling((AmazonWebServiceRequest)verifyMacRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"VerifyMac");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new VerifyMacResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            VerifyMacResult verifyMacResult = (VerifyMacResult)response.getAwsResponse();
            return verifyMacResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public VerifyPinDataResult verifyPinData(VerifyPinDataRequest request) {
        request = (VerifyPinDataRequest)this.beforeClientExecution(request);
        return this.executeVerifyPinData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final VerifyPinDataResult executeVerifyPinData(VerifyPinDataRequest verifyPinDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(verifyPinDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<VerifyPinDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new VerifyPinDataRequestProtocolMarshaller(protocolFactory).marshall((VerifyPinDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)verifyPinDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"VerifyPinData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new VerifyPinDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            VerifyPinDataResult verifyPinDataResult = (VerifyPinDataResult)response.getAwsResponse();
            return verifyPinDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

