/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptographydata.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.paymentcryptographydata.model.EncryptionDecryptionAttributes;

@SdkInternalApi
public class EncryptionDecryptionAttributesMarshaller {
    private static final MarshallingInfo<StructuredPojo> SYMMETRIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Symmetric").build();
    private static final MarshallingInfo<StructuredPojo> ASYMMETRIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Asymmetric").build();
    private static final MarshallingInfo<StructuredPojo> DUKPT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Dukpt").build();
    private static final MarshallingInfo<StructuredPojo> EMV_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Emv").build();
    private static final EncryptionDecryptionAttributesMarshaller instance = new EncryptionDecryptionAttributesMarshaller();

    public static EncryptionDecryptionAttributesMarshaller getInstance() {
        return instance;
    }

    public void marshall(EncryptionDecryptionAttributes encryptionDecryptionAttributes, ProtocolMarshaller protocolMarshaller) {
        if (encryptionDecryptionAttributes == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)encryptionDecryptionAttributes.getSymmetric(), SYMMETRIC_BINDING);
            protocolMarshaller.marshall((Object)encryptionDecryptionAttributes.getAsymmetric(), ASYMMETRIC_BINDING);
            protocolMarshaller.marshall((Object)encryptionDecryptionAttributes.getDukpt(), DUKPT_BINDING);
            protocolMarshaller.marshall((Object)encryptionDecryptionAttributes.getEmv(), EMV_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

