/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptography.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.paymentcryptography.model.KeyBlockHeaders;
import java.util.Map;

@SdkInternalApi
public class KeyBlockHeadersMarshaller {
    private static final MarshallingInfo<StructuredPojo> KEYMODESOFUSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyModesOfUse").build();
    private static final MarshallingInfo<String> KEYEXPORTABILITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyExportability").build();
    private static final MarshallingInfo<String> KEYVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyVersion").build();
    private static final MarshallingInfo<Map> OPTIONALBLOCKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OptionalBlocks").build();
    private static final KeyBlockHeadersMarshaller instance = new KeyBlockHeadersMarshaller();

    public static KeyBlockHeadersMarshaller getInstance() {
        return instance;
    }

    public void marshall(KeyBlockHeaders keyBlockHeaders, ProtocolMarshaller protocolMarshaller) {
        if (keyBlockHeaders == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)keyBlockHeaders.getKeyModesOfUse(), KEYMODESOFUSE_BINDING);
            protocolMarshaller.marshall((Object)keyBlockHeaders.getKeyExportability(), KEYEXPORTABILITY_BINDING);
            protocolMarshaller.marshall((Object)keyBlockHeaders.getKeyVersion(), KEYVERSION_BINDING);
            protocolMarshaller.marshall(keyBlockHeaders.getOptionalBlocks(), OPTIONALBLOCKS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

