/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptography.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.paymentcryptography.model.ExportKeyMaterial;

@SdkInternalApi
public class ExportKeyMaterialMarshaller {
    private static final MarshallingInfo<StructuredPojo> KEYCRYPTOGRAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyCryptogram").build();
    private static final MarshallingInfo<StructuredPojo> TR31KEYBLOCK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tr31KeyBlock").build();
    private static final MarshallingInfo<StructuredPojo> TR34KEYBLOCK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tr34KeyBlock").build();
    private static final ExportKeyMaterialMarshaller instance = new ExportKeyMaterialMarshaller();

    public static ExportKeyMaterialMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExportKeyMaterial exportKeyMaterial, ProtocolMarshaller protocolMarshaller) {
        if (exportKeyMaterial == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)exportKeyMaterial.getKeyCryptogram(), KEYCRYPTOGRAM_BINDING);
            protocolMarshaller.marshall((Object)exportKeyMaterial.getTr31KeyBlock(), TR31KEYBLOCK_BINDING);
            protocolMarshaller.marshall((Object)exportKeyMaterial.getTr34KeyBlock(), TR34KEYBLOCK_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

