/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.panorama.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.panorama.model.NetworkPayload;

@SdkInternalApi
public class NetworkPayloadMarshaller {
    private static final MarshallingInfo<StructuredPojo> ETHERNET0_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ethernet0").build();
    private static final MarshallingInfo<StructuredPojo> ETHERNET1_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ethernet1").build();
    private static final MarshallingInfo<StructuredPojo> NTP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ntp").build();
    private static final NetworkPayloadMarshaller instance = new NetworkPayloadMarshaller();

    public static NetworkPayloadMarshaller getInstance() {
        return instance;
    }

    public void marshall(NetworkPayload networkPayload, ProtocolMarshaller protocolMarshaller) {
        if (networkPayload == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)networkPayload.getEthernet0(), ETHERNET0_BINDING);
            protocolMarshaller.marshall((Object)networkPayload.getEthernet1(), ETHERNET1_BINDING);
            protocolMarshaller.marshall((Object)networkPayload.getNtp(), NTP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

