/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.osis.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.osis.model.VpcAttachmentOptions;
import com.amazonaws.services.osis.model.transform.VpcOptionsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VpcOptions
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> subnetIds;
    private List<String> securityGroupIds;
    private VpcAttachmentOptions vpcAttachmentOptions;

    public List<String> getSubnetIds() {
        return this.subnetIds;
    }

    public void setSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
            return;
        }
        this.subnetIds = new ArrayList<String>(subnetIds);
    }

    public VpcOptions withSubnetIds(String ... subnetIds) {
        if (this.subnetIds == null) {
            this.setSubnetIds(new ArrayList<String>(subnetIds.length));
        }
        for (String ele : subnetIds) {
            this.subnetIds.add(ele);
        }
        return this;
    }

    public VpcOptions withSubnetIds(Collection<String> subnetIds) {
        this.setSubnetIds(subnetIds);
        return this;
    }

    public List<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }
        this.securityGroupIds = new ArrayList<String>(securityGroupIds);
    }

    public VpcOptions withSecurityGroupIds(String ... securityGroupIds) {
        if (this.securityGroupIds == null) {
            this.setSecurityGroupIds(new ArrayList<String>(securityGroupIds.length));
        }
        for (String ele : securityGroupIds) {
            this.securityGroupIds.add(ele);
        }
        return this;
    }

    public VpcOptions withSecurityGroupIds(Collection<String> securityGroupIds) {
        this.setSecurityGroupIds(securityGroupIds);
        return this;
    }

    public void setVpcAttachmentOptions(VpcAttachmentOptions vpcAttachmentOptions) {
        this.vpcAttachmentOptions = vpcAttachmentOptions;
    }

    public VpcAttachmentOptions getVpcAttachmentOptions() {
        return this.vpcAttachmentOptions;
    }

    public VpcOptions withVpcAttachmentOptions(VpcAttachmentOptions vpcAttachmentOptions) {
        this.setVpcAttachmentOptions(vpcAttachmentOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubnetIds() != null) {
            sb.append("SubnetIds: ").append(this.getSubnetIds()).append(",");
        }
        if (this.getSecurityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.getSecurityGroupIds()).append(",");
        }
        if (this.getVpcAttachmentOptions() != null) {
            sb.append("VpcAttachmentOptions: ").append(this.getVpcAttachmentOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcOptions)) {
            return false;
        }
        VpcOptions other = (VpcOptions)obj;
        if (other.getSubnetIds() == null ^ this.getSubnetIds() == null) {
            return false;
        }
        if (other.getSubnetIds() != null && !other.getSubnetIds().equals(this.getSubnetIds())) {
            return false;
        }
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null) {
            return false;
        }
        if (other.getSecurityGroupIds() != null && !other.getSecurityGroupIds().equals(this.getSecurityGroupIds())) {
            return false;
        }
        if (other.getVpcAttachmentOptions() == null ^ this.getVpcAttachmentOptions() == null) {
            return false;
        }
        return other.getVpcAttachmentOptions() == null || other.getVpcAttachmentOptions().equals(this.getVpcAttachmentOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubnetIds() == null ? 0 : this.getSubnetIds().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupIds() == null ? 0 : this.getSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getVpcAttachmentOptions() == null ? 0 : this.getVpcAttachmentOptions().hashCode());
        return hashCode;
    }

    public VpcOptions clone() {
        try {
            return (VpcOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VpcOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

