/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ebs.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ebs-2019-11-02/StartSnapshot" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class StartSnapshotRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The size of the volume, in GiB. The maximum size is <code>65536</code> GiB (64 TiB).
     * </p>
     */
    private Long volumeSize;
    /**
     * <p>
     * The ID of the parent snapshot. If there is no parent snapshot, or if you are creating the first snapshot for an
     * on-premises volume, omit this parameter.
     * </p>
     * <p>
     * If your account is enabled for encryption by default, you cannot use an unencrypted snapshot as a parent
     * snapshot. You must first create an encrypted copy of the parent snapshot using <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopySnapshot.html">CopySnapshot</a>.
     * </p>
     */
    private String parentSnapshotId;
    /**
     * <p>
     * The tags to apply to the snapshot.
     * </p>
     */
    private java.util.List<Tag> tags;
    /**
     * <p>
     * A description for the snapshot.
     * </p>
     */
    private String description;
    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully. The subsequent retries with the same client token return the result from the original successful
     * request and they have no additional effect.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-direct-api-idempotency.html"> Idempotency for
     * StartSnapshot API</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     */
    private String clientToken;
    /**
     * <p>
     * Indicates whether to encrypt the snapshot. To create an encrypted snapshot, specify <code>true</code>. To create
     * an unencrypted snapshot, omit this parameter.
     * </p>
     * <p>
     * If you specify a value for <b>ParentSnapshotId</b>, omit this parameter.
     * </p>
     * <p>
     * If you specify <code>true</code>, the snapshot is encrypted using the KMS key specified using the
     * <b>KmsKeyArn</b> parameter. If no value is specified for <b>KmsKeyArn</b>, the default KMS key for your account
     * is used. If no default KMS key has been specified for your account, the Amazon Web Services managed KMS key is
     * used. To set a default KMS key for your account, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html">
     * ModifyEbsDefaultKmsKeyId</a>.
     * </p>
     * <p>
     * If your account is enabled for encryption by default, you cannot set this parameter to <code>false</code>. In
     * this case, you can omit this parameter.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-encryption">
     * Using encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     */
    private Boolean encrypted;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Key Management Service (KMS) key to be used to encrypt the snapshot. If you
     * do not specify a KMS key, the default Amazon Web Services managed KMS key is used.
     * </p>
     * <p>
     * If you specify a <b>ParentSnapshotId</b>, omit this parameter; the snapshot will be encrypted using the same KMS
     * key that was used to encrypt the parent snapshot.
     * </p>
     * <p>
     * If <b>Encrypted</b> is set to <code>true</code>, you must specify a KMS key ARN.
     * </p>
     */
    private String kmsKeyArn;
    /**
     * <p>
     * The amount of time (in minutes) after which the snapshot is automatically cancelled if:
     * </p>
     * <ul>
     * <li>
     * <p>
     * No blocks are written to the snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * The snapshot is not completed after writing the last block of data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If no value is specified, the timeout defaults to <code>60</code> minutes.
     * </p>
     */
    private Integer timeout;

    /**
     * <p>
     * The size of the volume, in GiB. The maximum size is <code>65536</code> GiB (64 TiB).
     * </p>
     * 
     * @param volumeSize
     *        The size of the volume, in GiB. The maximum size is <code>65536</code> GiB (64 TiB).
     */

    public void setVolumeSize(Long volumeSize) {
        this.volumeSize = volumeSize;
    }

    /**
     * <p>
     * The size of the volume, in GiB. The maximum size is <code>65536</code> GiB (64 TiB).
     * </p>
     * 
     * @return The size of the volume, in GiB. The maximum size is <code>65536</code> GiB (64 TiB).
     */

    public Long getVolumeSize() {
        return this.volumeSize;
    }

    /**
     * <p>
     * The size of the volume, in GiB. The maximum size is <code>65536</code> GiB (64 TiB).
     * </p>
     * 
     * @param volumeSize
     *        The size of the volume, in GiB. The maximum size is <code>65536</code> GiB (64 TiB).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartSnapshotRequest withVolumeSize(Long volumeSize) {
        setVolumeSize(volumeSize);
        return this;
    }

    /**
     * <p>
     * The ID of the parent snapshot. If there is no parent snapshot, or if you are creating the first snapshot for an
     * on-premises volume, omit this parameter.
     * </p>
     * <p>
     * If your account is enabled for encryption by default, you cannot use an unencrypted snapshot as a parent
     * snapshot. You must first create an encrypted copy of the parent snapshot using <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopySnapshot.html">CopySnapshot</a>.
     * </p>
     * 
     * @param parentSnapshotId
     *        The ID of the parent snapshot. If there is no parent snapshot, or if you are creating the first snapshot
     *        for an on-premises volume, omit this parameter.</p>
     *        <p>
     *        If your account is enabled for encryption by default, you cannot use an unencrypted snapshot as a parent
     *        snapshot. You must first create an encrypted copy of the parent snapshot using <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopySnapshot.html">CopySnapshot</a>.
     */

    public void setParentSnapshotId(String parentSnapshotId) {
        this.parentSnapshotId = parentSnapshotId;
    }

    /**
     * <p>
     * The ID of the parent snapshot. If there is no parent snapshot, or if you are creating the first snapshot for an
     * on-premises volume, omit this parameter.
     * </p>
     * <p>
     * If your account is enabled for encryption by default, you cannot use an unencrypted snapshot as a parent
     * snapshot. You must first create an encrypted copy of the parent snapshot using <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopySnapshot.html">CopySnapshot</a>.
     * </p>
     * 
     * @return The ID of the parent snapshot. If there is no parent snapshot, or if you are creating the first snapshot
     *         for an on-premises volume, omit this parameter.</p>
     *         <p>
     *         If your account is enabled for encryption by default, you cannot use an unencrypted snapshot as a parent
     *         snapshot. You must first create an encrypted copy of the parent snapshot using <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopySnapshot.html">CopySnapshot</a>.
     */

    public String getParentSnapshotId() {
        return this.parentSnapshotId;
    }

    /**
     * <p>
     * The ID of the parent snapshot. If there is no parent snapshot, or if you are creating the first snapshot for an
     * on-premises volume, omit this parameter.
     * </p>
     * <p>
     * If your account is enabled for encryption by default, you cannot use an unencrypted snapshot as a parent
     * snapshot. You must first create an encrypted copy of the parent snapshot using <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopySnapshot.html">CopySnapshot</a>.
     * </p>
     * 
     * @param parentSnapshotId
     *        The ID of the parent snapshot. If there is no parent snapshot, or if you are creating the first snapshot
     *        for an on-premises volume, omit this parameter.</p>
     *        <p>
     *        If your account is enabled for encryption by default, you cannot use an unencrypted snapshot as a parent
     *        snapshot. You must first create an encrypted copy of the parent snapshot using <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopySnapshot.html">CopySnapshot</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartSnapshotRequest withParentSnapshotId(String parentSnapshotId) {
        setParentSnapshotId(parentSnapshotId);
        return this;
    }

    /**
     * <p>
     * The tags to apply to the snapshot.
     * </p>
     * 
     * @return The tags to apply to the snapshot.
     */

    public java.util.List<Tag> getTags() {
        return tags;
    }

    /**
     * <p>
     * The tags to apply to the snapshot.
     * </p>
     * 
     * @param tags
     *        The tags to apply to the snapshot.
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new java.util.ArrayList<Tag>(tags);
    }

    /**
     * <p>
     * The tags to apply to the snapshot.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     *        The tags to apply to the snapshot.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartSnapshotRequest withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new java.util.ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The tags to apply to the snapshot.
     * </p>
     * 
     * @param tags
     *        The tags to apply to the snapshot.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartSnapshotRequest withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * <p>
     * A description for the snapshot.
     * </p>
     * 
     * @param description
     *        A description for the snapshot.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * A description for the snapshot.
     * </p>
     * 
     * @return A description for the snapshot.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * A description for the snapshot.
     * </p>
     * 
     * @param description
     *        A description for the snapshot.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartSnapshotRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully. The subsequent retries with the same client token return the result from the original successful
     * request and they have no additional effect.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-direct-api-idempotency.html"> Idempotency for
     * StartSnapshot API</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     *        ensures that an API request completes only once. With an idempotent request, if the original request
     *        completes successfully. The subsequent retries with the same client token return the result from the
     *        original successful request and they have no additional effect.</p>
     *        <p>
     *        If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     *        </p>
     *        <p>
     *        For more information, see <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-direct-api-idempotency.html"> Idempotency
     *        for StartSnapshot API</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully. The subsequent retries with the same client token return the result from the original successful
     * request and they have no additional effect.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-direct-api-idempotency.html"> Idempotency for
     * StartSnapshot API</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully. The subsequent retries with the same client token return the result from
     *         the original successful request and they have no additional effect.</p>
     *         <p>
     *         If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-direct-api-idempotency.html"> Idempotency
     *         for StartSnapshot API</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */

    public String getClientToken() {
        return this.clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully. The subsequent retries with the same client token return the result from the original successful
     * request and they have no additional effect.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-direct-api-idempotency.html"> Idempotency for
     * StartSnapshot API</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     *        ensures that an API request completes only once. With an idempotent request, if the original request
     *        completes successfully. The subsequent retries with the same client token return the result from the
     *        original successful request and they have no additional effect.</p>
     *        <p>
     *        If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     *        </p>
     *        <p>
     *        For more information, see <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-direct-api-idempotency.html"> Idempotency
     *        for StartSnapshot API</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartSnapshotRequest withClientToken(String clientToken) {
        setClientToken(clientToken);
        return this;
    }

    /**
     * <p>
     * Indicates whether to encrypt the snapshot. To create an encrypted snapshot, specify <code>true</code>. To create
     * an unencrypted snapshot, omit this parameter.
     * </p>
     * <p>
     * If you specify a value for <b>ParentSnapshotId</b>, omit this parameter.
     * </p>
     * <p>
     * If you specify <code>true</code>, the snapshot is encrypted using the KMS key specified using the
     * <b>KmsKeyArn</b> parameter. If no value is specified for <b>KmsKeyArn</b>, the default KMS key for your account
     * is used. If no default KMS key has been specified for your account, the Amazon Web Services managed KMS key is
     * used. To set a default KMS key for your account, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html">
     * ModifyEbsDefaultKmsKeyId</a>.
     * </p>
     * <p>
     * If your account is enabled for encryption by default, you cannot set this parameter to <code>false</code>. In
     * this case, you can omit this parameter.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-encryption">
     * Using encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param encrypted
     *        Indicates whether to encrypt the snapshot. To create an encrypted snapshot, specify <code>true</code>. To
     *        create an unencrypted snapshot, omit this parameter.</p>
     *        <p>
     *        If you specify a value for <b>ParentSnapshotId</b>, omit this parameter.
     *        </p>
     *        <p>
     *        If you specify <code>true</code>, the snapshot is encrypted using the KMS key specified using the
     *        <b>KmsKeyArn</b> parameter. If no value is specified for <b>KmsKeyArn</b>, the default KMS key for your
     *        account is used. If no default KMS key has been specified for your account, the Amazon Web Services
     *        managed KMS key is used. To set a default KMS key for your account, use <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html">
     *        ModifyEbsDefaultKmsKeyId</a>.
     *        </p>
     *        <p>
     *        If your account is enabled for encryption by default, you cannot set this parameter to <code>false</code>.
     *        In this case, you can omit this parameter.
     *        </p>
     *        <p>
     *        For more information, see <a href=
     *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-encryption"
     *        > Using encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */

    public void setEncrypted(Boolean encrypted) {
        this.encrypted = encrypted;
    }

    /**
     * <p>
     * Indicates whether to encrypt the snapshot. To create an encrypted snapshot, specify <code>true</code>. To create
     * an unencrypted snapshot, omit this parameter.
     * </p>
     * <p>
     * If you specify a value for <b>ParentSnapshotId</b>, omit this parameter.
     * </p>
     * <p>
     * If you specify <code>true</code>, the snapshot is encrypted using the KMS key specified using the
     * <b>KmsKeyArn</b> parameter. If no value is specified for <b>KmsKeyArn</b>, the default KMS key for your account
     * is used. If no default KMS key has been specified for your account, the Amazon Web Services managed KMS key is
     * used. To set a default KMS key for your account, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html">
     * ModifyEbsDefaultKmsKeyId</a>.
     * </p>
     * <p>
     * If your account is enabled for encryption by default, you cannot set this parameter to <code>false</code>. In
     * this case, you can omit this parameter.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-encryption">
     * Using encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Indicates whether to encrypt the snapshot. To create an encrypted snapshot, specify <code>true</code>. To
     *         create an unencrypted snapshot, omit this parameter.</p>
     *         <p>
     *         If you specify a value for <b>ParentSnapshotId</b>, omit this parameter.
     *         </p>
     *         <p>
     *         If you specify <code>true</code>, the snapshot is encrypted using the KMS key specified using the
     *         <b>KmsKeyArn</b> parameter. If no value is specified for <b>KmsKeyArn</b>, the default KMS key for your
     *         account is used. If no default KMS key has been specified for your account, the Amazon Web Services
     *         managed KMS key is used. To set a default KMS key for your account, use <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html">
     *         ModifyEbsDefaultKmsKeyId</a>.
     *         </p>
     *         <p>
     *         If your account is enabled for encryption by default, you cannot set this parameter to <code>false</code>
     *         . In this case, you can omit this parameter.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-encryption"
     *         > Using encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */

    public Boolean getEncrypted() {
        return this.encrypted;
    }

    /**
     * <p>
     * Indicates whether to encrypt the snapshot. To create an encrypted snapshot, specify <code>true</code>. To create
     * an unencrypted snapshot, omit this parameter.
     * </p>
     * <p>
     * If you specify a value for <b>ParentSnapshotId</b>, omit this parameter.
     * </p>
     * <p>
     * If you specify <code>true</code>, the snapshot is encrypted using the KMS key specified using the
     * <b>KmsKeyArn</b> parameter. If no value is specified for <b>KmsKeyArn</b>, the default KMS key for your account
     * is used. If no default KMS key has been specified for your account, the Amazon Web Services managed KMS key is
     * used. To set a default KMS key for your account, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html">
     * ModifyEbsDefaultKmsKeyId</a>.
     * </p>
     * <p>
     * If your account is enabled for encryption by default, you cannot set this parameter to <code>false</code>. In
     * this case, you can omit this parameter.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-encryption">
     * Using encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param encrypted
     *        Indicates whether to encrypt the snapshot. To create an encrypted snapshot, specify <code>true</code>. To
     *        create an unencrypted snapshot, omit this parameter.</p>
     *        <p>
     *        If you specify a value for <b>ParentSnapshotId</b>, omit this parameter.
     *        </p>
     *        <p>
     *        If you specify <code>true</code>, the snapshot is encrypted using the KMS key specified using the
     *        <b>KmsKeyArn</b> parameter. If no value is specified for <b>KmsKeyArn</b>, the default KMS key for your
     *        account is used. If no default KMS key has been specified for your account, the Amazon Web Services
     *        managed KMS key is used. To set a default KMS key for your account, use <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html">
     *        ModifyEbsDefaultKmsKeyId</a>.
     *        </p>
     *        <p>
     *        If your account is enabled for encryption by default, you cannot set this parameter to <code>false</code>.
     *        In this case, you can omit this parameter.
     *        </p>
     *        <p>
     *        For more information, see <a href=
     *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-encryption"
     *        > Using encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartSnapshotRequest withEncrypted(Boolean encrypted) {
        setEncrypted(encrypted);
        return this;
    }

    /**
     * <p>
     * Indicates whether to encrypt the snapshot. To create an encrypted snapshot, specify <code>true</code>. To create
     * an unencrypted snapshot, omit this parameter.
     * </p>
     * <p>
     * If you specify a value for <b>ParentSnapshotId</b>, omit this parameter.
     * </p>
     * <p>
     * If you specify <code>true</code>, the snapshot is encrypted using the KMS key specified using the
     * <b>KmsKeyArn</b> parameter. If no value is specified for <b>KmsKeyArn</b>, the default KMS key for your account
     * is used. If no default KMS key has been specified for your account, the Amazon Web Services managed KMS key is
     * used. To set a default KMS key for your account, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html">
     * ModifyEbsDefaultKmsKeyId</a>.
     * </p>
     * <p>
     * If your account is enabled for encryption by default, you cannot set this parameter to <code>false</code>. In
     * this case, you can omit this parameter.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-encryption">
     * Using encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Indicates whether to encrypt the snapshot. To create an encrypted snapshot, specify <code>true</code>. To
     *         create an unencrypted snapshot, omit this parameter.</p>
     *         <p>
     *         If you specify a value for <b>ParentSnapshotId</b>, omit this parameter.
     *         </p>
     *         <p>
     *         If you specify <code>true</code>, the snapshot is encrypted using the KMS key specified using the
     *         <b>KmsKeyArn</b> parameter. If no value is specified for <b>KmsKeyArn</b>, the default KMS key for your
     *         account is used. If no default KMS key has been specified for your account, the Amazon Web Services
     *         managed KMS key is used. To set a default KMS key for your account, use <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html">
     *         ModifyEbsDefaultKmsKeyId</a>.
     *         </p>
     *         <p>
     *         If your account is enabled for encryption by default, you cannot set this parameter to <code>false</code>
     *         . In this case, you can omit this parameter.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-encryption"
     *         > Using encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */

    public Boolean isEncrypted() {
        return this.encrypted;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Key Management Service (KMS) key to be used to encrypt the snapshot. If you
     * do not specify a KMS key, the default Amazon Web Services managed KMS key is used.
     * </p>
     * <p>
     * If you specify a <b>ParentSnapshotId</b>, omit this parameter; the snapshot will be encrypted using the same KMS
     * key that was used to encrypt the parent snapshot.
     * </p>
     * <p>
     * If <b>Encrypted</b> is set to <code>true</code>, you must specify a KMS key ARN.
     * </p>
     * 
     * @param kmsKeyArn
     *        The Amazon Resource Name (ARN) of the Key Management Service (KMS) key to be used to encrypt the snapshot.
     *        If you do not specify a KMS key, the default Amazon Web Services managed KMS key is used.</p>
     *        <p>
     *        If you specify a <b>ParentSnapshotId</b>, omit this parameter; the snapshot will be encrypted using the
     *        same KMS key that was used to encrypt the parent snapshot.
     *        </p>
     *        <p>
     *        If <b>Encrypted</b> is set to <code>true</code>, you must specify a KMS key ARN.
     */

    public void setKmsKeyArn(String kmsKeyArn) {
        this.kmsKeyArn = kmsKeyArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Key Management Service (KMS) key to be used to encrypt the snapshot. If you
     * do not specify a KMS key, the default Amazon Web Services managed KMS key is used.
     * </p>
     * <p>
     * If you specify a <b>ParentSnapshotId</b>, omit this parameter; the snapshot will be encrypted using the same KMS
     * key that was used to encrypt the parent snapshot.
     * </p>
     * <p>
     * If <b>Encrypted</b> is set to <code>true</code>, you must specify a KMS key ARN.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Key Management Service (KMS) key to be used to encrypt the
     *         snapshot. If you do not specify a KMS key, the default Amazon Web Services managed KMS key is used.</p>
     *         <p>
     *         If you specify a <b>ParentSnapshotId</b>, omit this parameter; the snapshot will be encrypted using the
     *         same KMS key that was used to encrypt the parent snapshot.
     *         </p>
     *         <p>
     *         If <b>Encrypted</b> is set to <code>true</code>, you must specify a KMS key ARN.
     */

    public String getKmsKeyArn() {
        return this.kmsKeyArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Key Management Service (KMS) key to be used to encrypt the snapshot. If you
     * do not specify a KMS key, the default Amazon Web Services managed KMS key is used.
     * </p>
     * <p>
     * If you specify a <b>ParentSnapshotId</b>, omit this parameter; the snapshot will be encrypted using the same KMS
     * key that was used to encrypt the parent snapshot.
     * </p>
     * <p>
     * If <b>Encrypted</b> is set to <code>true</code>, you must specify a KMS key ARN.
     * </p>
     * 
     * @param kmsKeyArn
     *        The Amazon Resource Name (ARN) of the Key Management Service (KMS) key to be used to encrypt the snapshot.
     *        If you do not specify a KMS key, the default Amazon Web Services managed KMS key is used.</p>
     *        <p>
     *        If you specify a <b>ParentSnapshotId</b>, omit this parameter; the snapshot will be encrypted using the
     *        same KMS key that was used to encrypt the parent snapshot.
     *        </p>
     *        <p>
     *        If <b>Encrypted</b> is set to <code>true</code>, you must specify a KMS key ARN.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartSnapshotRequest withKmsKeyArn(String kmsKeyArn) {
        setKmsKeyArn(kmsKeyArn);
        return this;
    }

    /**
     * <p>
     * The amount of time (in minutes) after which the snapshot is automatically cancelled if:
     * </p>
     * <ul>
     * <li>
     * <p>
     * No blocks are written to the snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * The snapshot is not completed after writing the last block of data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If no value is specified, the timeout defaults to <code>60</code> minutes.
     * </p>
     * 
     * @param timeout
     *        The amount of time (in minutes) after which the snapshot is automatically cancelled if:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        No blocks are written to the snapshot.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The snapshot is not completed after writing the last block of data.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        If no value is specified, the timeout defaults to <code>60</code> minutes.
     */

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    /**
     * <p>
     * The amount of time (in minutes) after which the snapshot is automatically cancelled if:
     * </p>
     * <ul>
     * <li>
     * <p>
     * No blocks are written to the snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * The snapshot is not completed after writing the last block of data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If no value is specified, the timeout defaults to <code>60</code> minutes.
     * </p>
     * 
     * @return The amount of time (in minutes) after which the snapshot is automatically cancelled if:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No blocks are written to the snapshot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The snapshot is not completed after writing the last block of data.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If no value is specified, the timeout defaults to <code>60</code> minutes.
     */

    public Integer getTimeout() {
        return this.timeout;
    }

    /**
     * <p>
     * The amount of time (in minutes) after which the snapshot is automatically cancelled if:
     * </p>
     * <ul>
     * <li>
     * <p>
     * No blocks are written to the snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * The snapshot is not completed after writing the last block of data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If no value is specified, the timeout defaults to <code>60</code> minutes.
     * </p>
     * 
     * @param timeout
     *        The amount of time (in minutes) after which the snapshot is automatically cancelled if:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        No blocks are written to the snapshot.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The snapshot is not completed after writing the last block of data.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        If no value is specified, the timeout defaults to <code>60</code> minutes.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartSnapshotRequest withTimeout(Integer timeout) {
        setTimeout(timeout);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getVolumeSize() != null)
            sb.append("VolumeSize: ").append(getVolumeSize()).append(",");
        if (getParentSnapshotId() != null)
            sb.append("ParentSnapshotId: ").append(getParentSnapshotId()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getClientToken() != null)
            sb.append("ClientToken: ").append(getClientToken()).append(",");
        if (getEncrypted() != null)
            sb.append("Encrypted: ").append(getEncrypted()).append(",");
        if (getKmsKeyArn() != null)
            sb.append("KmsKeyArn: ").append("***Sensitive Data Redacted***").append(",");
        if (getTimeout() != null)
            sb.append("Timeout: ").append(getTimeout());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof StartSnapshotRequest == false)
            return false;
        StartSnapshotRequest other = (StartSnapshotRequest) obj;
        if (other.getVolumeSize() == null ^ this.getVolumeSize() == null)
            return false;
        if (other.getVolumeSize() != null && other.getVolumeSize().equals(this.getVolumeSize()) == false)
            return false;
        if (other.getParentSnapshotId() == null ^ this.getParentSnapshotId() == null)
            return false;
        if (other.getParentSnapshotId() != null && other.getParentSnapshotId().equals(this.getParentSnapshotId()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getClientToken() == null ^ this.getClientToken() == null)
            return false;
        if (other.getClientToken() != null && other.getClientToken().equals(this.getClientToken()) == false)
            return false;
        if (other.getEncrypted() == null ^ this.getEncrypted() == null)
            return false;
        if (other.getEncrypted() != null && other.getEncrypted().equals(this.getEncrypted()) == false)
            return false;
        if (other.getKmsKeyArn() == null ^ this.getKmsKeyArn() == null)
            return false;
        if (other.getKmsKeyArn() != null && other.getKmsKeyArn().equals(this.getKmsKeyArn()) == false)
            return false;
        if (other.getTimeout() == null ^ this.getTimeout() == null)
            return false;
        if (other.getTimeout() != null && other.getTimeout().equals(this.getTimeout()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getVolumeSize() == null) ? 0 : getVolumeSize().hashCode());
        hashCode = prime * hashCode + ((getParentSnapshotId() == null) ? 0 : getParentSnapshotId().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getClientToken() == null) ? 0 : getClientToken().hashCode());
        hashCode = prime * hashCode + ((getEncrypted() == null) ? 0 : getEncrypted().hashCode());
        hashCode = prime * hashCode + ((getKmsKeyArn() == null) ? 0 : getKmsKeyArn().hashCode());
        hashCode = prime * hashCode + ((getTimeout() == null) ? 0 : getTimeout().hashCode());
        return hashCode;
    }

    @Override
    public StartSnapshotRequest clone() {
        return (StartSnapshotRequest) super.clone();
    }

}
